﻿Imports Automation.BDaq

Public Class StaticDIForm

    Dim DIO_DEVICE_DESCRIPTION As String = "PFI-27D24DI,BID#0"

    Dim DIO_START_PORT As Int16 = 0

    Dim mDICtrl As InstantDiCtrl

    Dim mDioPics(2, 7) As PictureBox

    Private Sub StaticDIForm_Load(sender As Object, e As EventArgs) Handles MyBase.Load

        InitPFIDevice()
        CheckIfDeviceInitialized()
        StartAppSetting()

    End Sub

    Private Sub InitPFIDevice()

        Dim deviceInformation As DeviceInformation

        deviceInformation = New DeviceInformation(DIO_DEVICE_DESCRIPTION)
        mDICtrl = New InstantDiCtrl()

        deviceInformation.DeviceMode = AccessMode.ModeWrite

        Try
            mDICtrl.SelectedDevice() = deviceInformation
        Catch ex As Exception
            MessageBox.Show(ex.Message, "StaticDI")
            Me.Close()
            Return
        End Try
    End Sub

    Private Sub CheckIfDeviceInitialized()
        If mDICtrl.Initialized = False Then
            MessageBox.Show("No device be selected or device open failed!", "StaticDI")
            Me.Close()
        End If
    End Sub

    Private Sub StartAppSetting()

        mDioPics(0, 0) = mPicBoxPort0Led0
        mDioPics(0, 1) = mPicBoxPort0Led1
        mDioPics(0, 2) = mPicBoxPort0Led2
        mDioPics(0, 3) = mPicBoxPort0Led3
        mDioPics(0, 4) = mPicBoxPort0Led4
        mDioPics(0, 5) = mPicBoxPort0Led5
        mDioPics(0, 6) = mPicBoxPort0Led6
        mDioPics(0, 7) = mPicBoxPort0Led7

        mDioPics(1, 0) = mPicBoxPort1Led0
        mDioPics(1, 1) = mPicBoxPort1Led1
        mDioPics(1, 2) = mPicBoxPort1Led2
        mDioPics(1, 3) = mPicBoxPort1Led3
        mDioPics(1, 4) = mPicBoxPort1Led4
        mDioPics(1, 5) = mPicBoxPort1Led5
        mDioPics(1, 6) = mPicBoxPort1Led6
        mDioPics(1, 7) = mPicBoxPort1Led7

        Me.Text = "Static DI(" & mDICtrl.SelectedDevice.Description & ")"
        mTimerForDI.Enabled = True

    End Sub

    Private Sub mTimerForDI_Tick(sender As Object, e As EventArgs) Handles mTimerForDI.Tick

        Dim errCode As ErrorCode = ErrorCode.Success
        Dim portData As Int16 = 0
        Dim dioValue As Int16 = 0
        Dim dioStatus As Int16 = 0

        For i = DIO_START_PORT To mDICtrl.Features.PortCount - 1
            errCode = mDICtrl.Read(i, dioValue)

            ShowHexValue(i, dioValue)

            For j = 0 To 7
                dioStatus = (dioValue >> j) And 1
                ShowLedByDIOValue(i, j, dioStatus)
                'MessageBox.Show(i & "." & j & "." & dioStatus, "")
            Next
        Next

    End Sub

    Private Sub ShowLedByDIOValue(portNum As Int16, dioPinNumber As Int16, dioValue As Int16)

        Dim showingImage As Image

        If dioValue = 0 Then
            showingImage = My.Resources.ledLow
        Else
            showingImage = My.Resources.ledHigh
        End If

        mDioPics(portNum, dioPinNumber).Image = showingImage

    End Sub

    Private Sub ShowHexValue(portNum As Int16, value As Int16)

        If portNum = 0 Then
            mLblHex0.Text = value.ToString("X2")
        Else
            mLblHex1.Text = value.ToString("X2")
        End If

    End Sub

End Class
