﻿Imports Automation.BDaq
Public Class StaticDOForm

    Dim DIO_DEVICE_DESCRIPTION As String = "PFI-27D24DI,BID#0"

    Dim DIO_START_PORT As Int16 = 0

    Dim mDOCtrl As InstantDoCtrl

    Dim mDioPics(7) As PictureBox

    Private Sub StaticDOForm_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        InitPFIDevice()
        CheckIfDeviceInitialized()
        StartAppSetting()
    End Sub
    Private Sub InitPFIDevice()

        Dim deviceInformation As DeviceInformation

        deviceInformation = New DeviceInformation(DIO_DEVICE_DESCRIPTION)
        mDOCtrl = New InstantDoCtrl()

        deviceInformation.DeviceMode = AccessMode.ModeWrite

        Try
            mDOCtrl.SelectedDevice() = deviceInformation
        Catch ex As Exception
            MessageBox.Show(ex.Message, "StaticDO")
            Me.Close()
            Return
        End Try
    End Sub

    Private Sub CheckIfDeviceInitialized()
        If mDOCtrl.Initialized = False Then
            MessageBox.Show("No device be selected or device open failed!", "StaticDI")
            Me.Close()
        End If
    End Sub
    Private Sub StartAppSetting()

        mDioPics(0) = mPicBoxPort0Led0
        mDioPics(1) = mPicBoxPort0Led1
        mDioPics(2) = mPicBoxPort0Led2
        mDioPics(3) = mPicBoxPort0Led3
        mDioPics(4) = mPicBoxPort0Led4
        mDioPics(5) = mPicBoxPort0Led5
        mDioPics(6) = mPicBoxPort0Led6
        mDioPics(7) = mPicBoxPort0Led7

        AddHandler mPicBoxPort0Led0.Click, AddressOf Me.Pic_Click
        AddHandler mPicBoxPort0Led1.Click, AddressOf Me.Pic_Click
        AddHandler mPicBoxPort0Led2.Click, AddressOf Me.Pic_Click
        AddHandler mPicBoxPort0Led3.Click, AddressOf Me.Pic_Click
        AddHandler mPicBoxPort0Led4.Click, AddressOf Me.Pic_Click
        AddHandler mPicBoxPort0Led5.Click, AddressOf Me.Pic_Click
        AddHandler mPicBoxPort0Led6.Click, AddressOf Me.Pic_Click
        AddHandler mPicBoxPort0Led7.Click, AddressOf Me.Pic_Click

        Me.Text = "Static DO(" & mDOCtrl.SelectedDevice.Description & ")"

        InitializePortState()

    End Sub
    Private Sub ShowHexValue(value As Int16)

        mLblHex0.Text = value.ToString("X2")

    End Sub
    Private Sub InitializePortState()
        Dim portDirection As Int16 = -1
        Dim errCode As ErrorCode = ErrorCode.Success
        Dim dioValue As Int16 = 0
        Dim dioStatus As Int16 = 0

        Dim mask() As Byte = mDOCtrl.Features.DataMask

        For i = 0 To 0

            dioValue = GetDOPortData(i)
            ShowHexValue(dioValue)

            If (mDOCtrl.PortDirection IsNot Nothing) Then
                portDirection = mDOCtrl.PortDirection(i).Direction
            End If

            For j = 0 To 7

                dioStatus = (dioValue >> j) And 1

                If (((portDirection >> j) And 1) = 0) Or ((mask(0) >> j) And 1) = 0 Then
                    mDioPics(j).Image = My.Resources.ButtonDisabled
                    mDioPics(j).Enabled = False
                Else
                    mDioPics(j).Tag = dioStatus

                    If (dioStatus = 0) Then
                        mDioPics(j).Image = My.Resources.ButtonUp
                    Else
                        mDioPics(j).Image = My.Resources.ButtonDown
                    End If
                End If
            Next
        Next

    End Sub

    Private Function GetDOPortData(port As Integer) As Int16
        Dim errCode As ErrorCode = ErrorCode.Success
        Dim dioValue As Int16 = 0

        errCode = mDOCtrl.Read(port, dioValue)
        GetDOPortData = dioValue
    End Function

    Private Sub SetDO(port As Int16, pin As Int16, value As Int16)

        Dim portData As Int16
        Dim newPortData As Int16

        portData = GetDOPortData(port)

        newPortData = portData Xor (value << pin)
        mDOCtrl.Write(port, newPortData)

    End Sub

    Private Sub Pic_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        Dim doPic As PictureBox
        Dim portData As Int16
        Dim picIndex As Int16

        doPic = sender

        If (doPic.Tag = 0) Then
            doPic.Tag = 1
            doPic.Image = My.Resources.ButtonDown
        Else
            doPic.Tag = 0
            doPic.Image = My.Resources.ButtonUp
        End If

        picIndex = doPic.Name.Substring(15, 1)
        SetDO(0, picIndex, 1)

        portData = GetDOPortData(0)
        ShowHexValue(GetDOPortData(0))

    End Sub
End Class
