/*******************************************************************************

  This software program is available to you under a choice of one of two
  licenses. You may choose to be licensed under either the GNU General Public
  License 2.0, June 1991, available at http://www.fsf.org/copyleft/gpl.html,
  or the Intel BSD + Patent License, the text of which follows:
  
  Recipient has requested a license and Intel Corporation ("Intel") is willing
  to grant a license for the software entitled Linux Base Driver for the
  Intel(R) PRO/1000 Family of Adapters (e1000) (the "Software") being provided
  by Intel Corporation. The following definitions apply to this license:
  
  "Licensed Patents" means patent claims licensable by Intel Corporation which
  are necessarily infringed by the use of sale of the Software alone or when
  combined with the operating system referred to below.
  
  "Recipient" means the party to whom Intel delivers this Software.
  
  "Licensee" means Recipient and those third parties that receive a license to
  any operating system available under the GNU General Public License 2.0 or
  later.
  
  Copyright (c) 1999 - 2002 Intel Corporation.
  All rights reserved.
  
  The license is provided to Recipient and Recipient's Licensees under the
  following terms.
  
  Redistribution and use in source and binary forms of the Software, with or
  without modification, are permitted provided that the following conditions
  are met:
  
  Redistributions of source code of the Software may retain the above
  copyright notice, this list of conditions and the following disclaimer.
  
  Redistributions in binary form of the Software may reproduce the above
  copyright notice, this list of conditions and the following disclaimer in
  the documentation and/or materials provided with the distribution.
  
  Neither the name of Intel Corporation nor the names of its contributors
  shall be used to endorse or promote products derived from this Software
  without specific prior written permission.
  
  Intel hereby grants Recipient and Licensees a non-exclusive, worldwide,
  royalty-free patent license under Licensed Patents to make, use, sell, offer
  to sell, import and otherwise transfer the Software, if any, in source code
  and object code form. This license shall include changes to the Software
  that are error corrections or other minor changes to the Software that do
  not add functionality or features when the Software is incorporated in any
  version of an operating system that has been distributed under the GNU
  General Public License 2.0 or later. This patent license shall apply to the
  combination of the Software and any operating system licensed under the GNU
  General Public License 2.0 or later if, at the time Intel provides the
  Software to Recipient, such addition of the Software to the then publicly
  available versions of such operating systems available under the GNU General
  Public License 2.0 or later (whether in gold, beta or alpha form) causes
  such combination to be covered by the Licensed Patents. The patent license
  shall not apply to any other combinations which include the Software. NO
  hardware per se is licensed hereunder.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MECHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL INTEL OR IT CONTRIBUTORS BE LIABLE FOR ANY
  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  (INCLUDING, BUT NOT LIMITED, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  ANY LOSS OF USE; DATA, OR PROFITS; OR BUSINESS INTERUPTION) HOWEVER CAUSED
  AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY OR
  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*******************************************************************************/

#ifndef _IDIAG_E1000_H
#define _IDIAG_E1000_H

/* Unique base driver identifier */

#define IDIAG_E1000_DRIVER                      0x02

/* e1000 diagnostic commands */

#define IDIAG_E1000_DIAG_REG_TEST               0x01
#define IDIAG_E1000_DIAG_XSUM_TEST              0x03
#define IDIAG_E1000_DIAG_INTR_TEST              0x04
#define IDIAG_E1000_DIAG_LOOPBACK_TEST          0x05
#define IDIAG_E1000_DIAG_LINK_TEST              0x06

struct idiag_e1000_diag_reg_test_param {
	uint16_t reg;
	uint16_t pad;
	uint32_t write_value;
	uint32_t read_value;
};


struct idiag_e1000_diag_eeprom_test_param {
	uint32_t expected_checksum;
	uint32_t actual_checksum;
};

enum idiag_e1000_diag_intr_test_param {
	IDIAG_E1000_INTR_TEST_OK,
	IDIAG_E1000_INTR_TEST_NOT_EXEC,
	IDIAG_E1000_INTR_TEST_FAILED_WHILE_DISABLED,
	IDIAG_E1000_INTR_TEST_FAILED_WHILE_ENABLED,
	IDIAG_E1000_INTR_TEST_FAILED_MASKED_ENABLED
};

enum idiag_e1000_diag_loopback_mode {
	IDIAG_E1000_DIAG_NONE_LB = 0,
	IDIAG_E1000_DIAG_MAC_LB,
	IDIAG_E1000_DIAG_PHY_TCVR_LB,
};

enum idiag_e1000_diag_loopback_result {
	IDIAG_E1000_LOOPBACK_TEST_OK,
	IDIAG_E1000_LOOPBACK_TEST_NOT_EXEC,
	IDIAG_E1000_LOOPBACK_TEST_FAILED
};

struct idiag_e1000_diag_loopback_test_param {
	enum idiag_e1000_diag_loopback_mode mode;
	enum idiag_e1000_diag_loopback_result result;
};

#endif /* _IDIAG_E1000_H */
