%define version 2.0.30

Name: e100
Summary: Intel(R) PRO/100 driver for Linux
Version: %{version}	
Release: 1
Source: %{name}-%{version}.tar.gz
Vendor: Intel Corporation
License: Dual GPL / BSD + patent grant
ExclusiveOS: linux
Group: System Environment/Kernel
Provides: %{name}
Requires: kudzu, pciutils, kernel
URL: http://support.intel.com/support/go/linux/e100.htm
BuildRoot: /var/tmp/%{name}-%{PACKAGE_VERSION}-root

%description
Linux drivers for the Intel(R) PRO/100 Family of Adapters.

%prep
%setup

%build
mkdir -p $RPM_BUILD_ROOT

TestForRedHatKernel () {
	if [ -e /etc/redhat-release ] ; then
		RH=1
		RHKL=$(grep 'BOOT_KERNEL_.* [01]' /boot/kernel.h |
               sed 's/.*BOOT_KERNEL_\(.*\) [01]/\1/')
	else
		RH=0
	fi
}

SwitchRHKernel () {
	KH="/boot/kernel.h"
	TMP="$RPM_BUILD_ROOT/kernel.h_$1"
	for K in $RHKL ; do
		if [ $K == $1 ] ; then
			sed "s/BOOT_KERNEL_$K [01]/BOOT_KERNEL_$K 1/" $KH > $TMP
		else
			sed "s/BOOT_KERNEL_$K [01]/BOOT_KERNEL_$K 0/" $KH > $TMP
		fi
		cp $TMP $KH
	done
}

TestForRedHatKernel

if [ $RH == "0" ] ; then
	make -C src clean
	make -C src INSTALL_MOD_PATH=$RPM_BUILD_ROOT MANDIR=%{_mandir} install
else
	cp /boot/kernel.h $RPM_BUILD_ROOT/kernel.h.orig
	for K in $RHKL ; do
		SwitchRHKernel $K
		make -C src clean
		make -C src INSTALL_MOD_PATH=$RPM_BUILD_ROOT MANDIR=%{_mandir} install
	done
	mv -f $RPM_BUILD_ROOT/kernel.h.orig /boot/kernel.h
fi

%install
driver="e100"
moddirs="/lib/modules/2.4.7-10/kernel/drivers/net \
         /lib/modules/2.4.7-10smp/kernel/drivers/net \
         /lib/modules/2.4.7-10enterprise/kernel/drivers/net"

# Move the previous modules to backup.
for dir in $moddirs; do
        if [ -f $dir/$driver.o ] && ! [ -h $dir/$driver.o ]; then
                mv -f $dir/$driver.o $dir/$driver.OLD
                echo -e "  Previous driver saved as $dir/$driver.OLD"
        fi
done

find $RPM_BUILD_ROOT -name modules.* -exec rm -f {} \;

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
/lib/modules/*
%{_mandir}/*
%doc LICENSE
%doc e100.txt
%doc ldistrib.txt

%post
# If any adapters are configured to use eepro100, reconfigure to use e100.
if ( grep eepro100 /etc/modules.conf > /dev/null 2>&1 ); then
	mv -f /etc/modules.conf /etc/modules.conf.OLD
	sed -e s/eepro100/e100/g /etc/modules.conf.OLD >> /etc/modules.conf
else
	rm -f /etc/modules.conf.OLD
fi

# Update Kudzu's device table such that future devices will use e100,
# not eepro100.
if ( grep eepro100 /usr/share/kudzu/pcitable > /dev/null 2>&1 ); then
	mv -f /usr/share/kudzu/pcitable /usr/share/kudzu/pcitable.OLD
	sed -e s/eepro100/e100/g /usr/share/kudzu/pcitable.OLD >> /usr/share/kudzu/pcitable
else
	rm -f /usr/share/kudzu/pcitable.OLD
fi

# Make sure we are in a standard kernel before trying to depmod.
# Fixes a factory install issue when installing under BOOT kernel.
kver=$(uname -r)
case $kver in
        2.4.7-10 | 2.4.7-10smp | 2.4.7-10enterprise )
               			 depmod -a
                		;;
esac
exit 0

%postun
################################################################################
# Attempt to restore the previous driver at uninstall time.

driver="e100"
moddirs="/lib/modules/2.4.7-10/kernel/drivers/net \
         /lib/modules/2.4.7-10smp/kernel/drivers/net \
         /lib/modules/2.4.7-10enterprise/kernel/drivers/net"

for dir in $moddirs; do
	if [ -f $dir/$driver.OLD ]; then
		mv -f $dir/$driver.OLD $dir/$driver.o
		echo -e "  Previous driver restored from $dir/$driver.OLD."
	fi
done
# If any adapters were configured to use eepro100, restore the original.
if [ -e /etc/modules.conf.OLD ]; then
	if ( grep eepro100 /etc/modules.conf.OLD > /dev/null 2>&1 ); then
		rm -f /etc/modules.conf.OLD
		mv -f /etc/modules.conf /etc/modules.conf.OLD
		sed -e s/\"e100\"/\"eepro100\"/g /etc/modules.conf.OLD >> /etc/modules.conf
	fi
fi

# Update Kudzu's device table such that future devices that will use
# eepro100 if this was the set before e100 install.
if [ -e /usr/share/kudzu/pcitable.OLD ]; then
	if ( grep eepro100 /usr/share/kudzu/pcitable.OLD > /dev/null 2>&1 ); then
		rm -f /usr/share/kudzu/pcitable.OLD
        mv -f /usr/share/kudzu/pcitable /usr/share/kudzu/pcitable.OLD
        sed -e s/\"e100\"/\"eepro100\"/g /usr/share/kudzu/pcitable.OLD >> /usr/share/kudzu/pcitable
	fi
fi

echo -e "  Changes will take effect after the next reboot."
exit 0

