/*******************************************************************************
* This software program is available to you under a choice of one of two 
* licenses. You may choose to be licensed under either the GNU General Public 
* License 2.0, June 1991, available at http://www.fsf.org/copyleft/gpl.html, 
* or the Intel BSD + Patent License, the text of which follows:
* 
* Recipient has requested a license and Intel Corporation ("Intel") is willing
* to grant a license for the software entitled Linux Intel Advanced Network
* Services (iANS) (the "Licensed Program") being provided by Intel Corporation.
* The following definitions apply to this license:
* 
* "Licensed Patents" means patent claims licensable by Intel Corporation which 
* are necessarily infringed by the use of sale of the Software alone or when 
* combined with the operating system referred to below.
* 
* "Recipient" means the party to whom Intel delivers this Software.
* 
* "Licensee" means Recipient and those third parties that receive a license to 
* any operating system available under the GNU General Public License 2.0 or 
* later.
* 
* Copyright (c) 1999 - 2002 Intel Corporation.
* All rights reserved.
* 
* The license is provided to Recipient and Recipient's Licensees under the 
* following terms.
* 
* Redistribution and use in source and binary forms of the Software, with or 
* without modification, are permitted provided that the following conditions 
* are met:
* 
* Redistributions of source code of the Software may retain the above 
* copyright notice, this list of conditions and the following disclaimer.
* 
* Redistributions in binary form of the Software may reproduce the above 
* copyright notice, this list of conditions and the following disclaimer in 
* the documentation and/or materials provided with the distribution.
* 
* Neither the name of Intel Corporation nor the names of its contributors 
* shall be used to endorse or promote products derived from this Software 
* without specific prior written permission.
* 
* Intel hereby grants Recipient and Licensees a non-exclusive, worldwide, 
* royalty-free patent license under Licensed Patents to make, use, sell, offer 
* to sell, import and otherwise transfer the Software, if any, in source code 
* and object code form. This license shall include changes to the Software 
* that are error corrections or other minor changes to the Software that do 
* not add functionality or features when the Software is incorporated in any 
* version of an operating system that has been distributed under the GNU 
* General Public License 2.0 or later. This patent license shall apply to the 
* combination of the Software and any operating system licensed under the GNU 
* General Public License 2.0 or later if, at the time Intel provides the 
* Software to Recipient, such addition of the Software to the then publicly 
* available versions of such operating systems available under the GNU General 
* Public License 2.0 or later (whether in gold, beta or alpha form) causes 
* such combination to be covered by the Licensed Patents. The patent license 
* shall not apply to any other combinations which include the Software. NO 
* hardware per se is licensed hereunder.
* 
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
* IMPLIED WARRANTIES OF MECHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
* ARE DISCLAIMED. IN NO EVENT SHALL INTEL OR IT CONTRIBUTORS BE LIABLE FOR ANY 
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
* ANY LOSS OF USE; DATA, OR PROFITS; OR BUSINESS INTERUPTION) HOWEVER CAUSED 
* AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY OR 
* TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

/*****************************************************************************
******************************************************************************
**                                                                          **
** INTEL CORPORATION                                                        **
**                                                                          **
** This software is supplied under the terms of the license included        **
** above.  All use of this software must be in accordance with the terms    **
** of that license.                                                         **
**                                                                          **
** THIS FILE IS USED WHEN CREATING ians_core.o. HENCE, IT SHOULD NOT BE     **
** MODIFIED!                                                                **
**                                                                          **
**  Module Name:    incg_utils.c                                            **
**                                                                          **
**  Abstract:       iANS implimentation of some kernel utilities.           **
**                                                                          **
**  Environment:    Kernel Mode (linux 2.2.x, 2.4.x)                        **
**                                                                          **
**                  Written using Tab Size = 4, Indent Size = 4             **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
******************************************************************************
*****************************************************************************/

#include <linux/kernel.h>
#include <linux/string.h>
#include <linux/spinlock.h>
#include <linux/pkt_sched.h>
#include <linux/param.h>
#include <linux/delay.h>
#include <asm/unaligned.h>

#include "ians_kcompat.h"
#include "ians_status.h"
#include "lib/incg_open_utils.h"
#include "lib/incg_gp_mem.h"
#include "lib/incg_defs.h"

#define IANS_PREFIX "  ANS: "

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
// write a log messgae to the kernel.
// tranform the messgae level to the appropriate kernel level.
// WRITTEN BY NOAM
void iAnsKernelPrint(int level, char* fmt, ...)
{
    static char message_buffer[1024];
    va_list args;
    
    if(sizeof(message_buffer) < MAX_LINE_LENGTH+2) {
        return;
    }

    va_start(args, fmt);
    vsprintf(message_buffer, fmt, args);
    va_end(args);

    switch(level) {
        case 0: printk(KERN_EMERG "%s", message_buffer);
            break;
        case 1: printk(KERN_ALERT "%s", message_buffer);
            break;
        case 2: printk(KERN_CRIT "%s", message_buffer);
            break;
        case 3: printk(KERN_ERR "%s", message_buffer);
            break;
        case 4: printk(KERN_WARNING "%s", message_buffer);
            break;
        case 5: printk(KERN_NOTICE "%s", message_buffer);
            break;
        case 6: printk(KERN_INFO "%s", message_buffer);
            break;
        case 7: printk(KERN_DEBUG "%s", message_buffer);
            break;
        case 8: printk("%s", message_buffer);
            break;
        default: printk(KERN_ERR "%s", "invalid iAnsKernelPrint level");
            break;
    }
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
void iAnsKernelPanic(void)
{
    //induce a panic by NULL pointer dereference.
    //this is better than calling panic(), since
    //there is no context switch and the stack
    //trace is still available in KDB.
    *(int*)0 = 0;
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
void iNCGDebugPrintArgs(const char * fmt, ...)
{
    char buf[1024];
    char message_buffer[MAX_LINE_LENGTH+2];
    va_list args;

    if(sizeof(buf) < MAX_LINE_LENGTH+2) {
        return;
    }

    va_start(args, fmt);
    vsprintf(buf, fmt, args);
    va_end(args);

    strncpy(message_buffer, IANS_PREFIX, MAX_LINE_LENGTH);
    message_buffer[sizeof(message_buffer)-1] = '\0';
    strncat(message_buffer, buf, MAX_LINE_LENGTH-strlen(message_buffer));
    message_buffer[sizeof(message_buffer)-1] = '\0';
    strcat(message_buffer, "\n");
    message_buffer[sizeof(message_buffer)-1] = '\0';
    
    iAnsKernelPrint(INGC_DEBUG_LEVEL, "%s", message_buffer);
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
void iNCGLogPrintArgs(const char * fmt, ...)
{
    char buf[1024];
    char message_buffer[MAX_LINE_LENGTH+2];
    va_list args;

    if(sizeof(buf) < MAX_LINE_LENGTH+2) {
        return;
    }

    va_start(args, fmt);
    vsprintf(buf, fmt, args);
    va_end(args);

    strncpy(message_buffer, IANS_PREFIX, MAX_LINE_LENGTH);
    message_buffer[sizeof(message_buffer)-1] = '\0';
    strncat(message_buffer, buf, MAX_LINE_LENGTH-strlen(message_buffer));
    message_buffer[sizeof(message_buffer)-1] = '\0';
    strcat(message_buffer, "\n");
    message_buffer[sizeof(message_buffer)-1] = '\0';
    
    iAnsKernelPrint(INGC_INFO_LEVEL, "%s", message_buffer);
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
void iAnsWaitMsec(int delay)
{
    mdelay(delay);
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
char* iAnsStrCpy(char * dest, const char * src)
{
    return(strcpy(dest, src));
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
char* iAnsStrNCpy(char * dest, const char * src, int len)
{
    return(strncpy(dest, src, len));
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
int iAnsStrCmp(const char * dest, const char * src)
{
    return(strcmp(dest, src));
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
int iAnsStrNCmp(const char * dest, const char * src, const int len)
{
    return(strncmp(dest, src, len));
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
int iAnsStrLen(const char * string)
{
    return(strlen(string));
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
void iANSSprintf(char * dest, char* fmt, ...)
{
    va_list args;
    va_start(args, fmt);
    vsprintf(dest, fmt, args);
    va_end(args);
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
IANS_STATUS iAnsItoa(int value, char* res)
{
    ASSERT(res);

    sprintf(res, "%d", value);
    return IANS_OK;
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
void iAnsUltoa(ULONG value, char string[], int radix)
{
    int i, len;
    char tmp_buffer[MAX_ARG_LENGTH];

    i=0;
    do {
        string[i++] = (char)(value % radix) + '0';
    } while((value /= radix) > 0);

    string[i++] = '\0';

    // reverse
    for(len=0; len<i-1 ;len++) {
        tmp_buffer[len] = string[i-2-len];
    }
    tmp_buffer[i-1] = '\0';

    // copy to original
    for(len=0; len<i ;len++) {
        string[len] = tmp_buffer[len];
    }
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
void iAnsMemCpy(void * dest, const void * src, SIZE_T len)
{
    memcpy(dest, src, len);
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
void* iAnsMemSet(void *ptr, int offset, SIZE_T size)
{
    return memset(ptr, offset, size);
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
/* ------------------------------------------------------------------ */
/* Allocate memory and copy the ASCIIZ string into it */
char * iAnsStringAllocCopy(CONST char *pSrc)
{
    char * pDst;
    char * pTmp;
    INT32 Len; // Must be signed

    Len = (INT32) strlen(pSrc);

    iNCGGPSizedMemAlloc((void **)(&pDst), Len+1);

    if(pDst != NULL) {
        pTmp = pDst;
        while(Len >= 0) {
            *(pTmp++) = *(pSrc++);
            Len--;
        } // while more to copy(inc. terminator)
    } // if allocation succeeded

    return(pDst);
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
/* ------------------------------------------------------------------ */
/* Free ASCIIZ */
void iAnsStringFree(char * pStr)
{
    UINT16 Len;

    Len = strlen(pStr);

    iNCGGPMemFree((void**)(&pStr));
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
/*--------------------------------------------------------------------*
 | iAnsLog2()
 | gets one integer argument: x
 | returns the integer part of the base 2 logarithm of x.
 *--------------------------------------------------------------------*/
int iAnsLog2(int x)
{
    int Retval;
    for(Retval=0;x>1;Retval++) {
        x = x/2;
    }
    return Retval;
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
void iAnsGetUnaligned(void *fromPtr, void *toPtr, SIZE_T size)
{
    switch(size) {
        case 1:
            *((UCHAR *)toPtr) = get_unaligned((UCHAR *)fromPtr);
            break;
        case 2:
            *((USHORT *)toPtr) = get_unaligned((USHORT *)fromPtr);
            break;
        case 4:
            *((ULONG *)toPtr) = get_unaligned((ULONG *)fromPtr);
            break;
        case 8:
#ifdef __ia64__
            *((ULONG64 *)toPtr) = get_unaligned((ULONG64 *)fromPtr);
            break;
#endif //__ia64__
        default:
            IANS_PRINT_ERROR("Wrong pointer type\n");
    }
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
void iAnsPutUnaligned(void *fromPtr, void *toPtr, SIZE_T size)
{
    switch(size) {
        case 1:
            put_unaligned(*((UCHAR *)fromPtr), (UCHAR *)toPtr);
            break;
        case 2:
            put_unaligned(*((USHORT *)fromPtr), (USHORT *)toPtr);
            break;
        case 4:
            put_unaligned(*((ULONG *)fromPtr), (ULONG *)toPtr);
            break;
        case 8:
#ifdef __ia64__
            put_unaligned(*((ULONG64 *)fromPtr), (ULONG64 *)toPtr);
            break;
#endif //__ia64__
        default:
            IANS_PRINT_ERROR("Wrong pointer type\n");
    }
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
BOOLEAN iansIsKernelVersionGreaterThan2_4_0(void)
{
#ifdef LINUX_KERNEL_24X
    return TRUE;
#endif
#ifdef LINUX_KERNEL_22X
    return FALSE;
#endif
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
int iansHighPriority(void)
{
    return TC_PRIO_CONTROL;
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
//returns kernels ticks per second
int iansGetKernelFreq(void)
{
    return HZ;
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
USHORT iansUsecsToTicks(ULONG microsecs)
{
    return(USHORT)(microsecs*0.000001*HZ);
}

