/*******************************************************************************
* This software program is available to you under a choice of one of two 
* licenses. You may choose to be licensed under either the GNU General Public 
* License 2.0, June 1991, available at http://www.fsf.org/copyleft/gpl.html, 
* or the Intel BSD + Patent License, the text of which follows:
* 
* Recipient has requested a license and Intel Corporation ("Intel") is willing
* to grant a license for the software entitled Linux Intel Advanced Network
* Services (iANS) (the "Licensed Program") being provided by Intel Corporation.
* The following definitions apply to this license:
* 
* "Licensed Patents" means patent claims licensable by Intel Corporation which 
* are necessarily infringed by the use of sale of the Software alone or when 
* combined with the operating system referred to below.
* 
* "Recipient" means the party to whom Intel delivers this Software.
* 
* "Licensee" means Recipient and those third parties that receive a license to 
* any operating system available under the GNU General Public License 2.0 or 
* later.
* 
* Copyright (c) 1999 - 2002 Intel Corporation.
* All rights reserved.
* 
* The license is provided to Recipient and Recipient's Licensees under the 
* following terms.
* 
* Redistribution and use in source and binary forms of the Software, with or 
* without modification, are permitted provided that the following conditions 
* are met:
* 
* Redistributions of source code of the Software may retain the above 
* copyright notice, this list of conditions and the following disclaimer.
* 
* Redistributions in binary form of the Software may reproduce the above 
* copyright notice, this list of conditions and the following disclaimer in 
* the documentation and/or materials provided with the distribution.
* 
* Neither the name of Intel Corporation nor the names of its contributors 
* shall be used to endorse or promote products derived from this Software 
* without specific prior written permission.
* 
* Intel hereby grants Recipient and Licensees a non-exclusive, worldwide, 
* royalty-free patent license under Licensed Patents to make, use, sell, offer 
* to sell, import and otherwise transfer the Software, if any, in source code 
* and object code form. This license shall include changes to the Software 
* that are error corrections or other minor changes to the Software that do 
* not add functionality or features when the Software is incorporated in any 
* version of an operating system that has been distributed under the GNU 
* General Public License 2.0 or later. This patent license shall apply to the 
* combination of the Software and any operating system licensed under the GNU 
* General Public License 2.0 or later if, at the time Intel provides the 
* Software to Recipient, such addition of the Software to the then publicly 
* available versions of such operating systems available under the GNU General 
* Public License 2.0 or later (whether in gold, beta or alpha form) causes 
* such combination to be covered by the Licensed Patents. The patent license 
* shall not apply to any other combinations which include the Software. NO 
* hardware per se is licensed hereunder.
* 
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
* IMPLIED WARRANTIES OF MECHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
* ARE DISCLAIMED. IN NO EVENT SHALL INTEL OR IT CONTRIBUTORS BE LIABLE FOR ANY 
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
* ANY LOSS OF USE; DATA, OR PROFITS; OR BUSINESS INTERUPTION) HOWEVER CAUSED 
* AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY OR 
* TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

/*****************************************************************************
******************************************************************************
**                                                                          **
** INTEL CORPORATION                                                        **
**                                                                          **
** This software is supplied under the terms of the license included        **
** above.  All use of this software must be in accordance with the terms    **
** of that license.                                                         **
**                                                                          **
** THIS FILE IS USED WHEN CREATING ians_core.o. HENCE, IT SHOULD NOT BE     **
** MODIFIED!                                                                **
**                                                                          **
**  Module Name:    incg_flow.h                                             **
**                                                                          **
**  Abstract:       This module translates Kernel control/status to         **
**                  iANS control/status.                                    **
**                                                                          **
**  Environment:    Kernel Mode (linux 2.2.x, 2.4.x)                        **
**                                                                          **
**                  Written using Tab Size = 4, Indent Size = 4             **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
******************************************************************************
*****************************************************************************/

#ifndef _INCG_FLOW_H
#define _INCG_FLOW_H

#include "lib/incg_defs.h"


/*****************************************************************************
**                  T y p e  D e f i n i t i o n s                          **
*****************************************************************************/

typedef enum _IANS_FLOW_STATUS {

    /* ----- Continue to next layer(s) ----- */
    FLOW_CONTINUE,          /* Tell Flow to pass to next layers */

    /* ----- Healthy stop at this layer ----- */
    FLOW_OK,                /* Tell Flow to free or return positive reply
                             * to owner. Actual action depends on type of
                             * request and OS.
                             *(replaces FLOW_FREE_OK and FLOW_REPLY_OK) */

    FLOW_TRANSFERED,        /* Ownership transfered. Don't touch any more.
                             * New owner responsible for handling asyncly.
                             * Async handling may have already been
                             * completed by the time we return this status.
                             *(replaces FLOW_PENDIDNG) */


    /* ----- Error statuses ----- */
    FLOW_MIN_ERROR,         /* Higher values indicates error conditions */

    /* Object related errors */
    FLOW_BUSY,              /* Exclusive object is already in use(EBUSY).
                             * Returned when it is inproper to busy-wait. */
    FLOW_DOESNT_EXIST,      /* Requested object not found(ENXIO) */
    FLOW_ALREADY_EXIST,     /* An object with the specified key already
                             * exists. Key must be unique. Can't create
                             * another object with same key.(EEXIST) */

    /* Operation related errors */
    FLOW_UNKNOWN_OPCODE,    /* Unknown op-code(EOPNOTSUPP) */
    FLOW_WRONG_OBJECT,      /* Inappropriate request for object(ENODEV) */
    FLOW_WRONG_STATE,       /* Object is in wrong state ESTATE=EINVAL */
    FLOW_BAD_PARAMETER,     /* Invalid parameter(EINVAL).
                             * Relates to parameters other than the object
                             * and op-code. */

    /* Resources */
    FLOW_DB_FULL,           /* Internal DB is full.(ENOSPC)
                             * Used when request was to add an item to
                             * a limited table. */
    FLOW_COMM_RESOURCES,    /* No more pre-allocated communications
                             * resources available or failed to allocate dynamically.
                             * Relates to resources such as frames and
                             * buffers(ENOBUFS)
                             * Used in cases that don't defer. */
    FLOW_GP_RESOURCES,      /* General purpose rsource allocation failed
                             *(ENOMEM). */

    FLOW_PROTOCOL_ERR,      /* Proto/Ioctls were nacked by base driver or reply
                             * from base driver implies it is working with a wrong
                             * protocol. For example does not support ans extended
                             * features */

    FLOW_DROP,              /* need to drop this packet */

    /* Internal error */
    FLOW_INTERNAL_ERROR     /* An error has occured inside the module */

} iansFlowStatus_t;

typedef iansFlowStatus_t IANS_FLOW_STATUS;


#endif //_INCG_FLOW_H

