/*******************************************************************************
* This software program is available to you under a choice of one of two 
* licenses. You may choose to be licensed under either the GNU General Public 
* License 2.0, June 1991, available at http://www.fsf.org/copyleft/gpl.html, 
* or the Intel BSD + Patent License, the text of which follows:
* 
* Recipient has requested a license and Intel Corporation ("Intel") is willing
* to grant a license for the software entitled Linux Intel Advanced Network
* Services (iANS) (the "Licensed Program") being provided by Intel Corporation.
* The following definitions apply to this license:
* 
* "Licensed Patents" means patent claims licensable by Intel Corporation which 
* are necessarily infringed by the use of sale of the Software alone or when 
* combined with the operating system referred to below.
* 
* "Recipient" means the party to whom Intel delivers this Software.
* 
* "Licensee" means Recipient and those third parties that receive a license to 
* any operating system available under the GNU General Public License 2.0 or 
* later.
* 
* Copyright (c) 1999 - 2002 Intel Corporation.
* All rights reserved.
* 
* The license is provided to Recipient and Recipient's Licensees under the 
* following terms.
* 
* Redistribution and use in source and binary forms of the Software, with or 
* without modification, are permitted provided that the following conditions 
* are met:
* 
* Redistributions of source code of the Software may retain the above 
* copyright notice, this list of conditions and the following disclaimer.
* 
* Redistributions in binary form of the Software may reproduce the above 
* copyright notice, this list of conditions and the following disclaimer in 
* the documentation and/or materials provided with the distribution.
* 
* Neither the name of Intel Corporation nor the names of its contributors 
* shall be used to endorse or promote products derived from this Software 
* without specific prior written permission.
* 
* Intel hereby grants Recipient and Licensees a non-exclusive, worldwide, 
* royalty-free patent license under Licensed Patents to make, use, sell, offer 
* to sell, import and otherwise transfer the Software, if any, in source code 
* and object code form. This license shall include changes to the Software 
* that are error corrections or other minor changes to the Software that do 
* not add functionality or features when the Software is incorporated in any 
* version of an operating system that has been distributed under the GNU 
* General Public License 2.0 or later. This patent license shall apply to the 
* combination of the Software and any operating system licensed under the GNU 
* General Public License 2.0 or later if, at the time Intel provides the 
* Software to Recipient, such addition of the Software to the then publicly 
* available versions of such operating systems available under the GNU General 
* Public License 2.0 or later (whether in gold, beta or alpha form) causes 
* such combination to be covered by the Licensed Patents. The patent license 
* shall not apply to any other combinations which include the Software. NO 
* hardware per se is licensed hereunder.
* 
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
* IMPLIED WARRANTIES OF MECHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
* ARE DISCLAIMED. IN NO EVENT SHALL INTEL OR IT CONTRIBUTORS BE LIABLE FOR ANY 
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
* ANY LOSS OF USE; DATA, OR PROFITS; OR BUSINESS INTERUPTION) HOWEVER CAUSED 
* AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY OR 
* TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

/*****************************************************************************
******************************************************************************
**                                                                          **
** INTEL CORPORATION                                                        **
**                                                                          **
** This software is supplied under the terms of the license included        **
** above.  All use of this software must be in accordance with the terms    **
** of that license.                                                         **
**                                                                          **
** THIS FILE IS USED WHEN CREATING ians_core.o. HENCE, IT SHOULD NOT BE     **
** MODIFIED!                                                                **
**                                                                          **
**  Module Name:    incg_defs.h                                             **
**                                                                          **
**  Abstract:       This file contains all the iANS defined variable types. **
**                                                                          **
**  Environment:    Kernel Mode (linux 2.2.x, 2.4.x)                        **
**                                                                          **
**                  Written using Tab Size = 4, Indent Size = 4             **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
******************************************************************************
*****************************************************************************/

#ifndef _INCG_DEFS_H
#define _INCG_DEFS_H

#include "lib/linux_defs.h"

#define CONST const


#ifdef FLOAT
    #undef FLOAT
#endif
#ifdef DOUBLE
    #undef DOUBLE
#endif
#ifdef NATIVE_ULONG
    #undef NATIVE_ULONG
#endif
#ifdef UINT8
    #undef UINT8
#endif
#ifdef UINT16
    #undef UINT16
#endif
#ifdef UINT32
    #undef UINT32
#endif
#ifdef INT32
    #undef INT32
#endif
#ifdef UINT
#undef UINT
#endif
#ifdef INT
    #undef INT
#endif

typedef unsigned int SIZE_T;
typedef void VOID, *PVOID;
typedef float FLOAT, *PFLOAT;
typedef double DOUBLE, *PDOUBLE;

// We have defined ULONG(linux_defs.h) to be
// 32 bits accross all platforms.
// the size of long typed variables varries
// from 32 bits to 64 bits processors hence
// we must define the NATIVE_ULONG for using
// native kernel functions that expect "unsigned long"
// parameters.
typedef unsigned long NATIVE_ULONG, *PNATIVE_ULONG;
typedef UCHAR UINT8, *PUINT8;
typedef USHORT UINT16, *PUINT16;
typedef ULONG UINT32, *PUINT32;
typedef LONG INT32, *PINT32;
typedef UINT32 UINT, *PUINT;
typedef INT32 INT, *PINT;

#ifndef NULL
    #define NULL 0
#endif

typedef enum _INCG_BOOLEAN {
    INCG_FALSE=0,
    INCG_TRUE
} INCG_BOOLEAN;


/* Error(!=0) values taken from errno.h */
typedef int OS_STATUS;
#define OS_STATUS_OK 0
#define ESTATE EINVAL

/* sizes */
#define ETHERNET_MAX_FRAME_SIZE     1514
#define ETHERNET_MIN_FRAME_SIZE     60
#define ETHERNET_HEADER_SIZE        14
#define ETHERNET_CRC_SIZE           4

/* for library functions */
#define MAX_ARG_LENGTH  20
#define MAX_LINE_LENGTH 200

// Introduced for readability.
// Mark parameter is input to function.
#define IN

#endif //_INCG_DEFS_H

