Name: iANS
Version: 1.7.17
Source: iANS-1.7.17.tar.gz
Summary: Intel(R) Advanced Network Services for Linux
Vendor: Intel Corporation
Release: %(sed '{ s/[^0-9]//g ; s/^/rh/ ; }' < /etc/redhat-release || echo 1)
License: Proprietary
ExclusiveOS: linux
Provides: %{name}
Group: System Environment/Kernel
URL: http://support.intel.com/support/go/linux/ans.htm
BuildRoot: %{_tmppath}/%{name}-%{version}-root

%description
This package contains the Intel(R) Advanced Network Services
driver for Linux. The driver provides advanced features including
adapter teaming, link aggregation and IEEE 802.3ac VLAN support.

%prep
%setup

%build
mkdir -p %{buildroot}

SwitchRHKernel () {
	CFLAGS_EXTRA=""
	for K in $2 ; do
		if [ $K == $1 ] ; then
			CFLAGS_EXTRA="$CFLAGS_EXTRA -D__BOOT_KERNEL_$K=1"
		else
			CFLAGS_EXTRA="$CFLAGS_EXTRA -D__BOOT_KERNEL_$K=0"
		fi
	done
}

KV=$(uname -r)

KSP="/lib/modules/$KV/build
     /usr/src/linux-$KV
     /usr/src/linux-$(echo $KV | sed 's/-.*//')
     /usr/src/kernel-headers-$KV
     /usr/src/kernel-source-$KV
     /usr/src/linux-$(echo $KV | sed 's/\([0-9]*\.[0-9]*\)\..*/\1/')
     /usr/src/linux"

KSRC=$(for d in $KSP ; do [ -e $d/include/linux ] && echo $d || true ; done)
KSRC=$(echo $KSRC | awk '{ print $1 }')

if [ -e $KSRC/include/linux/rhconfig.h ] ; then
	RHKL=$(grep 'BOOT_KERNEL_.* [01]' /boot/kernel.h |
	       sed 's/.*BOOT_KERNEL_\(.*\) [01]/\1/')
	for K in $RHKL ; do
		SwitchRHKernel $K "$RHKL"
		make -C src veryclean
		make -C src INSTALL_ROOT=%{buildroot} \
			MAN_DIR=%{_mandir} CFLAGS_EXTRA="$CFLAGS_EXTRA" install
	done
else
	make -C src veryclean
	make -C src INSTALL_ROOT=%{buildroot} MAN_DIR=%{_mandir} install
fi

%files
%defattr(-,root,root)
/lib/modules/*
%{_mandir}/*
/usr/sbin/*
%doc LICENSE
%doc README
%doc ldistrib.txt

%install
find %{buildroot} -name modules.* -exec rm -f {} \;

%clean
rm -rf %{buildroot}

%post
uname -r | grep BOOT || /sbin/depmod -a > /dev/null 2>&1 || true

%postun
uname -r | grep BOOT || /sbin/depmod -a > /dev/null 2>&1 || true
