/*******************************************************************************
* This software program is available to you under a choice of one of two 
* licenses. You may choose to be licensed under either the GNU General Public 
* License 2.0, June 1991, available at http://www.fsf.org/copyleft/gpl.html, 
* or the Intel BSD + Patent License, the text of which follows:
* 
* Recipient has requested a license and Intel Corporation ("Intel") is willing
* to grant a license for the software entitled Linux Intel Advanced Network
* Services (iANS) (the "Licensed Program") being provided by Intel Corporation.
* The following definitions apply to this license:
* 
* "Licensed Patents" means patent claims licensable by Intel Corporation which 
* are necessarily infringed by the use of sale of the Software alone or when 
* combined with the operating system referred to below.
* 
* "Recipient" means the party to whom Intel delivers this Software.
* 
* "Licensee" means Recipient and those third parties that receive a license to 
* any operating system available under the GNU General Public License 2.0 or 
* later.
* 
* Copyright (c) 1999 - 2002 Intel Corporation.
* All rights reserved.
* 
* The license is provided to Recipient and Recipient's Licensees under the 
* following terms.
* 
* Redistribution and use in source and binary forms of the Software, with or 
* without modification, are permitted provided that the following conditions 
* are met:
* 
* Redistributions of source code of the Software may retain the above 
* copyright notice, this list of conditions and the following disclaimer.
* 
* Redistributions in binary form of the Software may reproduce the above 
* copyright notice, this list of conditions and the following disclaimer in 
* the documentation and/or materials provided with the distribution.
* 
* Neither the name of Intel Corporation nor the names of its contributors 
* shall be used to endorse or promote products derived from this Software 
* without specific prior written permission.
* 
* Intel hereby grants Recipient and Licensees a non-exclusive, worldwide, 
* royalty-free patent license under Licensed Patents to make, use, sell, offer 
* to sell, import and otherwise transfer the Software, if any, in source code 
* and object code form. This license shall include changes to the Software 
* that are error corrections or other minor changes to the Software that do 
* not add functionality or features when the Software is incorporated in any 
* version of an operating system that has been distributed under the GNU 
* General Public License 2.0 or later. This patent license shall apply to the 
* combination of the Software and any operating system licensed under the GNU 
* General Public License 2.0 or later if, at the time Intel provides the 
* Software to Recipient, such addition of the Software to the then publicly 
* available versions of such operating systems available under the GNU General 
* Public License 2.0 or later (whether in gold, beta or alpha form) causes 
* such combination to be covered by the Licensed Patents. The patent license 
* shall not apply to any other combinations which include the Software. NO 
* hardware per se is licensed hereunder.
* 
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
* IMPLIED WARRANTIES OF MECHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
* ARE DISCLAIMED. IN NO EVENT SHALL INTEL OR IT CONTRIBUTORS BE LIABLE FOR ANY 
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
* ANY LOSS OF USE; DATA, OR PROFITS; OR BUSINESS INTERUPTION) HOWEVER CAUSED 
* AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY OR 
* TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

/*****************************************************************************
******************************************************************************
**                                                                          **
** INTEL CORPORATION                                                        **
**                                                                          **
** This software is supplied under the terms of the license included        **
** above.  All use of this software must be in accordance with the terms    **
** of that license.                                                         **
**                                                                          **
** THIS FILE IS USED WHEN CREATING ians_core.o. HENCE, IT SHOULD NOT BE     **
** MODIFIED!                                                                **
**                                                                          **
**  Module Name:    linux_defs.h                                            **
**                                                                          **
**  Abstract:       This file contains iANS defined variable types unique   **
**                  to the linux OS.                                        **
**                                                                          **
**  Environment:    Kernel Mode (linux 2.2.x, 2.4.x)                        **
**                                                                          **
**                  Written using Tab Size = 4, Indent Size = 4             **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
******************************************************************************
*****************************************************************************/

#ifndef _LINUX_DEFS_H
#define _LINUX_DEFS_H

#include <asm/types.h>

#ifdef LONG64
    #undef LONG64
#endif
#ifdef ULONG64
    #undef ULONG64
#endif
#ifdef LONG
    #undef LONG
#endif
#ifdef ULONG
    #undef ULONG
#endif
#ifdef SHORT
    #undef SHORT
#endif
#ifdef USHORT
    #undef USHORT
#endif
#ifdef UCHAR
    #undef UCHAR
#endif
#ifdef PLONG64
    #undef PLONG64
#endif
#ifdef PULONG64
    #undef PULONG64
#endif
#ifdef PLONG
    #undef PLONG
#endif
#ifdef PULONG
    #undef PULONG
#endif
#ifdef PSHORT
    #undef PSHORT
#endif
#ifdef PUSHORT
    #undef PUSHORT
#endif
#ifdef PUCHAR
    #undef PUCHAR
#endif

#ifdef BOOLEAN
    #undef BOOLEAN
#endif
#define BOOLEAN short

#ifdef FALSE
    #undef FALSE
#endif
#define FALSE 0

#ifdef TRUE
    #undef TRUE
#endif
#define TRUE 1

/* sizes */
#define MAXUINT     UINT_MAX
#define MAXUINT16   USHRT_MAX

#ifdef __ia64__
typedef __s64 LONG64, *PLONG64;
typedef __u64 ULONG64, *PULONG64;
#endif
typedef __s32 LONG, *PLONG;
typedef __u32 ULONG, *PULONG;
typedef __s16 SHORT, *PSHORT;
typedef __u16 USHORT, *PUSHORT;
typedef __u8 UCHAR, *PUCHAR;


#endif //_LINUX_DEFS_H

