/*******************************************************************************
* This software program is available to you under a choice of one of two 
* licenses. You may choose to be licensed under either the GNU General Public 
* License 2.0, June 1991, available at http://www.fsf.org/copyleft/gpl.html, 
* or the Intel BSD + Patent License, the text of which follows:
* 
* Recipient has requested a license and Intel Corporation ("Intel") is willing
* to grant a license for the software entitled Linux Intel Advanced Network
* Services (iANS) (the "Licensed Program") being provided by Intel Corporation.
* The following definitions apply to this license:
* 
* "Licensed Patents" means patent claims licensable by Intel Corporation which 
* are necessarily infringed by the use of sale of the Software alone or when 
* combined with the operating system referred to below.
* 
* "Recipient" means the party to whom Intel delivers this Software.
* 
* "Licensee" means Recipient and those third parties that receive a license to 
* any operating system available under the GNU General Public License 2.0 or 
* later.
* 
* Copyright (c) 1999 - 2002 Intel Corporation.
* All rights reserved.
* 
* The license is provided to Recipient and Recipient's Licensees under the 
* following terms.
* 
* Redistribution and use in source and binary forms of the Software, with or 
* without modification, are permitted provided that the following conditions 
* are met:
* 
* Redistributions of source code of the Software may retain the above 
* copyright notice, this list of conditions and the following disclaimer.
* 
* Redistributions in binary form of the Software may reproduce the above 
* copyright notice, this list of conditions and the following disclaimer in 
* the documentation and/or materials provided with the distribution.
* 
* Neither the name of Intel Corporation nor the names of its contributors 
* shall be used to endorse or promote products derived from this Software 
* without specific prior written permission.
* 
* Intel hereby grants Recipient and Licensees a non-exclusive, worldwide, 
* royalty-free patent license under Licensed Patents to make, use, sell, offer 
* to sell, import and otherwise transfer the Software, if any, in source code 
* and object code form. This license shall include changes to the Software 
* that are error corrections or other minor changes to the Software that do 
* not add functionality or features when the Software is incorporated in any 
* version of an operating system that has been distributed under the GNU 
* General Public License 2.0 or later. This patent license shall apply to the 
* combination of the Software and any operating system licensed under the GNU 
* General Public License 2.0 or later if, at the time Intel provides the 
* Software to Recipient, such addition of the Software to the then publicly 
* available versions of such operating systems available under the GNU General 
* Public License 2.0 or later (whether in gold, beta or alpha form) causes 
* such combination to be covered by the Licensed Patents. The patent license 
* shall not apply to any other combinations which include the Software. NO 
* hardware per se is licensed hereunder.
* 
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
* IMPLIED WARRANTIES OF MECHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
* ARE DISCLAIMED. IN NO EVENT SHALL INTEL OR IT CONTRIBUTORS BE LIABLE FOR ANY 
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
* ANY LOSS OF USE; DATA, OR PROFITS; OR BUSINESS INTERUPTION) HOWEVER CAUSED 
* AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY OR 
* TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

/*****************************************************************************
******************************************************************************
**                                                                          **
** INTEL CORPORATION                                                        **
**                                                                          **
** This software is supplied under the terms of the license included        **
** above.  All use of this software must be in accordance with the terms    **
** of that license.                                                         **
**                                                                          **
** THIS FILE IS USED WHEN CREATING ians_core.o. HENCE, IT SHOULD NOT BE     **
** MODIFIED!                                                                **
**                                                                          **
**  Module Name:    incg_types.h                                            **
**                                                                          **
**  Abstract:       iANS definitions for networking structures such as      **
**                  sk_buff, network device, ioctl, socket address etc.     **
**                  iANS definitions of pointers to other structures needed **
**                  by iANS such as timer etc.                              **
**                                                                          **
**  Environment:    Kernel Mode (linux 2.2.x, 2.4.x)                        **
**                                                                          **
**                  Written using Tab Size = 4, Indent Size = 4             **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
******************************************************************************
*****************************************************************************/

#ifndef _INCG_TYPES_H
#define _INCG_TYPES_H

#include "ians_status.h"
#include "lib/incg_defs.h"
#include "lib/incg_net.h"


/*****************************************************************************
**                  T y p e  D e f i n i t i o n s                          **
*****************************************************************************/

typedef struct timer_list *pTimer_t;
typedef unsigned char *messageData_t;
typedef struct sk_buff *pOsMessage_t;
typedef void *pOsDevice_t;
typedef struct net_device_stats *pstats_t;
typedef struct ifreq *preq_t;
typedef struct packet_type *pPacket_t;
typedef struct pci_dev *pOsPciDev_t;
typedef struct spinlock_t *pSpinLock_t;
typedef struct rwlock_t *pRWLock_t;

typedef enum {
    IOCTL_GET_STATS,
    IOCTL_SET_MAC_ADDR,
    IOCTL_SET_MULTICAST_LIST,
    IOCTL_MULTICAST_PROBE,
    IOCTL_CHANGE_MTU,
    IOCTL_DO_IOCTL,
    IOCTL_OPEN,
    IOCTL_STOP,
    IOCTL_INDICATION
} ioctlType_t;

typedef enum _IANS_FLOW_MODE {
    RECEIVE_FLOW,
    TRANSMIT_FLOW
} IANS_FLOW_MODE;

typedef struct {
    USHORT family;
    char saData[14];
} sockAddr_t;

typedef struct {
    UINT pci_reg[16];
} pciConfigSpace_t;

#ifdef __ia64__
 #pragma pack(8)
#endif

typedef struct _device_t {
    pOsDevice_t pOsDev;
    char *name;
    void *pAnsObj;
    BOOLEAN tbusy;
    MAC_ADDR *mac;
    int *mtu;
    IANS_STATUS (*open)(struct _device_t *dev);
    IANS_STATUS (*close)(struct _device_t *dev);
    IANS_STATUS (*send)(void *msg, void *dev);
    IANS_STATUS (*doIoctl)(struct _device_t *ansDev, preq_t req, int cmd);
    IANS_STATUS (*setMulticastList)(struct _device_t *ansDev, MULTICAST_LIST *multicastList, PACKET_FILTER packetFilter);
    IANS_STATUS (*changeMtu)(struct _device_t *ansDev, int new_mtu);
    IANS_STATUS (*setMacAddr)(struct _device_t *ansDev, sockAddr_t *addr);
    pstats_t(*getStats)(struct _device_t *ansDev);
    void(*IfReceive)(void *msg);
} device_t;

typedef struct {
    pOsMessage_t pOsMessage;
    char* osDevName;
    pOsDevice_t *ppOsDev;   //pointer to the pointer skb->dev
    MAC_ADDR *pSrc;         //points to mac addrsses in the buffer pointed
    MAC_ADDR *pDest;        // by skb->head.(the actual ethernet packet).
    USHORT *pLengthType;    //points to ethernet header h_proto(the actual ethernet packet).
    USHORT *pProtocol;      //points to skb->protocol..
    char *Head;             //points to skb->head.
    char *Data;             //points to skb->data.
    char *AttrHeader;       //Points to the attributes header.
    char *LocalAttr;        //points to the local attributes structure.
    UINT *Priority;         //points to skb->priority;
    int Len;                //equals skb->len.
} message_t;

typedef struct {
    ioctlType_t ioctlType;
    int cmd;
    int retVal;
    int mtu;
    pstats_t stats;
    preq_t req;
    MAC_ADDR macAddr;
    MULTICAST_LIST multicastList;
    PACKET_FILTER packetFilter;
    BOOLEAN devOnly;
} genericIoctl_t;

#ifdef __ia64__
 #pragma pack()
#endif

/*****************************************************************************
**      Function Declarations:                                              **
*****************************************************************************/
#define getAttributeHeader(skb)((IANS_ATTR_HEADER *)((skb)->AttrHeader))

//Gets the OS device structure from the ANS device structure.
#define GET_OS_DEV(dev)(((device_t *)dev)->pOsDev)
#define GET_ANS_OBJ(dev)(((device_t *)dev)->pAnsObj)
#define GET_OS_MSG(msg)(((message_t *)msg)->pOsMessage)

#define iansMsgFreeAlocatedMem(msg)  iNCGMessageFree(((message_t *)msg)->pOsMessage);

void iansConvertMessageToAnsMessage(pOsMessage_t osMsg, message_t *ansMsg, IANS_FLOW_MODE flow);

#endif //_INCG_TYPES_H

