/*******************************************************************************
* This software program is available to you under a choice of one of two 
* licenses. You may choose to be licensed under either the GNU General Public 
* License 2.0, June 1991, available at http://www.fsf.org/copyleft/gpl.html, 
* or the Intel BSD + Patent License, the text of which follows:
* 
* Recipient has requested a license and Intel Corporation ("Intel") is willing
* to grant a license for the software entitled Linux Intel Advanced Network
* Services (iANS) (the "Licensed Program") being provided by Intel Corporation.
* The following definitions apply to this license:
* 
* "Licensed Patents" means patent claims licensable by Intel Corporation which 
* are necessarily infringed by the use of sale of the Software alone or when 
* combined with the operating system referred to below.
* 
* "Recipient" means the party to whom Intel delivers this Software.
* 
* "Licensee" means Recipient and those third parties that receive a license to 
* any operating system available under the GNU General Public License 2.0 or 
* later.
* 
* Copyright (c) 1999 - 2002 Intel Corporation.
* All rights reserved.
* 
* The license is provided to Recipient and Recipient's Licensees under the 
* following terms.
* 
* Redistribution and use in source and binary forms of the Software, with or 
* without modification, are permitted provided that the following conditions 
* are met:
* 
* Redistributions of source code of the Software may retain the above 
* copyright notice, this list of conditions and the following disclaimer.
* 
* Redistributions in binary form of the Software may reproduce the above 
* copyright notice, this list of conditions and the following disclaimer in 
* the documentation and/or materials provided with the distribution.
* 
* Neither the name of Intel Corporation nor the names of its contributors 
* shall be used to endorse or promote products derived from this Software 
* without specific prior written permission.
* 
* Intel hereby grants Recipient and Licensees a non-exclusive, worldwide, 
* royalty-free patent license under Licensed Patents to make, use, sell, offer 
* to sell, import and otherwise transfer the Software, if any, in source code 
* and object code form. This license shall include changes to the Software 
* that are error corrections or other minor changes to the Software that do 
* not add functionality or features when the Software is incorporated in any 
* version of an operating system that has been distributed under the GNU 
* General Public License 2.0 or later. This patent license shall apply to the 
* combination of the Software and any operating system licensed under the GNU 
* General Public License 2.0 or later if, at the time Intel provides the 
* Software to Recipient, such addition of the Software to the then publicly 
* available versions of such operating systems available under the GNU General 
* Public License 2.0 or later (whether in gold, beta or alpha form) causes 
* such combination to be covered by the Licensed Patents. The patent license 
* shall not apply to any other combinations which include the Software. NO 
* hardware per se is licensed hereunder.
* 
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
* IMPLIED WARRANTIES OF MECHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
* ARE DISCLAIMED. IN NO EVENT SHALL INTEL OR IT CONTRIBUTORS BE LIABLE FOR ANY 
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
* ANY LOSS OF USE; DATA, OR PROFITS; OR BUSINESS INTERUPTION) HOWEVER CAUSED 
* AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY OR 
* TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

/*****************************************************************************
******************************************************************************
**                                                                          **
** INTEL CORPORATION                                                        **
**                                                                          **
** This software is supplied under the terms of the license included        **
** above.  All use of this software must be in accordance with the terms    **
** of that license.                                                         **
**                                                                          **
** THIS FILE IS USED WHEN CREATING ians_core.o. HENCE, IT SHOULD NOT BE     **
** MODIFIED!                                                                **
**                                                                          **
**  Module Name:    ians_status.h                                           **
**                                                                          **
**  Abstract:       Public definitions for the ianscfg and the ANS module   **
**                  (Error codes etc.).                                     **
**                                                                          **
**  Environment:    Kernel Mode (Linux 2.2.x, 2.4.x)                        **
**                                                                          **
**                  Written using Tab Size = 4, Indent Size = 4             **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
******************************************************************************
*****************************************************************************/

#ifndef _IANS_STATUS_H
#define _IANS_STATUS_H


/*****************************************************************************
**                  F o r w a r d  D e c l a r a t i o n s                  **
*****************************************************************************/

#define IANSIOCCONFIG   SIOCDEVPRIVATE
#define IANSIOCSERVICE  SIOCDEVPRIVATE + 1


/*****************************************************************************
**                  T y p e  D e f i n i t i o n s                          **
*****************************************************************************/

/*----------------------------------------------------------------*
 | Error codes
 *----------------------------------------------------------------*/
typedef enum _iansStatus {
    // ----- General -----
    IANS_OK,
    IANS_ERROR,
    IANS_ILEGAL_OPERATION,
    IANS_NOT_SUPPORTED_YET,
    IANS_MEM_ERROR,
    IANS_MUX_NOT_FOUND,
    IANS_MEMBER_NOT_FOUND,
    IANS_ADAPTER_NOT_FOUND,
    IANS_ADAPTER_NOT_SUPPORTED,
    IANS_VADAPTER_NOT_FOUND,
    IANS_MEMBER_NAME_WRONG,
    IANS_ILLEGAL_NAME,

    // ---- Mux -----
    IANS_TOO_MANY_MUXS,
    IANS_MUX_NOT_EMPTY,
    IANS_MUX_EXIST,

    // ---- Teaming ----
    IANS_AFTER_COMMIT,
    IANS_TEAMING_MODE_NOT_SUPPORTED,

    //teaming restrictions
    IANS_NON_INTEL_DEVICE,
    IANS_NO_SERVER_ADAPTER,
    IANS_VALUE_ADAPTER,

    // ---- Commit -----
    IANS_REDUNDENT_MUX,
    IANS_MUX_WITHOUT_MEMBERS,
    IANS_MUX_WITHOUT_VADAPTERS,
    IANS_TOO_MANY_VADAPTERS,
    IANS_TOO_MANY_MEMBERS,
    IANS_MEMBER_HANDSHAKE_FAIL,
    IANS_VLAN_NOT_SUPPORTED,
    IANS_VADAPTER_INITIALIZE_FAIL,
    IANS_VADAPTER_REGISTER_FAIL,
    IANS_VLAN_ID_UNDEFINED,
    IANS_NON_VLAN_TEAM,
    IANS_MEMBER_OPEN_FAILED,
    IANS_INCOMPATIBLE_TAGGING_MODE,
    IANS_ALREADY_COMMITED,
    IANS_SPEED_ERROR,
    IANS_ALB_SPEED_ERROR,
    IANS_FEC_SPEED_ERROR,
    IANS_GEC_SPEED_ERROR,
    IANS_NON_INTEL_ADAPTER_VLAN,
    IANS_NON_INTEL_ADAPTER_KERNEL_22X,
    IANS_FAILED_ENSLAVE_MEMBER,
    IANS_FAILED_RELEASE_MEMBER,
    IANS_COMMIT_FAILED,

    // ---- Member ----
    IANS_DEVICE_IS_BUSY,
    IANS_SET_BASE_FAILED,
    IANS_UNSET_BASE_FAILED,
    IANS_MEMBER_CLOSE_FAILED,
    IANS_MUX_ALREADY_HAS_PRIMARY,
    IANS_REMOVE_LAST_MEMBER,
    IANS_MEMBER_EXIST,
    IANS_ADD_MEMBER_FAILED,

    // ---- vadapter ----
    IANS_VADAPTER_EXIST,
    IANS_VADAPTER_STILL_REGISTERED,
    IANS_VADAPTER_STILL_OPEN,
    IANS_LAST_VADAPTER,

    // ---- Tagging ---
    IANS_ILEGAL_TAGGING_MODE,

    // ---- Vlan Id ----
    IANS_VLAN_ID_OUT_OF_RANGE,
    IANS_VLAN_ID_NOT_UNIQUE,
    IANS_MAX_VADAPTERS_EXCEEDED,

    // ---- OS errors ----
    IANS_MODULE_NOT_LOADED,
    IANS_BASE_NOT_LOADED,
    IANS_OS_ERROR,

    // --- File errors ---
    IANS_OPEN_FILE_ERROR,
    IANS_FILE_WRITING_ERROR,
    IANS_CLOSE_FILE_ERROR,
    IANS_PARSE_ERROR,
    IANS_TOPOLOGY_NOT_EMPTY,

    // --- PCI errors ---
    IANS_PCI_ERROR,

    // --- IOCTL errors ---
    IANS_IOCTL_FAILED,
    IANS_IOCTL_FAILED_DO_ROLLBACK,

    // ---- max error ----
    IANS_MAX_ERROR
} iansStatus_t;

typedef iansStatus_t IANS_STATUS;

#endif //_IANS_STATUS_H

