/*******************************************************************************
* This software program is available to you under a choice of one of two 
* licenses. You may choose to be licensed under either the GNU General Public 
* License 2.0, June 1991, available at http://www.fsf.org/copyleft/gpl.html, 
* or the Intel BSD + Patent License, the text of which follows:
* 
* Recipient has requested a license and Intel Corporation ("Intel") is willing
* to grant a license for the software entitled Linux Intel Advanced Network
* Services (iANS) (the "Licensed Program") being provided by Intel Corporation.
* The following definitions apply to this license:
* 
* "Licensed Patents" means patent claims licensable by Intel Corporation which 
* are necessarily infringed by the use of sale of the Software alone or when 
* combined with the operating system referred to below.
* 
* "Recipient" means the party to whom Intel delivers this Software.
* 
* "Licensee" means Recipient and those third parties that receive a license to 
* any operating system available under the GNU General Public License 2.0 or 
* later.
* 
* Copyright (c) 1999 - 2002 Intel Corporation.
* All rights reserved.
* 
* The license is provided to Recipient and Recipient's Licensees under the 
* following terms.
* 
* Redistribution and use in source and binary forms of the Software, with or 
* without modification, are permitted provided that the following conditions 
* are met:
* 
* Redistributions of source code of the Software may retain the above 
* copyright notice, this list of conditions and the following disclaimer.
* 
* Redistributions in binary form of the Software may reproduce the above 
* copyright notice, this list of conditions and the following disclaimer in 
* the documentation and/or materials provided with the distribution.
* 
* Neither the name of Intel Corporation nor the names of its contributors 
* shall be used to endorse or promote products derived from this Software 
* without specific prior written permission.
* 
* Intel hereby grants Recipient and Licensees a non-exclusive, worldwide, 
* royalty-free patent license under Licensed Patents to make, use, sell, offer 
* to sell, import and otherwise transfer the Software, if any, in source code 
* and object code form. This license shall include changes to the Software 
* that are error corrections or other minor changes to the Software that do 
* not add functionality or features when the Software is incorporated in any 
* version of an operating system that has been distributed under the GNU 
* General Public License 2.0 or later. This patent license shall apply to the 
* combination of the Software and any operating system licensed under the GNU 
* General Public License 2.0 or later if, at the time Intel provides the 
* Software to Recipient, such addition of the Software to the then publicly 
* available versions of such operating systems available under the GNU General 
* Public License 2.0 or later (whether in gold, beta or alpha form) causes 
* such combination to be covered by the Licensed Patents. The patent license 
* shall not apply to any other combinations which include the Software. NO 
* hardware per se is licensed hereunder.
* 
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
* IMPLIED WARRANTIES OF MECHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
* ARE DISCLAIMED. IN NO EVENT SHALL INTEL OR IT CONTRIBUTORS BE LIABLE FOR ANY 
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
* ANY LOSS OF USE; DATA, OR PROFITS; OR BUSINESS INTERUPTION) HOWEVER CAUSED 
* AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY OR 
* TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

/*****************************************************************************
******************************************************************************
**                                                                          **
** INTEL CORPORATION                                                        **
**                                                                          **
** This software is supplied under the terms of the license included        **
** above.  All use of this software must be in accordance with the terms    **
** of that license.                                                         **
**                                                                          **
** THIS FILE IS USED WHEN CREATING ians_core.o. HENCE, IT SHOULD NOT BE     **
** MODIFIED!                                                                **
**                                                                          **
**  Module Name:    ians_kcompat.h                                          **
**                                                                          **
**  Abstract:       This module contains all the macros to make drivers     **
**                  compatible with 2.2.0 - 2.4.0 Linux kernels             **
**                                                                          **
**  Environment:    Kernel Mode (Linux 2.2.x, 2.4.x)                        **
**                                                                          **
**                  Written using Tab Size = 4, Indent Size = 4             **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
******************************************************************************
*****************************************************************************/

#ifndef IANS_KCOMPAT_H
#define IANS_KCOMPAT_H

#include <linux/version.h>

/*****************************************************************************
 **
 ** PCI Bus Changes
 **
 *****************************************************************************/

/* Accessing the BAR registers from the PCI device structure
 * Changed from base_address[bar] to resource[bar].start in 2.3.13
 * The pci_resource_start inline function was introduced in 2.3.43
 */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,13)
#define pci_resource_start(dev, bar)    (dev)->base_address[(bar)]
#elif LINUX_VERSION_CODE < KERNEL_VERSION(2,3,43)
#define pci_resource_start(dev, bar     (dev)->resource[(bar)].start
#endif


/*****************************************************************************
 **
 ** Network Device API Changes
 **
 *****************************************************************************/

/* In 2.3.14 the device structure was renamed to net_device
 */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,14)
#define net_device device
#endif

/* 'Softnet' network stack changes merged in 2.3.43
 * these are 2.2 compatible defines for the new network interface API
 * 2.3.47 added some more inline functions for softnet to remove explicit
 * bit tests in drivers
 */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,43)
#define netif_start_queue(dev)      clear_bit(0, &(dev)->tbusy)
#define netif_stop_queue(dev)       set_bit(0, &(dev)->tbusy)
#define netif_wake_queue(dev)       { clear_bit(0, &(dev)->tbusy); mark_bh(NET_BH); }
#define netif_running(dev)          test_bit(0, &(dev)->start)
#define netif_queue_stopped(dev)    test_bit(0, &(dev)->tbusy)
#elif LINUX_VERSION_CODE < KERNEL_VERSION(2, 3, 47)
#define netif_running(dev)          test_bit(LINK_STATE_START, &(dev)->state)
#define netif_queue_stopped(dev)    test_bit(LINK_STATE_XOFF, &(dev)->state)
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,43)
#define dev_get_by_name(name)       dev_get(name)
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
#define NET_RX_SUCCESS  0 // keep 'em coming, baby
#define NET_RX_DROP     1 // packet dropped
#define NET_RX_CN_LOW   2 // storm alert, just in case
#define NET_RX_CN_MOD   3 // Storm on its way!
#define NET_RX_CN_HIGH  4 // The storm is here
#define NET_RX_BAD      5 // packet dropped due to kernel error
#endif

/*****************************************************************************
**
** General Module / Driver / Kernel API Changes
**
*****************************************************************************/

/* New module_init macro added in 2.3.13 - replaces init_module entry point
 * If MODULE is defined, it expands to an init_module definition
 * If the driver is staticly linked to the kernel, it creates the proper
 * function pointer for the initialization routine to be called
 *(no more Space.c)
 * module_exit does the same thing for cleanup_module
 */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,2,18)
#define module_init(fn) int  init_module(void)    { return fn(); }
#define module_exit(fn) void cleanup_module(void) { return fn(); }
#endif


#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
#define LINUX_KERNEL_22X
#undef LINUX_KERNEL_24X
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
#undef LINUX_KERNEL_22X
#define LINUX_KERNEL_24X
#endif

#ifndef SET_MODULE_OWNER
#define SET_MODULE_OWNER(X)
#endif

#ifndef MODULE_AUTHOR
#define MODULE_AUTHOR(X)
#endif

#ifndef MODULE_DESCRIPTION
#define MODULE_DESCRIPTION(X)
#endif

#ifndef MODULE_LICENSE
#define MODULE_LICENSE(X)
#endif

#ifdef __ia64__
#include <asm/spinlock.h>
#ifndef rwlock_init
#define rwlock_init(x) do { *(x) = RW_LOCK_UNLOCKED; } while(0)
#endif
#endif

#endif //IANS_KCOMPAT_H

