/*******************************************************************************
* This software program is available to you under a choice of one of two 
* licenses. You may choose to be licensed under either the GNU General Public 
* License 2.0, June 1991, available at http://www.fsf.org/copyleft/gpl.html, 
* or the Intel BSD + Patent License, the text of which follows:
* 
* Recipient has requested a license and Intel Corporation ("Intel") is willing
* to grant a license for the software entitled Linux Intel Advanced Network
* Services (iANS) (the "Licensed Program") being provided by Intel Corporation.
* The following definitions apply to this license:
* 
* "Licensed Patents" means patent claims licensable by Intel Corporation which 
* are necessarily infringed by the use of sale of the Software alone or when 
* combined with the operating system referred to below.
* 
* "Recipient" means the party to whom Intel delivers this Software.
* 
* "Licensee" means Recipient and those third parties that receive a license to 
* any operating system available under the GNU General Public License 2.0 or 
* later.
* 
* Copyright (c) 1999 - 2002 Intel Corporation.
* All rights reserved.
* 
* The license is provided to Recipient and Recipient's Licensees under the 
* following terms.
* 
* Redistribution and use in source and binary forms of the Software, with or 
* without modification, are permitted provided that the following conditions 
* are met:
* 
* Redistributions of source code of the Software may retain the above 
* copyright notice, this list of conditions and the following disclaimer.
* 
* Redistributions in binary form of the Software may reproduce the above 
* copyright notice, this list of conditions and the following disclaimer in 
* the documentation and/or materials provided with the distribution.
* 
* Neither the name of Intel Corporation nor the names of its contributors 
* shall be used to endorse or promote products derived from this Software 
* without specific prior written permission.
* 
* Intel hereby grants Recipient and Licensees a non-exclusive, worldwide, 
* royalty-free patent license under Licensed Patents to make, use, sell, offer 
* to sell, import and otherwise transfer the Software, if any, in source code 
* and object code form. This license shall include changes to the Software 
* that are error corrections or other minor changes to the Software that do 
* not add functionality or features when the Software is incorporated in any 
* version of an operating system that has been distributed under the GNU 
* General Public License 2.0 or later. This patent license shall apply to the 
* combination of the Software and any operating system licensed under the GNU 
* General Public License 2.0 or later if, at the time Intel provides the 
* Software to Recipient, such addition of the Software to the then publicly 
* available versions of such operating systems available under the GNU General 
* Public License 2.0 or later (whether in gold, beta or alpha form) causes 
* such combination to be covered by the Licensed Patents. The patent license 
* shall not apply to any other combinations which include the Software. NO 
* hardware per se is licensed hereunder.
* 
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
* IMPLIED WARRANTIES OF MECHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
* ARE DISCLAIMED. IN NO EVENT SHALL INTEL OR IT CONTRIBUTORS BE LIABLE FOR ANY 
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
* ANY LOSS OF USE; DATA, OR PROFITS; OR BUSINESS INTERUPTION) HOWEVER CAUSED 
* AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY OR 
* TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

/*****************************************************************************
******************************************************************************
**                                                                          **
** INTEL CORPORATION                                                        **
**                                                                          **
** This software is supplied under the terms of the license included        **
** above.  All use of this software must be in accordance with the terms    **
** of that license.                                                         **
**                                                                          **
** THIS FILE IS USED WHEN CREATING ians_core.o. HENCE, IT SHOULD NOT BE     **
** MODIFIED!                                                                **
**                                                                          **
**  Module Name:    incg_utils.h                                            **
**                                                                          **
**  Abstract:       iANS implimentation of some kernel utilities.           **
**                                                                          **
**  Environment:    Kernel Mode (linux 2.2.x, 2.4.x)                        **
**                                                                          **
**                  Written using Tab Size = 4, Indent Size = 4             **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
******************************************************************************
*****************************************************************************/

#ifndef _INCG_UTILS_H
#define _INCG_UTILS_H

#include "ians_status.h"
#include "lib/incg_defs.h"

#define INGC_EMERG_LEVEL    0   /* system is unusable */
#define INGC_ALERT_LEVEL    1   /* action must be taken immediately */
#define INGC_CRIT_LEVEL     2   /* critical conditions */
#define INGC_ERR_LEVEL      3   /* error conditions condition */
#define INGC_WARNING_LEVEL  4   /* warning conditions    */
#define INGC_NOTICE_LEVEL   5   /* normal but significant condition */
#define INGC_INFO_LEVEL     6   /* informational            */
#define INGC_DEBUG_LEVEL    7   /* debug-level messages         */
#define INGC_NO_LEVEL       8

/*****************************************************************************
**      Function Declarations:                                              **
*****************************************************************************/
void  iAnsKernelPrint(int level, char* fmt, ...);
void  iAnsKernelPanic(void);
void  iNCGDebugPrintArgs(const char * fmt, ...);
void  iNCGLogPrintArgs(const char * fmt, ...);
void  iAnsWaitMsec(int delay);
char* iAnsStrCpy(char *dest, const char *src);
char* iAnsStrNCpy(char *dest, const char *src, int len);
int   iAnsStrCmp(const char *dest, const char *src);
int   iAnsStrNCmp(const char *dest, const char *src, int len);
int   iAnsStrLen(const char *str);
void  iANSSprintf(char *dest, char *fmt, ...);
void  iAnsMemCpy(void *dest, const void *src, SIZE_T len);
void* iAnsMemSet(void *ptr, int offset, SIZE_T size);
char* iAnsStringAllocCopy(CONST char *pSrc);
void  iAnsStringFree(char *pStr);
IANS_STATUS   iAnsItoa(int value, char *res);
void  iAnsUltoa(ULONG value, char string[], int radix);
int   iAnsLog2(int x);
void  iAnsGetUnaligned(void *fromPtr, void *toPtr, SIZE_T size);
void  iAnsPutUnaligned(void *fromPtr, void *toPtr, SIZE_T size);
int   iansGetKernelFreq(void);
int   iansHighPriority(void);
USHORT  iansUsecsToTicks(ULONG microsecs);
BOOLEAN iansIsKernelVersionGreaterThan2_4_0(void);


/*-------------------------- INLINE FUNCTIONS-------------------------------*/

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
extern inline UINT32 convertSpeedToMBPS(UINT32 speed)
{
    UINT32 NumZeroes = iAnsLog2(speed);
    UINT32 MBPSSpeed = 1;
    UINT32 i;

    if(speed == 0) {
        return 0;
    }

    for(i=0; i<NumZeroes; i++) {
        MBPSSpeed *= 10;
    }

    return MBPSSpeed;
}

#endif //_INCG_UTILS_H

