/*******************************************************************************
* This software program is available to you under a choice of one of two 
* licenses. You may choose to be licensed under either the GNU General Public 
* License 2.0, June 1991, available at http://www.fsf.org/copyleft/gpl.html, 
* or the Intel BSD + Patent License, the text of which follows:
* 
* Recipient has requested a license and Intel Corporation ("Intel") is willing
* to grant a license for the software entitled Linux Intel Advanced Network
* Services (iANS) (the "Licensed Program") being provided by Intel Corporation.
* The following definitions apply to this license:
* 
* "Licensed Patents" means patent claims licensable by Intel Corporation which 
* are necessarily infringed by the use of sale of the Software alone or when 
* combined with the operating system referred to below.
* 
* "Recipient" means the party to whom Intel delivers this Software.
* 
* "Licensee" means Recipient and those third parties that receive a license to 
* any operating system available under the GNU General Public License 2.0 or 
* later.
* 
* Copyright (c) 1999 - 2002 Intel Corporation.
* All rights reserved.
* 
* The license is provided to Recipient and Recipient's Licensees under the 
* following terms.
* 
* Redistribution and use in source and binary forms of the Software, with or 
* without modification, are permitted provided that the following conditions 
* are met:
* 
* Redistributions of source code of the Software may retain the above 
* copyright notice, this list of conditions and the following disclaimer.
* 
* Redistributions in binary form of the Software may reproduce the above 
* copyright notice, this list of conditions and the following disclaimer in 
* the documentation and/or materials provided with the distribution.
* 
* Neither the name of Intel Corporation nor the names of its contributors 
* shall be used to endorse or promote products derived from this Software 
* without specific prior written permission.
* 
* Intel hereby grants Recipient and Licensees a non-exclusive, worldwide, 
* royalty-free patent license under Licensed Patents to make, use, sell, offer 
* to sell, import and otherwise transfer the Software, if any, in source code 
* and object code form. This license shall include changes to the Software 
* that are error corrections or other minor changes to the Software that do 
* not add functionality or features when the Software is incorporated in any 
* version of an operating system that has been distributed under the GNU 
* General Public License 2.0 or later. This patent license shall apply to the 
* combination of the Software and any operating system licensed under the GNU 
* General Public License 2.0 or later if, at the time Intel provides the 
* Software to Recipient, such addition of the Software to the then publicly 
* available versions of such operating systems available under the GNU General 
* Public License 2.0 or later (whether in gold, beta or alpha form) causes 
* such combination to be covered by the Licensed Patents. The patent license 
* shall not apply to any other combinations which include the Software. NO 
* hardware per se is licensed hereunder.
* 
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
* IMPLIED WARRANTIES OF MECHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
* ARE DISCLAIMED. IN NO EVENT SHALL INTEL OR IT CONTRIBUTORS BE LIABLE FOR ANY 
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
* ANY LOSS OF USE; DATA, OR PROFITS; OR BUSINESS INTERUPTION) HOWEVER CAUSED 
* AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY OR 
* TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

/*****************************************************************************
******************************************************************************
**                                                                          **
** INTEL CORPORATION                                                        **
**                                                                          **
** This software is supplied under the terms of the license included        **
** above.  All use of this software must be in accordance with the terms    **
** of that license.                                                         **
**                                                                          **
** THIS FILE IS USED WHEN CREATING ians_core.o. HENCE, IT SHOULD NOT BE     **
** MODIFIED!                                                                **
**                                                                          **
**  Module Name:    incg_net.h                                              **
**                                                                          **
**  Abstract:       This module defines iANS networking(mac address,        **
**                  multicast list, packet filter etc.).                    **
**                                                                          **
**  Environment:    Kernel Mode (linux 2.2.x, 2.4.x)                        **
**                                                                          **
**                  Written using Tab Size = 4, Indent Size = 4             **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
******************************************************************************
*****************************************************************************/

#ifndef _INCG_NET_H
#define _INCG_NET_H

#include "lib/incg_defs.h"

/*****************************************************************************
**                  T y p e  D e f i n i t i o n s                          **
*****************************************************************************/

#define AT_NULL_MAC_ADDR      {{0,0,0,0,0,0}}

#define PKT_TYPE_IP             0x0008 // 0800
#define PKT_TYPE_IPV4           0x0008 // 0800
#define PKT_TYPE_IPV6           0xDD86 // 86DD 
#define PKT_TYPE_IPX            0x3781 // 8137
#define PKT_TYPE_ARP            0x0608 // 0806

#define AT_REQUEST_ARP_OPCODE   0x0100 // 0001
#define AT_REPLY_ARP_OPCODE     0x0200 // 0002

/*-------------------------------------------------------------------------
 MAC ADDRESS
 -------------------------------------------------------------------------*/

#define MAC_ADDR_LEN 6

#define DUMMY_MAC_ADDR { 0, 0, 0, 0, 0, 0 }

#pragma pack(1)
typedef struct _MACADDR {
    UCHAR MacAddr[MAC_ADDR_LEN];
} MAC_ADDR, *PMAC_ADDR;


/*---------------------------------------------------------------------------
IP ADDRESSES
-----------------------------------------------------------------------------*/

typedef union {
        UCHAR   byteaddr[4];
        ULONG   dwordaddr;
} IPV4_ADDR, *PIPV4_ADDR ;


typedef union {
        UCHAR   byteaddr[16];
        ULONG   dwordaddr[4];
} IPV6_ADDR, *PIPV6_ADDR;

typedef union {
        IPV4_ADDR   IPv4Adr;
        IPV6_ADDR   IPv6Adr;
} IP_ADDR, *PIP_ADDR;

typedef struct _IPV4_HEADER {
    UCHAR       VerLen;
    UCHAR       TOS;
    USHORT      PacketLen;
    USHORT      PacketID;
    USHORT      FlagsAndOffset;         // Net Order: [0: MBZ], [1-2: Flags], [3-31: Fragment Offset]
    UCHAR       TTL;
    UCHAR       Protocol;
    USHORT      Checksum;
    IPV4_ADDR   SrcIp;
    IPV4_ADDR   DstIp;
} IPV4_HEADER, *PIPV4_HEADER;


typedef struct _ARP_PACKET {
    USHORT           HardwareAdrSpace;
    USHORT           ProtocolAdrSpace;
    UCHAR            HardwareAdrLen;
    UCHAR            ProtocolAdrLen;
    USHORT           Opcode;
    MAC_ADDR         SrcMACAdr; //sender hardware address
    IPV4_ADDR        SrcIPAdr;  //sender IP address
    MAC_ADDR         DstMACAdr; //target hardware address
    IPV4_ADDR        DstIPAdr;  //target IP address

} ARP_PACKET, *PARP_PACKET;

/* ---------------------------------------------------
//defined in NDIS
#define IP_VER(p) ((*(PUCHAR)p) >> 4)
#define IP_HDRLEN(p) (((*(PUCHAR)p) & 0x0f) << 2)
------------------------------------------------------*/

typedef struct _IPV6_HEADER {
    UCHAR       VerPriority;
    UCHAR       FlowLabel[3]    ;
    USHORT      PayLoadLen ;
    UCHAR       NextHeader ; 
    UCHAR       HopLimit   ;
    IPV6_ADDR   SrcIPv6;
    IPV6_ADDR   DstIPv6;

} IPV6_HEADER, *PIPV6_HEADER;

typedef struct _IPX_HEADER {
    USHORT Checksum;
    USHORT Length;
    UCHAR TransportControl;
    UCHAR PacketType;
    UCHAR Destination[10];
    USHORT DestSocket;
    UCHAR Source[10];
    USHORT SrcSocket;
} IPX_HEADER, *PIPX_HEADER;


/*** Data Link Control Header ***/
typedef struct _DLC_HEADER {
    MAC_ADDR MacDst;
    MAC_ADDR MacSrc;
    USHORT PacketType;
} DLC_HEADER, *PDLC_HEADER;

/*** Logical Link Control Headers ***/
typedef struct _LLC_HEADER {
    UCHAR Dsap;
    UCHAR Ssap;
    UCHAR Cntl;
} LLC_HEADER, *PLLC_HEADER;

typedef struct _LLC_SNAP_HEADER {
    UCHAR Dsap;
    UCHAR Ssap;
    UCHAR Cntl;
    UCHAR Org_Code[3];
    USHORT PacketType;
} LLC_SNAP_HEADER, *PLLC_SNAP_HEADER;

#pragma pack()


/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
#define iNCGMacAddrCopy(ToAddr, FromAddr)                           \
{                                                                   \
    iAnsMemCpy(((void*)ToAddr), ((void*)FromAddr), MAC_ADDR_LEN);   \
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
/* This macro will compare network addresses.
 *
 * A - Is a network address.
 *
 * B - Is a network address.
 *
 * Result - The result of comparing two network address.
 *
 * Result != 0 Implies inequality.
 * Result == 0 Implies equality.
 */

//We cannot make any assumptions on the alignment of A and B
//so we must compare them byte by byte.
#ifdef __ia64__
#define ETH_COMPARE_NETWORK_ADDRESSES_EQ(A, B, Result)  \
{                                                       \
    UCHAR *a = A;                                       \
    UCHAR *b = B;                                       \
    int i;                                              \
                                                        \
    *(Result) = 0;                                      \
                                                        \
    for (i=5; i>=0; i--) {                              \
        if (a[i] != b[i]) {                             \
            *(Result) = 1;                              \
            break;                                      \
        }                                               \
    }                                                   \
}                             
#else // not 64bit            
#define ETH_COMPARE_NETWORK_ADDRESSES_EQ(A, B, Result)          \
{                                                               \
    if( ( *((UINT16 *)&((A)[4])) == *((UINT16 *)&((B)[4]))) &&  \
        (*((UINT32 *)(A)) == *((UINT32 *)(B)))                  \
      ) {                                                       \
      *(Result) = 0;                                            \
    }                                                           \
    else {                                                      \
        *(Result) = 1;                                          \
    }                                                           \
}
#endif

/*
//We cannot make any assumptions on the alignment of _A and _B
//so we must compare them byte by byte.
#define ETH_COMPARE_NETWORK_ADDRESSES_EQ(_A, _B, _Result)   \
{                                                           \
    if( (*(UCHAR *)&(_A)[5] == *(UCHAR *)&(_B)[5]) &&       \
        (*(UCHAR *)&(_A)[4] == *(UCHAR *)&(_B)[4]) &&       \
        (*(UCHAR *)&(_A)[3] == *(UCHAR *)&(_B)[3]) &&       \
        (*(UCHAR *)&(_A)[2] == *(UCHAR *)&(_B)[2]) &&       \
        (*(UCHAR *)&(_A)[1] == *(UCHAR *)&(_B)[1]) &&       \
        (*(UCHAR *)(_A) == *(UCHAR *)(_B))                  \
      ) {                                                   \
        *(_Result) = 0;                                     \
    }                                                       \
    else {                                                  \
        *(_Result) = 1;                                     \
    }                                                       \
}
*/

/*-------------------------- INLINE FUNCTIONS-------------------------------*/

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
/* Compares 2 ethernet addresses.
 * returns 0 if equal, otherwise returns result !=0.
 */
extern inline int iNCGAddrCompareEthAddresses(MAC_ADDR Addr1, MAC_ADDR Addr2)
{
    int Result;
    ETH_COMPARE_NETWORK_ADDRESSES_EQ(Addr1.MacAddr, Addr2.MacAddr, &Result);
    return(Result);
}


/*-------------------------------------------------------------------------
 PACKET_FILTER
 -------------------------------------------------------------------------*/
typedef ULONG PACKET_FILTER, *PPACKET_FILTER;

#define PF_PROMISCUOUS_BIT 0x00000001 /* If this bit is set in the packet
                                         filter, set promisuous mode ON */

#define PF_ALLMCA_BIT 0x00000002 /* If this bit is set in the packet
                                         filter, send MACIOC_SETALLMCA.
                                         else send MACIOC_DELALLMCA */
#define DUMMY_PACKET_FILTER 0


/*-------------------------------------------------------------------------
 MULTICAST_LIST
 -------------------------------------------------------------------------*/
typedef struct _MULTICAST_ENTRY {
    struct _MULTICAST_ENTRY *pNextEntry;
    MAC_ADDR MacAddr;
    USHORT dmiAddrLen;
    USHORT dmiUsers;
    USHORT dmiGusers;
} MULTICAST_ENTRY, *PMULTICAST_ENTRY;

typedef struct _MULTICAST_LIST {
    PMULTICAST_ENTRY pAddressesList;
    UINT NumAddresses;  /* List size */
} MULTICAST_LIST, *PMULTICAST_LIST;

#define DUMMY_MULTICAST_LIST { NULL, 0 }


typedef struct sk_buff *pOsMsg_t;
typedef struct net_device *pOsDev_t;
pOsMsg_t iNCGCreateArp(int opCode, pOsDev_t dev, UINT32 destIp, UINT32 srcIp, 
                       UCHAR *destHw, UCHAR *srcHw);
#endif //_INCG_NET_H

