/*******************************************************************************
* This software program is available to you under a choice of one of two 
* licenses. You may choose to be licensed under either the GNU General Public 
* License 2.0, June 1991, available at http://www.fsf.org/copyleft/gpl.html, 
* or the Intel BSD + Patent License, the text of which follows:
* 
* Recipient has requested a license and Intel Corporation ("Intel") is willing
* to grant a license for the software entitled Linux Intel Advanced Network
* Services (iANS) (the "Licensed Program") being provided by Intel Corporation.
* The following definitions apply to this license:
* 
* "Licensed Patents" means patent claims licensable by Intel Corporation which 
* are necessarily infringed by the use of sale of the Software alone or when 
* combined with the operating system referred to below.
* 
* "Recipient" means the party to whom Intel delivers this Software.
* 
* "Licensee" means Recipient and those third parties that receive a license to 
* any operating system available under the GNU General Public License 2.0 or 
* later.
* 
* Copyright (c) 1999 - 2002 Intel Corporation.
* All rights reserved.
* 
* The license is provided to Recipient and Recipient's Licensees under the 
* following terms.
* 
* Redistribution and use in source and binary forms of the Software, with or 
* without modification, are permitted provided that the following conditions 
* are met:
* 
* Redistributions of source code of the Software may retain the above 
* copyright notice, this list of conditions and the following disclaimer.
* 
* Redistributions in binary form of the Software may reproduce the above 
* copyright notice, this list of conditions and the following disclaimer in 
* the documentation and/or materials provided with the distribution.
* 
* Neither the name of Intel Corporation nor the names of its contributors 
* shall be used to endorse or promote products derived from this Software 
* without specific prior written permission.
* 
* Intel hereby grants Recipient and Licensees a non-exclusive, worldwide, 
* royalty-free patent license under Licensed Patents to make, use, sell, offer 
* to sell, import and otherwise transfer the Software, if any, in source code 
* and object code form. This license shall include changes to the Software 
* that are error corrections or other minor changes to the Software that do 
* not add functionality or features when the Software is incorporated in any 
* version of an operating system that has been distributed under the GNU 
* General Public License 2.0 or later. This patent license shall apply to the 
* combination of the Software and any operating system licensed under the GNU 
* General Public License 2.0 or later if, at the time Intel provides the 
* Software to Recipient, such addition of the Software to the then publicly 
* available versions of such operating systems available under the GNU General 
* Public License 2.0 or later (whether in gold, beta or alpha form) causes 
* such combination to be covered by the Licensed Patents. The patent license 
* shall not apply to any other combinations which include the Software. NO 
* hardware per se is licensed hereunder.
* 
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
* IMPLIED WARRANTIES OF MECHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
* ARE DISCLAIMED. IN NO EVENT SHALL INTEL OR IT CONTRIBUTORS BE LIABLE FOR ANY 
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
* ANY LOSS OF USE; DATA, OR PROFITS; OR BUSINESS INTERUPTION) HOWEVER CAUSED 
* AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY OR 
* TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

/*****************************************************************************
******************************************************************************
**                                                                          **
** INTEL CORPORATION                                                        **
**                                                                          **
** This software is supplied under the terms of the license included        **
** above.  All use of this software must be in accordance with the terms    **
** of that license.                                                         **
**                                                                          **
** THIS FILE IS USED WHEN CREATING ians_core.o. HENCE, IT SHOULD NOT BE     **
** MODIFIED!                                                                **
**                                                                          **
**  Module Name:    incg_locks.c                                            **
**                                                                          **
**  Abstract:       This module defines locks for iANS.                     **
**                                                                          **
**  Environment:    Kernel Mode (linux 2.2.x, 2.4.x)                        **
**                                                                          **
**                  Written using Tab Size = 4, Indent Size = 4             **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
**      01-Feb-2002 Shmulik Hen,    1st created                             **
**                                                                          **
******************************************************************************
*****************************************************************************/

#include "ians_kcompat.h"
#include "ians_status.h"
#include "lib/incg_types.h"
#include "lib/incg_locks.h"
#include "lib/incg_gp_mem.h"
#include "lib/incg_open_utils.h"

#ifdef LINUX_KERNEL_24X
#include <linux/mm.h>
#include <linux/highmem.h>
#include <linux/interrupt.h>
#include <asm/softirq.h>
#include <linux/spinlock.h>


/*----------------------------- SPIN LOCKS ---------------------------------*/
IANS_STATUS iNCGInitSpinLock(pSpinLock_t *lock)
{
    spinlock_t *tmp_lock;

    iNCGGPSizedMemAlloc((void **)(&tmp_lock), sizeof(spinlock_t));
    if(tmp_lock == NULL) {
        IANS_PRINT_ERROR("kmalloc failed.\n");
        return IANS_MEM_ERROR;
    }

    spin_lock_init(tmp_lock);
    *lock = (pSpinLock_t)tmp_lock;
    return IANS_OK;
}

void iNCGFreeSpinLock(pSpinLock_t *lock)
{
    iNCGGPMemFree((void **)lock);
}

void iNCGAcquireSpinLock(pSpinLock_t lock)
{
    spin_lock((spinlock_t*)lock);
}

void iNCGReleaseSpinLock(pSpinLock_t lock)
{
    spin_unlock((spinlock_t*)lock);
}

void iNCGAcquireSpinLockBH(pSpinLock_t lock)
{
    spin_lock_bh((spinlock_t*)lock);
}

void iNCGReleaseSpinLockBH(pSpinLock_t lock)
{
    spin_unlock_bh((spinlock_t*)lock);
}

/*-------------------------- READ-WRITE LOCKS ------------------------------*/
IANS_STATUS iNCGInitRWLock(pRWLock_t *lock)
{
    rwlock_t *tmp_lock;

    iNCGGPSizedMemAlloc((void **)(&tmp_lock), sizeof(rwlock_t));
    if(tmp_lock == NULL) {
        IANS_PRINT_ERROR("kmalloc failed.\n");
        return IANS_MEM_ERROR;
    }

    rwlock_init(tmp_lock);
    *lock = (pRWLock_t)tmp_lock;
    return IANS_OK;
}

void iNCGFreeRWLock(pRWLock_t *lock)
{
    iNCGGPMemFree((void **)lock);
}

void iNCGAcquireRWLock(pRWLock_t lock, LOCK_ACTION ReadOrWrite)
{
    switch(ReadOrWrite) {
        case READ_ACTION:
            read_lock((rwlock_t*)lock);
            break;
        case WRITE_ACTION:
            write_lock((rwlock_t*)lock);
            break;
    }
}

void iNCGReleaseRWLock(pRWLock_t lock, LOCK_ACTION ReadOrWrite)
{
    switch(ReadOrWrite) {
        case READ_ACTION:
            read_unlock((rwlock_t*)lock);
            break;
        case WRITE_ACTION:
            write_unlock((rwlock_t*)lock);
            break;
    }
}

void iNCGAcquireRWLockBH(pRWLock_t lock, LOCK_ACTION ReadOrWrite)
{
    switch(ReadOrWrite) {
        case READ_ACTION:
            read_lock_bh((rwlock_t*)lock);
            break;
        case WRITE_ACTION:
            write_lock_bh((rwlock_t*)lock);
            break;
    }
}

void iNCGReleaseRWLockBH(pRWLock_t lock, LOCK_ACTION ReadOrWrite)
{
    switch(ReadOrWrite) {
        case READ_ACTION:
            read_unlock_bh((rwlock_t*)lock);
            break;
        case WRITE_ACTION:
            write_unlock_bh((rwlock_t*)lock);
            break;
    }
}

#endif //LINUX_KERNEL_24X

#ifdef LINUX_KERNEL_22X

#include <linux/spinlock.h>
#include <linux/smp.h>
#include <linux/ptrace.h>
#include <linux/interrupt.h>

void iNCGAcquireRWLockBH(pRWLock_t lock, LOCK_ACTION ReadOrWrite)
{
    start_bh_atomic();
}

void iNCGReleaseRWLockBH(pRWLock_t lock, LOCK_ACTION ReadOrWrite)
{
    end_bh_atomic();
}

IANS_STATUS iNCGInitSpinLock(pSpinLock_t *lock) {return IANS_OK;}
void iNCGFreeSpinLock(pSpinLock_t *lock) {}
void iNCGAcquireSpinLock(pSpinLock_t lock) {}
void iNCGReleaseSpinLock(pSpinLock_t lock) {}
void iNCGAcquireSpinLockBH(pSpinLock_t lock) {}
void iNCGReleaseSpinLockBH(pSpinLock_t lock) {}
IANS_STATUS iNCGInitRWLock(pRWLock_t *lock) {return IANS_OK;}
void iNCGFreeRWLock(pRWLock_t *lock) {}
void iNCGAcquireRWLock(pRWLock_t lock, LOCK_ACTION ReadOrWrite) {}
void iNCGReleaseRWLock(pRWLock_t lock, LOCK_ACTION ReadOrWrite) {}

#endif //LINUX_KERNEL_22X
