/*******************************************************************************

  
  Copyright(c) 1999 - 2002 Intel Corporation. All rights reserved.
  
  This program is free software; you can redistribute it and/or modify it 
  under the terms of the GNU General Public License as published by the Free 
  Software Foundation; either version 2 of the License, or (at your option) 
  any later version.
  
  This program is distributed in the hope that it will be useful, but WITHOUT 
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
  more details.
  
  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59 
  Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
  The full GNU General Public License is included in this distribution in the
  file called LICENSE.
  
  Contact Information:
  Linux NICS <linux.nics@intel.com>
  Intel Corporation, 5200 N.E. Elam Young Parkway, Hillsboro, OR 97124-6497

*******************************************************************************/


/*****************************************************************************
******************************************************************************
**                                                                          **
** INTEL CORPORATION                                                        **
**                                                                          **
** This software is supplied under the terms of the license included        **
** above.  All use of this software must be in accordance with the terms    **
** of that license.                                                         **
**                                                                          **
** THIS FILE IS USED WHEN CREATING ians_core.o. HENCE, IT SHOULD NOT BE     **
** MODIFIED!                                                                **
**                                                                          **
**  Module Name:    base_comm_os.h                                          **
**                                                                          **
**  Abstract:       This header file defines the os dependent communications**
**                  between the iANS module and the base drivers bound      **
**                  below it.                                               **
**                                                                          **
**  Environment:    Kernel Mode (linux 2.2.x, 2.4.x)                        **
**                                                                          **
**                  Written using Tab Size = 4, Indent Size = 4             **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
******************************************************************************
*****************************************************************************/

#ifndef _BASE_COMM_OS_H
#define _BASE_COMM_OS_H

#include <linux/sockios.h> // for SIOCDEVPRIVATE
#include "base_comm.h"

/*--------------------------------------------------------------------*
 | PRIMITIVES baring iANS communications
 | =====================================
 *--------------------------------------------------------------------*/

// The proprietary iANS IOCTL code
#define IANS_BASE_SIOC    (SIOCDEVPRIVATE+1)

// The proprietary event notifications code
#define IANS_BASE_NOTIFY  (('S' << 24)|('N' << 16)|('A' << 8)|('i')) // "iANS"

/*==========================================================================*
*                                                                           *
* Per-Message Attributes                                                    *
*                                                                           *
*==========================================================================*/

// Turn into a legal pointer
#if defined(__i386__)
 #define CelingAlignPtr(p)  (p)
#else
 #define CelingAlignPtr(p)  (p)
#endif

// The attribute header is kept at the beginning of the allocated buffer
#define iANSGetReceiveAttributeHeader(skb) \
            ((IANS_ATTR_HEADER*) CelingAlignPtr((char*)((skb)->head)))

#define iANSGetTransmitAttributeHeader(skb) \
            ((IANS_ATTR_HEADER*) CelingAlignPtr((char*)((skb)->cb)))

#endif //_BASE_COMM_OS_H

