@echo off

REM *************************************************************************
REM Post OS Unattend Update batch file for NT 4.0
REM
REM This batch file updates the 8255x drivers and the registry for NT 4.0.
REM *************************************************************************

REM *************************************************************************
REM Possible invocations:
REM NTUPDATE <Path> <Section> <Reboot> - keep this to maintain backward compatibility
REM NTUPDATE <Path> <Reboot>           - specify alternate path and reboot option
REM NTUPDATE <Reboot>                  - use current directory; specify reboot option
REM NTUPDATE                           - use current directory; reboot option defaults to 0
REM *************************************************************************

if (%1) == ?  goto usage

REM *************************************************************************
REM Clear the environment variables set by setpath.bat
REM *************************************************************************
set CURRENTDIR=
set INFOPTION=

REM *************************************************************************
REM Clear the environment variables used by this batch file
REM *************************************************************************
set INFPATH=
set SECTION=
set BOOTOPT=

REM *************************************************************************
REM Check the command line option(s)
REM *************************************************************************
if (%3) == () goto Parms2
set INFPATH=%1
set SECTION=%2
set BOOTOPT=%3
goto CheckReboot

:Parms2
if (%2) == () goto Parms1
REM *************************************************************************
REM Create batch file with CURRENTDIR & INFOPTION varaiables set and call it
REM This executable extracts the INF option from OEMSETUP.INF
REM *************************************************************************
%1\setpath.exe %1
if errorlevel 1 goto LogErr1
goto SetpathOK
:LogErr1
set CURRENTDIR=%1
set logFile=%computername%
goto LogError
:SetpathOK
call %systemroot%\system32\setpath.bat
set INFPATH=%CURRENTDIR%
set SECTION=%INFOPTION%
set BOOTOPT=%2
goto CheckReboot

:Parms1
setpath.exe
call %systemroot%\system32\setpath.bat
if (%1) == () goto Parms0
set INFPATH=%CURRENTDIR%
set SECTION=%INFOPTION%
set BOOTOPT=%1
goto CheckReboot

:Parms0
set INFPATH=%CURRENTDIR%
set SECTION=%INFOPTION%
set BOOTOPT=0

:CheckReboot
REM *************************************************************************
REM Check reboot option
REM *************************************************************************
if %BOOTOPT% == 0  goto DoUpdate
if %BOOTOPT% == 1  goto DoUpdate
if %BOOTOPT% == 2  goto DoUpdate
goto usage

:DoUpdate
REM *************************************************************************
REM Execute the update
REM *************************************************************************
set logFile=%computername%
%systemdrive%
cd %systemroot%\system32
setup /f /i %INFPATH%\NTUpdate.inf /T NTN_SRCPATH = %INFPATH%\ /T NTN_Infname = OEMSETUP.INF /T NTN_RegBase = "SOFTWARE\Microsoft\Windows NT\CurrentVersion\NetworkCards\1" /T NTN_InstallMode = update /T NTN_Origination = install /T NTN_InfOption = %SECTION%

REM *************************************************************************
REM Log result of previous command
REM *************************************************************************
REM PS: Makesure Env. Variable %logFile% is set before jumping to the following label
:LogError
echo %errorLevel% > %systemroot%\system32\%logFile%.log
if errorlevel 1 goto RegError

REM *************************************************************************
REM Set HKEY_LOCAL_MACHINE\SOFTWARE\INTEL\NIC\Unattended Update = "Pass" | "Fail"
REM *************************************************************************
%CURRENTDIR%\setpath.exe p
goto RebootOption

:RegError
%CURRENTDIR%\setpath.exe f
goto end

:RebootOption
REM *************************************************************************
REM Handle the reboot option
REM *************************************************************************
if %BOOTOPT%==0 goto end
if %BOOTOPT%==1 goto DoReboot
if %BOOTOPT%==2 goto DoReboot
goto end

:DoReboot
REM *************************************************************************
REM If command line option is reboot then create a bogus INF file
REM *************************************************************************
echo [Version] > %TEMP%\reboot.inf
echo Signature="$Windows NT$" >> %TEMP%\reboot.inf
echo Provider="Intel" >> %TEMP%\reboot.inf
echo [Install] >> %TEMP%\reboot.inf

rundll32 setupapi.dll,InstallHinfSection Strings %BOOTOPT% %TEMP%\reboot.inf
del %TEMP%\reboot.inf

goto end

REM *************************************************************************
REM Display the usage
REM *************************************************************************
:usage
echo+
echo Usage: NTUpdate SourcePath INFOption RebootOption
echo        or
echo        NTUpdate SourcePath RebootOption
echo        or
echo        NTUpdate RebootOption
echo        or
echo        NTUpdate
echo+
echo        SourcePath   : absolute path to the source files
echo                       optional parameter - default is the current directory
echo+
echo        INFOption    : INF file option name asssociated with the product
echo                       optional parameter - if not specified, it will be
echo                       automatically detected
echo+
echo        RebootOption : 0 no reboot  - this is the default
echo                       1 reboot the machine without prompting the user
echo                       2 reboot the machine by prompting the user
echo+
echo        Examples:  NTUpdate d:\NTUpdate <DriverName> 0
echo                   NTUpdate d:\NTUpdate 0
echo                   NTUpdate 1
echo                   NTUpdate

:end
set CURRENTDIR=
set INFOPTION=
