// mmioctl.h    Include file for MonMouse Port I/O  Driver
//
// Define the IOCTL codes we will use.  The IOCTL code contains a command
// identifier, plus other information about the device, the type of access
// with which the file must have been opened, and the type of buffering.
//
// Version for Monmouse.vxd V1.0 and V2.0
// Peter C. Studt 6/25/98


#ifndef _MMIOCTL_H_
#define _MMIOCTL_H_

#pragma message( "Including " __FILE__ ) 
#pragma message( "Last modified on " __TIMESTAMP__ ) 


#include <winioctl.h>

// Device type           -- in the "User Defined" range."
#define MM_TYPE 40000

// The IOCTL function codes from 0x800 to 0xFFF are for "customer" use.
#define IOCTL_MM_ZAXIS \
	CTL_CODE( MM_TYPE, 0x905, METHOD_BUFFERED, FILE_READ_ACCESS )

#define IOCTL_MM_ZAXIS_SUPPORT \
	CTL_CODE( MM_TYPE, 0x908, METHOD_BUFFERED, FILE_READ_ACCESS )

// header version lock, used to make sure app and device are in sync
#define VERSIONLOCK  1 // Change to > 1 to prevent use with Monmouse.vxd V1.0

// Error returns in the header 
typedef enum _MM_ERROR_CODEs 
{
	MMErrorSuccess=0,
	MMErrorInvalidCommand,
	MMErrorVersionLock,
	MMErrorBufferSize,
	MMErrorTouchDeviceNotWorking,
	MMErrorUnknown
} MM_ERROR_CODES;

typedef enum _CONTRL_STAT
{
	CS_OK = 0,
	CS_ConstantTouch,
	CS_CanNotFindController,
	CS_NoResponse,
	CS_InvalidResponse,
	CS_CanNotSetBaudRate,
	CS_CommandNotSent,
	CS_SystemError,	
	CS_InvalidCommPort,	
	CS_CommPortFailedOpen,
	CS_CommPortCommandError,
	CS_UndefinedController

}CONTRL_STAT;

#pragma pack( push, enter_MMIOCTL,8 )
  
// NOTE: All IO Control calls for MMWin95 require at least a header for both input and output
//       The input header is used to pass the touchscreen number and the output is used for the error
//		 They both are used to pass the version lock input to the driver, & output to the application
//   
//		 The way the driver varifies this is that both the input and output sizes must at least be 
//       as big as a header, otherwise you will get a error return code from DeviceIOControl.

typedef struct _MMDevIOHeader
{
	WORD			DriverVersion;					// Driver version number, from version lock above
	WORD			ApplicationVersion;				// Application version lock, from VERSION lock above
	MM_ERROR_CODES	ReturnValue;					// Error code from driver, will be in 'output buffer' header
	WORD			TouchScreenNumber;				// Screen number for action, 0 based
} MMDevIOHeader;
#define SIZEOF_MMDevIOHeader sizeof(MMDevIOHeader)

typedef struct _MMDevIOZAXIS						// OUT- get last touch Z data
{
	MMDevIOHeader	Header;
	WORD			zaxis;
	BOOL			Touching;
} MMDevIOZAXIS;
#define SIZEOF_MMDevIOZAXIS sizeof(MMDevIOZAXIS)

typedef struct _MMDevIOZAXIS_SUPPORT
{
	MMDevIOHeader Header;
	BOOL	Supported;										
} MMDevIOZAXIS_SUPPORT;
#define SIZEOF_MMDevIOZAXIS_SUPPORT sizeof(MMDevIOZAXIS_SUPPORT)

#pragma pack( pop, enter_MMIOCTL )

#endif


