#ifndef	__RTCTRLAPI_DEF_H__
#define	__RTCTRLAPI_DEF_H__

// APIXe[^X`.
enum RC_API_STATUS {
	E_ERROR_IN_RUNTIME	= -5,	// ^CŃG[.
	E_INVALID_PARAMETER	= -4 ,	// sȃp^.
	E_INVALID_COMMAND	= -3 ,	// sȃR}h.
	E_TIMEOUT			= -2 ,	// |QF^CAEg.
	E_ILLEGAL_PARAMETER	= -1 ,	// |PFp[^G[.
	E_SUCCESS			=  0 ,	// OFs	.
	E_RUNTIME_NO_ACCEPT	=  1 ,	// PF^CtłȂԁiIj.
	E_INVALID_HANDLE	=  2,	// sȃnh.
} ;

enum	RUNTIME_STATE			// ^CN  Add by Y.taira.
{
	STATE_STARTING			,	// N.
	STATE_START_ONLINE		,	// IC.
	STATE_START_OFFLINE		,	// ItC.
	STATE_START_TRANSFER	,	// ][h.
	STATE_ENDING			,	// I.
	STATE_NOTEXECUTE		,	// 삵ĂȂ(API-ClientŔf̂ŕsv).
};

// R}hԍ`.
enum RC_API_COMMAND {
	CMD_GETSTARTSTATE			= 0x0101	,	// 3-5 NԎ擾.
	CMD_GETDISPSCREENNUMBER					,	// 3-6 \ʔԍ擾.
	CMD_GETDISPWINDOWNUMBER					,	// 3-7 \EBhEԍ擾.
	CMD_GETSCREENSTATE						,	// 3-8 XN[Ԏ擾.
	CMD_GETLANGUAGE							,	// 3-9 ݒ擾.
	CMD_GETTOUCHBUZZER						,	// 3-10 ^b`uU[ݒ擾.
	CMD_GETPROJECTINFO						,	// 3-11 vWFNg擾.
	CMD_GETRUNTIMEVERSION					,	// 3-12 o[W擾.
	CMD_STOPRUNTIME							,	// 3-13	I.
	CMD_SETDISPSCREENNUMBER					,	// 3-14	\ʔԍύX.
	CMD_SETDISPWINDOWNUMBER					,	// 3-15 \EBhEԍύX.
	CMD_SETSCREENSTATE						,	// 3-16	XN[ԕύX.
	CMD_SETLANGUAGE							,	// 3-17	ݒύX.
	CMD_SETTOUCHBUZZER						,	// 3-18	^b`uU[ݒύX.
	CMD_GETENUMSCREENNUMBER					,	// 3-20	\ʔԍ.
	CMD_ENUMSCREENNUMBER					,	// 3-20	\ʔԍ.
	CMD_GETENUMWINDOWNUMBER					,	// 3-21	\EBhEԍ񋓐擾.
	CMD_ENUMWINDOWNUMBER					,	// 3-22	\EBhEԍ.
	CMD_GETENUMLANGUAGE						,	// 3-23	ԍ񋓐擾.
	CMD_ENUMLANGUAGE						,	// 3-24	ԍ.
	CMD_NOTIFY_PORT								// C->S |[gʒm.
} ;

// ʐMI/F.
//   `VKǉꍇ.
//   EpragmaɋLq邱.
//       oE_ɂ蔭̉.
//   EAPICOMMAND_HEADDERp邱.
//       wb_ʂƂ.
#pragma pack(push,1)

// \PbgxR}hwb_.
typedef struct _APICOMMAND_HEADDER
{
	_APICOMMAND_HEADDER() :
		lCommand(0),
		lBodyLen(0),
		lStatus(0)
	{}
	_APICOMMAND_HEADDER
	(
		INT32	lCmd,
		INT32	lLen
	) :
		lCommand(lCmd),
		lBodyLen(lLen),
		lStatus(0)
	{}

	INT32	lCommand ;					// R}h.
	INT32	lBodyLen ;					// yC[h̒.
	INT32	lStatus ;					// Xe[^X.
} APICOMMAND_HEADDER ;

// N.
typedef struct _APIST_STARTSTATE : public APICOMMAND_HEADDER
{
	_APIST_STARTSTATE() :
		APICOMMAND_HEADDER(
			CMD_GETSTARTSTATE	,
			sizeof(_APIST_STARTSTATE) - sizeof(APICOMMAND_HEADDER) ) ,
		lRuntimeCondition(0)
	{}

	INT32	lRuntimeCondition ;			// ^CN.
} APIST_STARTSTATE ;

// \ʔԍ.
typedef struct _APIST_DISPLAYSCRRENNUMBER : public APICOMMAND_HEADDER
{
	_APIST_DISPLAYSCRRENNUMBER() :
		APICOMMAND_HEADDER(
			CMD_GETDISPSCREENNUMBER	,
			sizeof(_APIST_DISPLAYSCRRENNUMBER) - sizeof(APICOMMAND_HEADDER) ) ,
		lDisplayScreenNumber(0)
	{}

	INT32	lDisplayScreenNumber ;		// \ʔԍ.
} APIST_DISPLAYSCRRENNUMBER ;

// \EBhEԍ.
typedef struct _APIST_DISPLAYWINDOWNUMBER : public APICOMMAND_HEADDER
{
	_APIST_DISPLAYWINDOWNUMBER() :
		APICOMMAND_HEADDER(
			CMD_GETDISPWINDOWNUMBER	,
			sizeof(_APIST_DISPLAYWINDOWNUMBER) - sizeof(APICOMMAND_HEADDER) ) ,
		lAction(0),
		lPosX(0),
		lPosY(0),
		lWidth(0),
		lHeight(0)
	{
		ZeroMemory( lDisplayWindowNumber, sizeof(lDisplayWindowNumber) ) ;
	}

	INT16	lDisplayWindowNumber[5] ;	// \EBhEԍ.
	INT32	lAction ;					// (1:\ 3:D\).
	INT32	lPosX ;						// \ʒu.
	INT32	lPosY ;						//
	INT32	lWidth ;					// EBhE(gp).
	INT32	lHeight ;					// @@@@@(gp).
} APIST_DISPLAYWINDOWNUMBER ;

// XN[.
typedef struct _APIST_SCREENSTATE : public APICOMMAND_HEADDER
{
	_APIST_SCREENSTATE() :
		APICOMMAND_HEADDER(
			CMD_GETSCREENSTATE	,
			sizeof(_APIST_SCREENSTATE) - sizeof(APICOMMAND_HEADDER) ) ,
		l_ScreenState(0),
		l_PosX(0),
		l_PosY(0),
		l_Width(0),
		l_Height(0)
	{}

	INT32	l_ScreenState ;				// XN[.
	INT32	l_PosX ;					// \ʒu.
	INT32	l_PosY ;					//
	INT32	l_Width ;					// EBhE(gp).
	INT32	l_Height ;					// @@@@@(gp).
} APIST_SCREENSTATE ;

// ݒ.
typedef struct _APIST_LANGUAGE : public APICOMMAND_HEADDER
{
	_APIST_LANGUAGE() :
		APICOMMAND_HEADDER(
			CMD_GETLANGUAGE	,
			sizeof(_APIST_LANGUAGE) - sizeof(APICOMMAND_HEADDER) ) ,
		lLanguageKind(0),
		lLanguage(0)
	{}

	INT32	lLanguageKind ;				// (0:VXeݒ 1:[Uݒ).
	INT32	lLanguage ;					// ԍ.
} APIST_LANGUAGE ;

// ^b`uU[ݒ.
typedef struct _APIST_TOUCHBUZZER : public APICOMMAND_HEADDER
{
	_APIST_TOUCHBUZZER() :
		APICOMMAND_HEADDER(
			CMD_GETTOUCHBUZZER	,
			sizeof(_APIST_TOUCHBUZZER) - sizeof(APICOMMAND_HEADDER) ) ,
		lBuzzerState(0)
	{}

	INT32	lBuzzerState ;				// uU[ݒ(0:o͕s 1:o͉).
} APIST_TOUCHBUZZER ;

// vWFNg.
typedef struct _APIST_PROJECTINFO : public APICOMMAND_HEADDER
{
	_APIST_PROJECTINFO() :
		APICOMMAND_HEADDER(
			CMD_GETPROJECTINFO	,
			sizeof(_APIST_PROJECTINFO) - sizeof(APICOMMAND_HEADDER) )
	{
		ZeroMemory( usProjectFileName,		sizeof(usProjectFileName)  );
		ZeroMemory( usProjectComment,		sizeof(usProjectComment)   );
		ZeroMemory( usProjectFastTime,		sizeof(usProjectFastTime)  );
		ZeroMemory( usProjectLastTime,		sizeof(usProjectLastTime)  );
		ZeroMemory( usProjectIDownload,		sizeof(usProjectIDownload) );
		ZeroMemory( usHMIEditorVersion,		sizeof(usHMIEditorVersion) );
		ZeroMemory( usControlEditorVersion, sizeof(usControlEditorVersion) );
		ZeroMemory( usMakingPerson,			sizeof(usMakingPerson)     );
	}

	enum PROJECTINFO_SIZE {						// TCY`.
		e_ProjectFileNameSize		= 257	,	// vWFNgt@C.
		e_ProjectCommentSize		= 62	,	// vWFNg^Cg(Rg).
		e_ProjectFastTimeSize		= 18	,	// vWFNg쐬.
		e_ProjectLastTiemSize		= 18	,	// vWFNgŏIXV.
		e_ProjectIDownloadSize		= 18	,	// _E[h.
		e_HMIEditorVersionSize		= 32	,	// HMIGfB^o[W.
		e_ControlEditorVersionSize	= 32	,	// CONTROLGfB^o[W.
		e_MakingPersonSize			= 31		// 쐬Җ.
	} ;
	UNICHAR		usProjectFileName[e_ProjectFileNameSize];			// vWFNgt@C.
	UNICHAR		usProjectComment[e_ProjectCommentSize];				// vWFNg^Cg(Rg).
	UNICHAR		usProjectFastTime[e_ProjectFastTimeSize];			// vWFNg쐬.
	UNICHAR		usProjectLastTime[e_ProjectLastTiemSize];			// vWFNgŏIXV.
	UNICHAR		usProjectIDownload[e_ProjectIDownloadSize];			// _E[h.
	UNICHAR		usHMIEditorVersion[e_HMIEditorVersionSize];			// HMIGfB^o[W.
	UNICHAR		usControlEditorVersion[e_ControlEditorVersionSize];	// CONTROLGfB^o[W.
	UNICHAR		usMakingPerson[e_MakingPersonSize];					// 쐬Җ.
} APIST_PROJECTINFO ;

// o[W.
typedef struct _APIST_RUNTIMEVERSION : public APICOMMAND_HEADDER
{
	_APIST_RUNTIMEVERSION() :
		APICOMMAND_HEADDER(
			CMD_GETRUNTIMEVERSION	,
			sizeof(_APIST_RUNTIMEVERSION) - sizeof(APICOMMAND_HEADDER) )
	{
		ZeroMemory( us_VersionInfo,	sizeof(us_VersionInfo) );
	}

	enum RUNTIMEVERSION_SIZE {					// TCY`.
		e_VersionInfo		= 32				// o[W.
	} ;
	UNICHAR		us_VersionInfo[e_VersionInfo];						// o[W.
} APIST_RUNTIMEVERSION ;

// I.
typedef struct _APIST_STOPRUNTIME : public APICOMMAND_HEADDER
{
	_APIST_STOPRUNTIME() :
		APICOMMAND_HEADDER(
			CMD_STOPRUNTIME	,
			sizeof(_APIST_STOPRUNTIME) - sizeof(APICOMMAND_HEADDER) ),
		lStopMode(0)
	{}

	INT32	lStopMode ;					// I[h(gp).
} APIST_STOPRUNTIME ;

// \ʔԍ.
typedef struct _APIST_ENUMSCREENNUMBER : public APICOMMAND_HEADDER
{
	_APIST_ENUMSCREENNUMBER() :
		APICOMMAND_HEADDER(
			CMD_GETENUMSCREENNUMBER	,
			sizeof(_APIST_ENUMSCREENNUMBER) - sizeof(APICOMMAND_HEADDER) ),
		lScreenNumberCount(0)
	{}

	INT32	lScreenNumberCount ;		// \ʐ.
} APIST_ENUMSCREENNUMBER ;

// \EBhEԍ.
typedef struct _APIST_ENUMWINDOWNUMBER : public APICOMMAND_HEADDER
{
	_APIST_ENUMWINDOWNUMBER() :
		APICOMMAND_HEADDER(
			CMD_ENUMWINDOWNUMBER	,
			sizeof(_APIST_ENUMWINDOWNUMBER) - sizeof(APICOMMAND_HEADDER) ),
		lWindowNumberCount(0)
	{}

	INT32	lWindowNumberCount ;		// \EBhE.
} APIST_ENUMWINDOWNUMBER ;

// ԍ.
typedef struct _APIST_ENUMLANGUAGE : public APICOMMAND_HEADDER
{
	_APIST_ENUMLANGUAGE() :
		APICOMMAND_HEADDER(
			CMD_GETENUMLANGUAGE	,
			sizeof(_APIST_ENUMLANGUAGE) - sizeof(APICOMMAND_HEADDER) ),
		lLanguageKind(0),
		lLanguageCount(0)
	{}

	INT32	lLanguageKind ;				// .
	INT32	lLanguageCount ;			// ԍ.
} APIST_ENUMLANGUAGE ;

// |[gԍʒm.
typedef struct _APIST_NOTIFYPORT : public APICOMMAND_HEADDER
{
	_APIST_NOTIFYPORT() :
		APICOMMAND_HEADDER(
			CMD_NOTIFY_PORT	,
			sizeof(_APIST_NOTIFYPORT) - sizeof(APICOMMAND_HEADDER) ),
		sPort(0)
	{}

	INT16	sPort ;						// |[gԍ.
} APIST_NOTIFYPORT ;

#pragma pack(pop)

#endif