Imports System.Runtime.InteropServices

Public Class Form1
    Inherits System.Windows.Forms.Form



    Dim ghWinGP As Int32 = 0        ' API Handle.

#Region " Windows form designer's code "

    Public Sub New()
        MyBase.New()

        '
        InitializeComponent()

        '

        ' Initialize API (API).
        Dim nResult As Integer = InitRuntimeAPI()

        ' (API).
        ghWinGP = GetRuntimeHandle(9800)
        If ghWinGP = 0 Then
            MsgBox("(API) Can't create handle.")
        End If

    End Sub

    '
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        CleanupRuntimeAPI()
        MyBase.Dispose(disposing)
    End Sub

    '
    Private components As System.ComponentModel.IContainer

    '
    '
    '
    Friend WithEvents TabControl1 As System.Windows.Forms.TabControl
    Friend WithEvents TabPage1 As System.Windows.Forms.TabPage
    Friend WithEvents TabPage3 As System.Windows.Forms.TabPage
    Friend WithEvents GroupBox1 As System.Windows.Forms.GroupBox
    Friend WithEvents GroupBox4 As System.Windows.Forms.GroupBox
    Friend WithEvents Bt_GetStartState As System.Windows.Forms.Button
    Friend WithEvents StartState As System.Windows.Forms.TextBox
    Friend WithEvents TabPage4 As System.Windows.Forms.TabPage
    Friend WithEvents GroupBox2 As System.Windows.Forms.GroupBox
    Friend WithEvents ScreenState As System.Windows.Forms.ComboBox
    Friend WithEvents GetProjectInfo As System.Windows.Forms.Button
    Friend WithEvents StopWinGP_Q As System.Windows.Forms.Button
    Friend WithEvents Prj_Comment As System.Windows.Forms.TextBox
    Friend WithEvents Prj_File As System.Windows.Forms.TextBox
    Friend WithEvents Prj_LastDate As System.Windows.Forms.TextBox
    Friend WithEvents Prj_Date As System.Windows.Forms.TextBox
    Friend WithEvents Prj_Person As System.Windows.Forms.TextBox
    Friend WithEvents Prj_HMI As System.Windows.Forms.TextBox
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents Label2 As System.Windows.Forms.Label
    Friend WithEvents Label3 As System.Windows.Forms.Label
    Friend WithEvents Label4 As System.Windows.Forms.Label
    Friend WithEvents Label6 As System.Windows.Forms.Label
    Friend WithEvents Label8 As System.Windows.Forms.Label
    Friend WithEvents BT_GetScreenState As System.Windows.Forms.Button
    Friend WithEvents Label5 As System.Windows.Forms.Label
    Friend WithEvents Label9 As System.Windows.Forms.Label
    Friend WithEvents Label10 As System.Windows.Forms.Label
    Friend WithEvents Label11 As System.Windows.Forms.Label
    Friend WithEvents PosY As System.Windows.Forms.TextBox
    Friend WithEvents PosX As System.Windows.Forms.TextBox
    Friend WithEvents BT_SetScreenState As System.Windows.Forms.Button
    Friend WithEvents TX_Height As System.Windows.Forms.TextBox
    Friend WithEvents TX_Width As System.Windows.Forms.TextBox
    Friend WithEvents GroupBox5 As System.Windows.Forms.GroupBox
    Friend WithEvents SetDispScreen As System.Windows.Forms.Button
    Friend WithEvents CB_DispScreen As System.Windows.Forms.ComboBox
    Friend WithEvents GetDispScreen As System.Windows.Forms.Button
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.TabControl1 = New System.Windows.Forms.TabControl
        Me.TabPage1 = New System.Windows.Forms.TabPage
        Me.GroupBox5 = New System.Windows.Forms.GroupBox
        Me.SetDispScreen = New System.Windows.Forms.Button
        Me.CB_DispScreen = New System.Windows.Forms.ComboBox
        Me.GetDispScreen = New System.Windows.Forms.Button
        Me.GroupBox1 = New System.Windows.Forms.GroupBox
        Me.StartState = New System.Windows.Forms.TextBox
        Me.Bt_GetStartState = New System.Windows.Forms.Button
        Me.TabPage4 = New System.Windows.Forms.TabPage
        Me.GroupBox2 = New System.Windows.Forms.GroupBox
        Me.Label11 = New System.Windows.Forms.Label
        Me.Label10 = New System.Windows.Forms.Label
        Me.Label9 = New System.Windows.Forms.Label
        Me.Label5 = New System.Windows.Forms.Label
        Me.TX_Height = New System.Windows.Forms.TextBox
        Me.TX_Width = New System.Windows.Forms.TextBox
        Me.PosY = New System.Windows.Forms.TextBox
        Me.PosX = New System.Windows.Forms.TextBox
        Me.ScreenState = New System.Windows.Forms.ComboBox
        Me.BT_SetScreenState = New System.Windows.Forms.Button
        Me.BT_GetScreenState = New System.Windows.Forms.Button
        Me.TabPage3 = New System.Windows.Forms.TabPage
        Me.StopWinGP_Q = New System.Windows.Forms.Button
        Me.GroupBox4 = New System.Windows.Forms.GroupBox
        Me.Label8 = New System.Windows.Forms.Label
        Me.Label6 = New System.Windows.Forms.Label
        Me.Label4 = New System.Windows.Forms.Label
        Me.Label3 = New System.Windows.Forms.Label
        Me.Label2 = New System.Windows.Forms.Label
        Me.Label1 = New System.Windows.Forms.Label
        Me.Prj_Person = New System.Windows.Forms.TextBox
        Me.Prj_HMI = New System.Windows.Forms.TextBox
        Me.Prj_LastDate = New System.Windows.Forms.TextBox
        Me.Prj_Date = New System.Windows.Forms.TextBox
        Me.Prj_Comment = New System.Windows.Forms.TextBox
        Me.GetProjectInfo = New System.Windows.Forms.Button
        Me.Prj_File = New System.Windows.Forms.TextBox
        Me.TabControl1.SuspendLayout()
        Me.TabPage1.SuspendLayout()
        Me.GroupBox5.SuspendLayout()
        Me.GroupBox1.SuspendLayout()
        Me.TabPage4.SuspendLayout()
        Me.GroupBox2.SuspendLayout()
        Me.TabPage3.SuspendLayout()
        Me.GroupBox4.SuspendLayout()
        Me.SuspendLayout()
        '
        'TabControl1
        '
        Me.TabControl1.Controls.Add(Me.TabPage1)
        Me.TabControl1.Controls.Add(Me.TabPage4)
        Me.TabControl1.Controls.Add(Me.TabPage3)
        Me.TabControl1.Font = New System.Drawing.Font("Microsoft Sans Serif", 14.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.TabControl1.Location = New System.Drawing.Point(8, 8)
        Me.TabControl1.Name = "TabControl1"
        Me.TabControl1.SelectedIndex = 0
        Me.TabControl1.Size = New System.Drawing.Size(528, 456)
        Me.TabControl1.TabIndex = 8
        '
        'TabPage1
        '
        Me.TabPage1.Controls.Add(Me.GroupBox5)
        Me.TabPage1.Controls.Add(Me.GroupBox1)
        Me.TabPage1.Location = New System.Drawing.Point(4, 33)
        Me.TabPage1.Name = "TabPage1"
        Me.TabPage1.Size = New System.Drawing.Size(520, 419)
        Me.TabPage1.TabIndex = 0
        Me.TabPage1.Text = "Status 1"
        '
        'GroupBox5
        '
        Me.GroupBox5.Controls.Add(Me.SetDispScreen)
        Me.GroupBox5.Controls.Add(Me.CB_DispScreen)
        Me.GroupBox5.Controls.Add(Me.GetDispScreen)
        Me.GroupBox5.Font = New System.Drawing.Font("Microsoft Sans Serif", 14.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.GroupBox5.Location = New System.Drawing.Point(16, 160)
        Me.GroupBox5.Name = "GroupBox5"
        Me.GroupBox5.Size = New System.Drawing.Size(344, 112)
        Me.GroupBox5.TabIndex = 5
        Me.GroupBox5.TabStop = False
        Me.GroupBox5.Text = "Screen"
        '
        'SetDispScreen
        '
        Me.SetDispScreen.Location = New System.Drawing.Point(240, 40)
        Me.SetDispScreen.Name = "SetDispScreen"
        Me.SetDispScreen.Size = New System.Drawing.Size(80, 48)
        Me.SetDispScreen.TabIndex = 2
        Me.SetDispScreen.Text = "Set"
        '
        'CB_DispScreen
        '
        Me.CB_DispScreen.Location = New System.Drawing.Point(120, 48)
        Me.CB_DispScreen.Name = "CB_DispScreen"
        Me.CB_DispScreen.Size = New System.Drawing.Size(104, 32)
        Me.CB_DispScreen.TabIndex = 1
        '
        'GetDispScreen
        '
        Me.GetDispScreen.Location = New System.Drawing.Point(16, 40)
        Me.GetDispScreen.Name = "GetDispScreen"
        Me.GetDispScreen.Size = New System.Drawing.Size(80, 48)
        Me.GetDispScreen.TabIndex = 0
        Me.GetDispScreen.Text = "Get"
        '
        'GroupBox1
        '
        Me.GroupBox1.Controls.Add(Me.StartState)
        Me.GroupBox1.Controls.Add(Me.Bt_GetStartState)
        Me.GroupBox1.Font = New System.Drawing.Font("Microsoft Sans Serif", 14.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.GroupBox1.Location = New System.Drawing.Point(16, 24)
        Me.GroupBox1.Name = "GroupBox1"
        Me.GroupBox1.Size = New System.Drawing.Size(288, 112)
        Me.GroupBox1.TabIndex = 4
        Me.GroupBox1.TabStop = False
        Me.GroupBox1.Text = "Start Status"
        '
        'StartState
        '
        Me.StartState.Font = New System.Drawing.Font("Microsoft Sans Serif", 20.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.StartState.Location = New System.Drawing.Point(112, 40)
        Me.StartState.Name = "StartState"
        Me.StartState.Size = New System.Drawing.Size(136, 38)
        Me.StartState.TabIndex = 2
        Me.StartState.Text = ""
        '
        'Bt_GetStartState
        '
        Me.Bt_GetStartState.Location = New System.Drawing.Point(16, 32)
        Me.Bt_GetStartState.Name = "Bt_GetStartState"
        Me.Bt_GetStartState.Size = New System.Drawing.Size(80, 56)
        Me.Bt_GetStartState.TabIndex = 1
        Me.Bt_GetStartState.Text = "Get"
        '
        'TabPage4
        '
        Me.TabPage4.Controls.Add(Me.GroupBox2)
        Me.TabPage4.Location = New System.Drawing.Point(4, 33)
        Me.TabPage4.Name = "TabPage4"
        Me.TabPage4.Size = New System.Drawing.Size(520, 419)
        Me.TabPage4.TabIndex = 3
        Me.TabPage4.Text = "Status 2"
        '
        'GroupBox2
        '
        Me.GroupBox2.Controls.Add(Me.Label11)
        Me.GroupBox2.Controls.Add(Me.Label10)
        Me.GroupBox2.Controls.Add(Me.Label9)
        Me.GroupBox2.Controls.Add(Me.Label5)
        Me.GroupBox2.Controls.Add(Me.TX_Height)
        Me.GroupBox2.Controls.Add(Me.TX_Width)
        Me.GroupBox2.Controls.Add(Me.PosY)
        Me.GroupBox2.Controls.Add(Me.PosX)
        Me.GroupBox2.Controls.Add(Me.ScreenState)
        Me.GroupBox2.Controls.Add(Me.BT_SetScreenState)
        Me.GroupBox2.Controls.Add(Me.BT_GetScreenState)
        Me.GroupBox2.Location = New System.Drawing.Point(16, 24)
        Me.GroupBox2.Name = "GroupBox2"
        Me.GroupBox2.Size = New System.Drawing.Size(488, 176)
        Me.GroupBox2.TabIndex = 6
        Me.GroupBox2.TabStop = False
        Me.GroupBox2.Text = "Screen Status"
        '
        'Label11
        '
        Me.Label11.Location = New System.Drawing.Point(232, 136)
        Me.Label11.Name = "Label11"
        Me.Label11.Size = New System.Drawing.Size(64, 24)
        Me.Label11.TabIndex = 13
        Me.Label11.Text = "Height"
        '
        'Label10
        '
        Me.Label10.Location = New System.Drawing.Point(232, 96)
        Me.Label10.Name = "Label10"
        Me.Label10.Size = New System.Drawing.Size(64, 24)
        Me.Label10.TabIndex = 12
        Me.Label10.Text = "Width"
        '
        'Label9
        '
        Me.Label9.Location = New System.Drawing.Point(104, 136)
        Me.Label9.Name = "Label9"
        Me.Label9.Size = New System.Drawing.Size(24, 24)
        Me.Label9.TabIndex = 11
        Me.Label9.Text = "Y"
        '
        'Label5
        '
        Me.Label5.Location = New System.Drawing.Point(104, 96)
        Me.Label5.Name = "Label5"
        Me.Label5.Size = New System.Drawing.Size(24, 24)
        Me.Label5.TabIndex = 10
        Me.Label5.Text = "X"
        '
        'TX_Height
        '
        Me.TX_Height.Font = New System.Drawing.Font("Microsoft Sans Serif", 20.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.TX_Height.Location = New System.Drawing.Point(304, 128)
        Me.TX_Height.Name = "TX_Height"
        Me.TX_Height.Size = New System.Drawing.Size(64, 38)
        Me.TX_Height.TabIndex = 8
        Me.TX_Height.Text = ""
        '
        'TX_Width
        '
        Me.TX_Width.Font = New System.Drawing.Font("Microsoft Sans Serif", 20.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.TX_Width.Location = New System.Drawing.Point(304, 88)
        Me.TX_Width.Name = "TX_Width"
        Me.TX_Width.Size = New System.Drawing.Size(64, 38)
        Me.TX_Width.TabIndex = 7
        Me.TX_Width.Text = ""
        '
        'PosY
        '
        Me.PosY.Font = New System.Drawing.Font("Microsoft Sans Serif", 20.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.PosY.Location = New System.Drawing.Point(144, 128)
        Me.PosY.Name = "PosY"
        Me.PosY.Size = New System.Drawing.Size(64, 38)
        Me.PosY.TabIndex = 6
        Me.PosY.Text = ""
        '
        'PosX
        '
        Me.PosX.Font = New System.Drawing.Font("Microsoft Sans Serif", 20.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.PosX.Location = New System.Drawing.Point(144, 88)
        Me.PosX.Name = "PosX"
        Me.PosX.Size = New System.Drawing.Size(64, 38)
        Me.PosX.TabIndex = 5
        Me.PosX.Text = ""
        '
        'ScreenState
        '
        Me.ScreenState.Font = New System.Drawing.Font("Microsoft Sans Serif", 20.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.ScreenState.Items.AddRange(New Object() {"FullScreen Mode", "Window Mode", "Minimize"})
        Me.ScreenState.Location = New System.Drawing.Point(112, 40)
        Me.ScreenState.Name = "ScreenState"
        Me.ScreenState.Size = New System.Drawing.Size(216, 39)
        Me.ScreenState.TabIndex = 4
        '
        'BT_SetScreenState
        '
        Me.BT_SetScreenState.Location = New System.Drawing.Point(392, 32)
        Me.BT_SetScreenState.Name = "BT_SetScreenState"
        Me.BT_SetScreenState.Size = New System.Drawing.Size(80, 56)
        Me.BT_SetScreenState.TabIndex = 3
        Me.BT_SetScreenState.Text = "Set"
        '
        'BT_GetScreenState
        '
        Me.BT_GetScreenState.Location = New System.Drawing.Point(16, 32)
        Me.BT_GetScreenState.Name = "BT_GetScreenState"
        Me.BT_GetScreenState.Size = New System.Drawing.Size(80, 56)
        Me.BT_GetScreenState.TabIndex = 1
        Me.BT_GetScreenState.Text = "Get"
        '
        'TabPage3
        '
        Me.TabPage3.Controls.Add(Me.StopWinGP_Q)
        Me.TabPage3.Controls.Add(Me.GroupBox4)
        Me.TabPage3.Location = New System.Drawing.Point(4, 33)
        Me.TabPage3.Name = "TabPage3"
        Me.TabPage3.Size = New System.Drawing.Size(520, 419)
        Me.TabPage3.TabIndex = 2
        Me.TabPage3.Text = "Information/End"
        '
        'StopWinGP_Q
        '
        Me.StopWinGP_Q.Location = New System.Drawing.Point(312, 304)
        Me.StopWinGP_Q.Name = "StopWinGP_Q"
        Me.StopWinGP_Q.Size = New System.Drawing.Size(184, 48)
        Me.StopWinGP_Q.TabIndex = 10
        Me.StopWinGP_Q.Text = "WinGP Ends With Query"
        '
        'GroupBox4
        '
        Me.GroupBox4.Controls.Add(Me.Label8)
        Me.GroupBox4.Controls.Add(Me.Label6)
        Me.GroupBox4.Controls.Add(Me.Label4)
        Me.GroupBox4.Controls.Add(Me.Label3)
        Me.GroupBox4.Controls.Add(Me.Label2)
        Me.GroupBox4.Controls.Add(Me.Label1)
        Me.GroupBox4.Controls.Add(Me.Prj_Person)
        Me.GroupBox4.Controls.Add(Me.Prj_HMI)
        Me.GroupBox4.Controls.Add(Me.Prj_LastDate)
        Me.GroupBox4.Controls.Add(Me.Prj_Date)
        Me.GroupBox4.Controls.Add(Me.Prj_Comment)
        Me.GroupBox4.Controls.Add(Me.GetProjectInfo)
        Me.GroupBox4.Controls.Add(Me.Prj_File)
        Me.GroupBox4.Location = New System.Drawing.Point(16, 24)
        Me.GroupBox4.Name = "GroupBox4"
        Me.GroupBox4.Size = New System.Drawing.Size(488, 264)
        Me.GroupBox4.TabIndex = 7
        Me.GroupBox4.TabStop = False
        Me.GroupBox4.Text = "Project Information"
        '
        'Label8
        '
        Me.Label8.Location = New System.Drawing.Point(112, 230)
        Me.Label8.Name = "Label8"
        Me.Label8.Size = New System.Drawing.Size(112, 24)
        Me.Label8.TabIndex = 16
        Me.Label8.Text = "Person"
        '
        'Label6
        '
        Me.Label6.Location = New System.Drawing.Point(112, 192)
        Me.Label6.Name = "Label6"
        Me.Label6.Size = New System.Drawing.Size(128, 24)
        Me.Label6.TabIndex = 14
        Me.Label6.Text = "HMI Editor"
        '
        'Label4
        '
        Me.Label4.Location = New System.Drawing.Point(112, 154)
        Me.Label4.Name = "Label4"
        Me.Label4.Size = New System.Drawing.Size(128, 24)
        Me.Label4.TabIndex = 12
        Me.Label4.Text = "Last Update"
        '
        'Label3
        '
        Me.Label3.Location = New System.Drawing.Point(112, 116)
        Me.Label3.Name = "Label3"
        Me.Label3.Size = New System.Drawing.Size(120, 24)
        Me.Label3.TabIndex = 11
        Me.Label3.Text = "Created date"
        '
        'Label2
        '
        Me.Label2.Location = New System.Drawing.Point(112, 78)
        Me.Label2.Name = "Label2"
        Me.Label2.Size = New System.Drawing.Size(112, 24)
        Me.Label2.TabIndex = 10
        Me.Label2.Text = "Comment"
        '
        'Label1
        '
        Me.Label1.Location = New System.Drawing.Point(112, 40)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(120, 24)
        Me.Label1.TabIndex = 9
        Me.Label1.Text = "ProjectName"
        '
        'Prj_Person
        '
        Me.Prj_Person.Location = New System.Drawing.Point(248, 222)
        Me.Prj_Person.Name = "Prj_Person"
        Me.Prj_Person.Size = New System.Drawing.Size(224, 29)
        Me.Prj_Person.TabIndex = 8
        Me.Prj_Person.Text = ""
        '
        'Prj_HMI
        '
        Me.Prj_HMI.Location = New System.Drawing.Point(248, 184)
        Me.Prj_HMI.Name = "Prj_HMI"
        Me.Prj_HMI.Size = New System.Drawing.Size(224, 29)
        Me.Prj_HMI.TabIndex = 6
        Me.Prj_HMI.Text = ""
        '
        'Prj_LastDate
        '
        Me.Prj_LastDate.Location = New System.Drawing.Point(248, 146)
        Me.Prj_LastDate.Name = "Prj_LastDate"
        Me.Prj_LastDate.Size = New System.Drawing.Size(224, 29)
        Me.Prj_LastDate.TabIndex = 4
        Me.Prj_LastDate.Text = ""
        '
        'Prj_Date
        '
        Me.Prj_Date.Location = New System.Drawing.Point(248, 108)
        Me.Prj_Date.Name = "Prj_Date"
        Me.Prj_Date.Size = New System.Drawing.Size(224, 29)
        Me.Prj_Date.TabIndex = 3
        Me.Prj_Date.Text = ""
        '
        'Prj_Comment
        '
        Me.Prj_Comment.Location = New System.Drawing.Point(248, 70)
        Me.Prj_Comment.Name = "Prj_Comment"
        Me.Prj_Comment.Size = New System.Drawing.Size(224, 29)
        Me.Prj_Comment.TabIndex = 2
        Me.Prj_Comment.Text = ""
        '
        'GetProjectInfo
        '
        Me.GetProjectInfo.Location = New System.Drawing.Point(16, 32)
        Me.GetProjectInfo.Name = "GetProjectInfo"
        Me.GetProjectInfo.Size = New System.Drawing.Size(80, 56)
        Me.GetProjectInfo.TabIndex = 1
        Me.GetProjectInfo.Text = "Get"
        '
        'Prj_File
        '
        Me.Prj_File.Location = New System.Drawing.Point(248, 32)
        Me.Prj_File.Name = "Prj_File"
        Me.Prj_File.Size = New System.Drawing.Size(224, 29)
        Me.Prj_File.TabIndex = 0
        Me.Prj_File.Text = ""
        '
        'Form1
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(6, 14)
        Me.ClientSize = New System.Drawing.Size(544, 469)
        Me.Controls.Add(Me.TabControl1)
        Me.Font = New System.Drawing.Font("Microsoft Sans Serif", 9.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Name = "Form1"
        Me.Text = "Handling API Sample for VB.NET"
        Me.TabControl1.ResumeLayout(False)
        Me.TabPage1.ResumeLayout(False)
        Me.GroupBox5.ResumeLayout(False)
        Me.GroupBox1.ResumeLayout(False)
        Me.TabPage4.ResumeLayout(False)
        Me.GroupBox2.ResumeLayout(False)
        Me.TabPage3.ResumeLayout(False)
        Me.GroupBox4.ResumeLayout(False)
        Me.ResumeLayout(False)

    End Sub

#End Region

    ' 5 Get runtime state.
    Private Sub Bt_GetStartState_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Bt_GetStartState.Click

        Me.Cursor = Cursors.WaitCursor  ' Change cursor.

        Try

            ' Get state (API).
            Dim Status As Int32
            Dim RetVal As Int32 = GetRuntimeStartState(ghWinGP, Status)

            ' error ?
            If RetVal <> API_ERROR.E_SUCCESS Then
                MsgBox("Err(" + Str(RetVal).Trim() + "):GetRuntimeStartState()")
            End If

            ' Show state.
            Select Case Status
                Case 0
                    Me.StartState.Text = "Starting"
                Case 1
                    Me.StartState.Text = "Online"
                Case 2
                    Me.StartState.Text = "Offline"
                Case 3
                    Me.StartState.Text = "Transfer mode"
                Case 4
                    Me.StartState.Text = "Ending"
                Case 5
                    Me.StartState.Text = "Un active"
            End Select

        Catch ex As Exception

            MsgBox(ex.Message)

        End Try

        Me.Cursor = Cursors.Default     ' Change cursor.

    End Sub

    Private Sub GetScreenState_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BT_GetScreenState.Click

        Me.Cursor = Cursors.WaitCursor  ' Change cursor.

        Try

            ' Get state (API).
            Dim Status As Int32
            Dim RetVal As Int32 = GetScreenState(ghWinGP, Status)

            ' error ?
            If RetVal <> API_ERROR.E_SUCCESS Then
                MsgBox("Err(" + Str(RetVal).Trim() + "):GetScreenState()")
            End If

            ' Show state.
            Select Case Status
                Case 0, 1, 2
                    Me.ScreenState.SelectedIndex = Status
            End Select

        Catch ex As Exception

            MsgBox(ex.Message)

        End Try

        Me.Cursor = Cursors.Default     ' Change cursor.

    End Sub

    Private Sub SetScreenState_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BT_SetScreenState.Click

        Me.Cursor = Cursors.WaitCursor  ' Change cursor.

        Try
            ' Set values.
            Dim State As Int32 = Me.ScreenState.SelectedIndex
            Dim PosX As Int32 = Val(Me.PosX.Text)
            Dim PosY As Int32 = Val(Me.PosY.Text)
            Dim Width As Int32 = Val(Me.TX_Width.Text)
            Dim Height As Int32 = Val(Me.TX_Height.Text)

            ' Set screen state.
            Dim RetVal As Int32 = SetScreenState(ghWinGP, State, PosX, PosY, Width, Height)

            ' error ?
            If RetVal <> API_ERROR.E_SUCCESS Then
                MsgBox("Err(" + Str(RetVal).Trim() + "):SetScreenState()")
            End If

        Catch ex As Exception

            MsgBox(ex.Message)

        End Try

        Me.Cursor = Cursors.Default     ' Change cursor.

    End Sub

    Private Sub GetDispScreen_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles GetDispScreen.Click

        Me.Cursor = Cursors.WaitCursor  ' Change cursor.

        Dim CurScrNo As Int32           ' Screen number under display.

        Try

            ' Get state (API).
            Dim RetVal As Int32 = GetDisplayScreenNumber(ghWinGP, CurScrNo)

            ' error ?
            If RetVal <> API_ERROR.E_SUCCESS Then
                MsgBox("Err(" + Str(RetVal).Trim() + "):GetDisplayScreenNumber()")
            End If

        Catch ex As Exception

            MsgBox(ex.Message)

        End Try

        Try

            ' Get the number of screens.
            Dim ScreenCount As Int32 = 0
            Dim RetVal As Int32 = GetEnumScreenNumberCount(ghWinGP, ScreenCount)

            ' error ?
            If RetVal <> API_ERROR.E_SUCCESS Then
                MsgBox("Err(" + Str(RetVal).Trim() + "):GetEnumScreenNumberCount()")
            End If

            ' Get screen numbers.
            If ScreenCount > 0 Then

                ' Get screen numbers.
                Dim ScreenNumber(ScreenCount - 1) As Int32
                RetVal = EnumScreenNumber(ghWinGP, ScreenCount, ScreenNumber(0))

                ' error ?
                If RetVal <> API_ERROR.E_SUCCESS Then
                    MsgBox("Err(" + Str(RetVal).Trim() + "):EnumScreenNumber()")
                End If

                ' ----- Show State -----

                ' All delete.
                Me.CB_DispScreen.Items.Clear()

                ' The acquired screen number is set.
                Dim idx As Int32
                For idx = 0 To ScreenNumber.Length - 1
                    Me.CB_DispScreen.Items.Add(ScreenNumber(idx))
                Next

                ' Show current screen number.
                For idx = 0 To ScreenNumber.Length - 1
                    If CurScrNo = Val(Me.CB_DispScreen.Items(idx)) Then
                        Me.CB_DispScreen.SelectedIndex = idx
                        Exit For
                    End If
                Next

            End If

        Catch ex As Exception

            MsgBox(ex.Message)

        End Try

        Me.Cursor = Cursors.Default     ' Change cursor.

    End Sub

    Private Sub SetDispScreen_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SetDispScreen.Click

        Me.Cursor = Cursors.WaitCursor  ' Change cursor.

        Try

            ' Set value.
            Dim Screen As Int32
            Screen = Val(Me.CB_DispScreen.Text)

            ' Change screen number.
            Dim RetVal As Int32 = SetDisplayScreenNumber(ghWinGP, Screen)

            ' error ?
            If RetVal <> API_ERROR.E_SUCCESS Then
                MsgBox("Err(" + Str(RetVal).Trim() + "):SetDisplayScreenNumber()")
            End If

            ' Whether it changed normally re-acquires a screen number,
            ' and it compares it with the set-up value.
            Dim NowScrNo As Long
            RetVal = GetDisplayScreenNumber(ghWinGP, NowScrNo)
            If RetVal = API_ERROR.E_SUCCESS Then
                If NowScrNo = Screen Then
                    'MsgBox("It succeeded in change of a screen. No=" + Str(NowScrNo))
                End If
            End If

        Catch ex As Exception

            MsgBox(ex.Message)

        End Try

        Me.Cursor = Cursors.Default     ' Change cursor.

    End Sub

    Private Sub GetProjectInfo_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles GetProjectInfo.Click

        Me.Cursor = Cursors.WaitCursor  ' Change cursor.

        Try

            ' Alocate work area.
            Dim ProjectFileName As New System.Text.StringBuilder(PROJECTINFO_SIZE.e_FileName)
            Dim ProjectComment As New System.Text.StringBuilder(PROJECTINFO_SIZE.e_Comment)
            Dim ProjectFastTime As New System.Text.StringBuilder(PROJECTINFO_SIZE.e_FastTime)
            Dim ProjectLastTime As New System.Text.StringBuilder(PROJECTINFO_SIZE.e_LastTiem)
            Dim ProjectIDownload As New System.Text.StringBuilder(PROJECTINFO_SIZE.e_IDownload)
            Dim HMIEditorVersion As New System.Text.StringBuilder(PROJECTINFO_SIZE.e_HMIEditorVersion)
            Dim ControlEditorVersion As New System.Text.StringBuilder(PROJECTINFO_SIZE.e_ControlEditorVersion)
            Dim MakingPerson As New System.Text.StringBuilder(PROJECTINFO_SIZE.e_MakingPerson)

            ' Get project information.
            Dim RetVal As Int32
            RetVal = GetProjctInformation(ghWinGP, _
                ProjectFileName, _
                ProjectComment, _
                ProjectFastTime, _
                ProjectLastTime, _
                ProjectIDownload, _
                HMIEditorVersion, _
                ControlEditorVersion, _
                MakingPerson)

            ' error ?
            If RetVal <> API_ERROR.E_SUCCESS Then
                MsgBox("Err(" + Str(RetVal).Trim() + "):GetProjctInformation()")
            End If

            ' Show the information.
            Me.Prj_File.Text = ProjectFileName.ToString()
            Me.Prj_Comment.Text = ProjectComment.ToString()
            Me.Prj_Date.Text = ProjectFastTime.ToString()
            Me.Prj_LastDate.Text = ProjectLastTime.ToString()
            Me.Prj_HMI.Text = HMIEditorVersion.ToString()
            Me.Prj_Person.Text = MakingPerson.ToString

        Catch ex As Exception

            MsgBox(ex.Message)

        End Try

        Me.Cursor = Cursors.Default     ' Change cursor.

    End Sub

    ' 13 Exit WinGP.
    Private Sub StopWinGP_Q_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles StopWinGP_Q.Click

        Me.Cursor = Cursors.WaitCursor  ' Change cursor.

        Try

            ' (API).
            Dim RetVal As Int32 = StopRuntime(ghWinGP, 1)

            ' error ?
            If RetVal <> API_ERROR.E_SUCCESS Then
                MsgBox("Err(" + Str(RetVal).Trim() + "):StopRuntime()")
            End If

        Catch ex As Exception

            MsgBox(ex.Message)

        End Try

        Me.Cursor = Cursors.Default     ' Change cursor.

    End Sub

End Class
