#if !(defined(PROEASY_H) && defined(WINGPAPI_H))
#define WINGPAPI_H

 /*
  ------------------------------------------------------------------------

    WinGPAPI.h -- This is a part of the WinGP API's.

              Copyright (C) 2006 Digital Electronics Corporation

  ---------------------------------------------------------------------- 

		ProEasy.DLL 
	
		Version     1.0				Complying with Pro-Server Version 1.0

		Version 	1.1 			Complying with the multi Pro-Server handle
									(The version of the Pro-Server is effective in more than 1.0) 				

		Version 	1.5				Complying with Group Item & cache/direct read 
									(The version of the Pro-Server is effective in more than 1.5) 				

		Version 	2.0				SRAM backup data write 
									It is changed from the node name to IP address.
									(The version of the Pro-Server is effective in more than 2.0) 				
				
		Version 	3.0				GP-Web Version 1.0
									(The version of the Pro-Server is effective in more than 3.0) 				

		Version 	3.1				Direct Wirte(no read after write mode)
									(The version of the Pro-Server is effective in more than 3.1)
									
		Version		4.0				Network project access API
									(The version of the Pro-Server is effective in more than 4.0)

		Version		4.1				Data Base and Time Bar API and CSV file transfer API
									(The version of the Pro-Server is effective in more than 4.1)
		
		Version		4.5				CSV file transfer API
									(The version of the Pro-Server is effective in more than 4.5)
									
		Version		5.0				Pro-Server Ex
	                                (The version of the Pro-Server EX is effective in more than 1.0)

		Version		5.1				WinGP Pro-Server Ex
  ------------------------------------------------------------------------
*/




#ifndef OK
	#define OK	0
#endif
#ifndef CANCEL
	#define CANCEL 1
#endif
#ifndef ON
	#define ON	1
#endif
#ifndef OFF
	#define OFF 0
#endif

#ifndef EXSS
	#define EXSS(c) {INT __ret ; if(__ret = c) return( __ret ) ; }
#endif
#ifndef BOOLEXSS
	#define BOOLEXSS(c) { if(!(c)) return( false ); }
#endif
#ifndef DELETENULL
	#define DELETENULL(c) { if(c) delete c ; c = NULL ;}
#endif
#ifndef PCHAR
	#define PCHAR(c) (char *)((LPCSTR)c)
#endif
typedef double DOUBLE ;


/* --------------------------------------------------------------------------------
 	Application Data Type
   -------------------------------------------------------------------------------- */
#define EASY_AppKind_NULL							0		// Default
#define EASY_AppKind_Bit							1		// Bit Data
#define EASY_AppKind_SignedWord						2		// 16 Bit(Signed) Data
#define EASY_AppKind_UnsignedWord					3		// 16 Bit(Unsigned) Data
#define EASY_AppKind_HexWord						4		// 16 Bit(HEX) Data
#define EASY_AppKind_BCDWord						5		// 16 Bit(BCD) Data
#define EASY_AppKind_SignedDWord					6		// 32 Bit(Signed) Data
#define EASY_AppKind_UnsignedDWord					7		// 32 Bit(Unsigned) Data
#define EASY_AppKind_HexDWord						8		// 32 Bit(HEX) Data
#define EASY_AppKind_BCDDWord						9		// 32 Bit(BCD) Data
#define EASY_AppKind_Float							10		// Float Data
#define EASY_AppKind_Real							11		// Double Data
#define EASY_AppKind_Str							12		// String Data

#define EASY_AppKind_Group							0x8000	// Group
#define EASY_AppKind_SymbolSheet					0x9000	// Symbol sheet
#define EASY_AppKind_BOOL							0x0201	// BOOL Data

/* --------------------------------------------------------------------------------
 	GP BACKUP DATA TYPE
   -------------------------------------------------------------------------------- */
#define EASY_BackupDataType_FILING					1		// Filing Data
#define EASY_BackupDataType_LOG						2		// Logging Data
#define EASY_BackupDataType_TREND					3		// Trend Data
#define EASY_BackupDataType_SAMPLING				4		// Sampling Data
#define EASY_BackupDataType_ALARMHISTRY				6		// Alarm History Data
#define EASY_BackupDataType_ALARMLOG				7		// Alarm Log Data

#define EASY_BackupDataType_ALARMBLOCK1				5		// Alarm Block 1
#define EASY_BackupDataType_ALARMBLOCK2				6		// Alarm Block 2 
#define EASY_BAckupDataType_ALARMBLOCK3				7		// Alarm Block 3
#define EASY_BackupDataType_ALARMBLOCK4				8		// Alarm Block 4
#define EASY_BackupDataType_ALARMBLOCK5				9		// Alarm Block 5
#define EASY_BackupDataType_ALARMBLOCK6				10		// Alarm Block 6
#define EASY_BackupDataType_ALARMBLOCK7				11		// Alarm Block 7
#define EASY_BackupDataType_ALARMBLOCK8				12		// Alarm Block 8
#define EASY_BackupDataType_SAMPLING_With_Group		0x8002		// Sampling Data with Group Number

#define EASY_BackupDataType_SaveMode_Rewrite		0		// Rewrite mode
#define EASY_BackupDataType_SaveMode_Append			1		// Append mode



// --------------------------------------------------------------------------------
// 	Pro-Easy system functions
INT WINAPI EasyInit();
INT WINAPI EasyTerm();
INT WINAPI EasyGetSystemStatus();

//  wait setting
INT WINAPI EasySetWaitType(DWORD dwWaitType);
DWORD WINAPI EasyGetWaitType();


// --------------------------------------------------------------------------------
// API error message function
BOOL WINAPI EasyLoadErrorMessage(INT iErrorCode,LPSTR osErrorMessage );

//	API that an error message is acquired from the error code and that it is expanded
BOOL WINAPI EasyLoadErrorMessageEx(INT iErrorCode,LPSTR osErrorMessage );
BOOL WINAPI EasyLoadErrorMessageW(INT iErrorCode,LPWSTR owsErrorMessage );
BOOL WINAPI EasyLoadErrorMessageExW(INT iErrorCode,LPWSTR owsErrorMessage );


// --------------------------------------------------------------------------------
// Write functions
INT WINAPI WriteDeviceBit(LPCSTR sNodeName,LPCSTR sDeviceName,WORD* pwData,WORD wCount);
INT WINAPI WriteDevice16(LPCSTR sNodeName,LPCSTR sDeviceName,WORD* pwData,WORD wCount);
INT WINAPI WriteDevice32(LPCSTR sNodeName,LPCSTR sDeviceName,DWORD* pdwData,WORD wCount);
INT WINAPI WriteDeviceBCD16(LPCSTR sNodeName,LPCSTR sDeviceName,WORD* pwData,WORD wCount);
INT WINAPI WriteDeviceBCD32(LPCSTR sNodeName,LPCSTR sDeviceName,DWORD* pdwData,WORD wCount);
INT WINAPI WriteDeviceFloat(LPCSTR sNodeName,LPCSTR sDeviceName,FLOAT* pflData,WORD wCount);
INT WINAPI WriteDeviceDouble(LPCSTR sNodeName,LPCSTR sDeviceName,DOUBLE* pdbData,WORD wCount);
INT WINAPI WriteDeviceStr(LPCSTR sNodeName,LPCSTR sDeviceName,LPCSTR psData,WORD wCount);
INT WINAPI WriteDevice(LPCSTR sNodeName,LPCSTR sDeviceName,LPVOID pData,WORD wCount,WORD wAppKind);
INT WINAPI WriteDeviceVariant(LPCSTR sNodeName,LPCSTR sDeviceName,LPVARIANT pData,WORD wCount,WORD wAppKind);


// --------------------------------------------------------------------------------
// Read functions
INT WINAPI ReadDeviceBit(LPCSTR sNodeName,LPCSTR sDeviceName,WORD* owData,WORD wCount);
INT WINAPI ReadDevice16(LPCSTR sNodeName,LPCSTR sDeviceName,WORD* owData,WORD wCount);
INT WINAPI ReadDevice32(LPCSTR sNodeName,LPCSTR sDeviceName,DWORD* odwData,WORD wCount);
INT WINAPI ReadDeviceBCD16(LPCSTR sNodeName,LPCSTR sDeviceName,WORD* owData,WORD wCount);
INT WINAPI ReadDeviceBCD32(LPCSTR sNodeName,LPCSTR sDeviceName,DWORD* odwData,WORD wCount);
INT WINAPI ReadDeviceFloat(LPCSTR sNodeName,LPCSTR sDeviceName,FLOAT* oflData,WORD wCount);
INT WINAPI ReadDeviceDouble(LPCSTR sNodeName,LPCSTR sDeviceName,DOUBLE* odbData,WORD wCount);
INT WINAPI ReadDeviceStr(LPCSTR sNodeName,LPCSTR sDeviceName,LPSTR psData,WORD wCount);
INT WINAPI ReadDevice(LPCSTR sNodeName,LPCSTR sDeviceName,LPVOID pData,WORD wCount,WORD wAppKind);
INT WINAPI ReadDeviceVariant(LPCSTR sNodeName,LPCSTR sDeviceName,LPVARIANT pData,WORD wCount,WORD wAppKind);


// --------------------------------------------------------------------------------
// Symbol Information's API
struct SymbolInformation
{
	WORD	m_wAppKind ;			/* Application data type (1 to 12, 0x8000 ) */
	WORD	m_wDataCount ;			/* Count of data */
	DWORD	m_dwSizeOf ;			/* The byte size of the buffer which is necessary to access it */
	char	m_sSymbolName[64+1] ;	/* Symbol name */
	char	m_bDummy1[3] ;			/* Dummy[0],Dummy[1] reserved, Dummy[2] extend infomation */
	char	m_sDeviceAddress[256+1] ;/* Device address */
	char	m_bDummy2[3] ;
};

INT WINAPI SizeOfSymbol(LPCSTR sNodeName,LPCSTR sSymbolName,INT* oiByteSize);
INT WINAPI GetCountOfSymbolMember(LPCSTR sNodeName,LPCSTR sSymbolName,INT* oiCountOfMember);
INT WINAPI GetSymbolInformation(LPCSTR sNodeName,LPCSTR sSymbolName,INT iMaxCountOfSymbolMember,LPSTR osSymbolSheetName,SymbolInformation* oSymbolInformation,INT* oiGotCountOfSymbolMember);

// Group Access API
INT WINAPI ReadSymbol(LPCSTR sNodeName,LPCSTR sSymbolName,LPVOID oReadBufferData);
INT WINAPI ReadSymbolVariant(LPCSTR sNodeName,LPCSTR sSymbolName,LPVARIANT pData);

INT WINAPI WriteSymbol(LPCSTR sNodeName,LPCSTR sSymbolName,LPVOID pWriteBufferData);
INT WINAPI WriteSymbolVariant(LPCSTR sNodeName,LPCSTR sSymbolName,LPVARIANT pData);


// --------------------------------------------------------------------------------
//  Queuing Access Control's API
INT WINAPI BeginQueuingRead();
INT WINAPI BeginQueuingWrite();
INT WINAPI ExecuteQueuingAccess();
INT WINAPI CancelQueuingAccess();
INT WINAPI IsQueuingAccessSucceeded(INT iIndex);


// --------------------------------------------------------------------------------
// SRAM access functions 
INT WINAPI EasyBackupDataRead(LPCSTR sSaveFileName,LPCSTR sNodeName,INT iBackupDataType,INT iSaveMode);
INT WINAPI EasyBackupDataReadEx( LPCSTR sSaveFileName, LPCSTR sNodeName, INT iBackupDataType, INT iSaveMode, INT iNumber = 0 , INT iStringTable  = 0x0000 );

INT WINAPI EasyBackupDataWrite(LPCSTR sSourceFileName,LPCSTR sNodeName,INT iBackupDataType);


// --------------------------------------------------------------------------------
// CF Card functions 
INT WINAPI EasyIsCFCard(LPCSTR sNodeName) ;

// CSV file transfer API's
struct stEasyDirInfo {
	BYTE bFileName[8+1];		// FileName
	BYTE bExt[3+1];				// Extension
	BYTE bDummy[3];				// Dummy
	DWORD dwFileSize;			// FileSize
	BYTE bFileTimeStamp[8+1];	// TimeStamp
	BYTE bDummy2[3];			// Dummy2
} ;


INT WINAPI EasyGetListInCard(LPCSTR sNodeName, LPCSTR sDirectory, INT* oiCount, LPCSTR sSaveFileName);
INT WINAPI EasyFileReadCard(LPCSTR sNodeName, LPCSTR pReadFileType, WORD wReadFileNo, LPCSTR sWriteFileName, DWORD* odwFileSize);
INT WINAPI EasyFileWriteCard(LPCSTR sNodeName, LPCSTR pReadFileName, LPCSTR sWriteFileType, WORD wWriteFileNo);
INT WINAPI EasyGetCfFreeSpace(LPCSTR sNodeName, INT* oiUnallocated);

INT WINAPI EasyFileDeleteCard(LPCSTR sNodeName, LPCSTR pDeleteFileType, WORD wDeleteFileNo) ;
INT WINAPI EasyGetListInCfCard(LPCSTR sNodeName, LPCSTR sDirectory, INT* oiCount, LPCSTR sSaveFileName) ;
INT WINAPI EasyFileDeleteInCfCard(LPCSTR sNodeName, LPCSTR sFolderName, LPCSTR sFileName) ;
INT WINAPI EasyFileReadInCfCard(LPCSTR sNodeName, LPCSTR sFolderName, LPCSTR sFileName, LPCSTR pWriteFileName, DWORD* odwFileSize) ;
INT WINAPI EasyFileWriteInCfCard(LPCSTR sNodeName, LPCSTR pReadFileName, LPCSTR sFolderName, LPCSTR sFileName) ;
INT WINAPI EasyFileRenameInCfCard(LPCSTR sNodeName, LPCSTR sFolderName, LPCSTR sFileName, LPCSTR sFileRename) ;

//  CF-CARD access control API
INT WINAPI EasyFileSetPassiveMode(INT iPassive) ;


// --------------------------------------------------------------------------------
// node status 
INT WINAPI GetNodeProperty(LPCSTR sNodeName,DWORD dwTimeLimit,LPSTR osGPType,LPSTR osSystemVersion,LPSTR osComVersion,LPSTR osECOMVersion) ;


// --------------------------------------------------------------------------------
// node time functions
DWORD WINAPI EasyGetGPTime(LPCSTR sNodeName, DWORD* odwTime);
DWORD WINAPI EasyGetGPTimeVariant(LPCSTR sNodeName, LPVARIANT ovTime);
DWORD WINAPI EasyGetGPTimeString(LPCSTR sNodeName, LPCSTR sFormat, LPSTR osTime);
DWORD WINAPI EasyGetGPTimeStringVariant(LPCSTR sNodeName, LPCSTR sFormat, LPVARIANT ovTime);


#endif // WINGPAPI_H
