#ifndef PROEASY_H
#define PROEASY_H
 /*
  ------------------------------------------------------------------------

    ProEasy.h -- This is a part of the Pro-Server API's.

              Copyright (C) 1998-2007 Digital Electronics Corporation

  ---------------------------------------------------------------------- 

		ProEasy.DLL 
	
		Version     1.0				Complying with Pro-Server Version 1.0

		Version 	1.1 			Complying with the multi Pro-Server handle
									(The version of the Pro-Server is effective in more than 1.0) 				

		Version 	1.5				Complying with Group Item & cache/direct read 
									(The version of the Pro-Server is effective in more than 1.5) 				

		Version 	2.0				SRAM backup data write 
									It is changed from the node name to IP address.
									(The version of the Pro-Server is effective in more than 2.0) 				
				
		Version 	3.0				GP-Web Version 1.0
									(The version of the Pro-Server is effective in more than 3.0) 				

		Version 	3.1				Direct Wirte(no read after write mode)
									(The version of the Pro-Server is effective in more than 3.1)
									
		Version		4.0				Network project access API
									(The version of the Pro-Server is effective in more than 4.0)

		Version		4.1				Data Base and Time Bar API and CSV file transfer API
									(The version of the Pro-Server is effective in more than 4.1)
		
		Version		4.5				CSV file transfer API
									(The version of the Pro-Server is effective in more than 4.5)
									
		Version		5.0				Pro-Server Ex
	                                (The version of the Pro-Server EX is effective in more than 1.0)

		Version		5.1				WinGP was supported. (Pro-Server EX Ver1.10)

		Version		5.2				OPC was supported.	(Pro-Server EX Ver1.20)

		Version		5.3				LT Series was supported. (Pro-Server EX Ver1.21)
  ------------------------------------------------------------------------
*/




#ifndef OK
	#define OK	0
#endif
#ifndef CANCEL
	#define CANCEL 1
#endif
#ifndef ON
	#define ON	1
#endif
#ifndef OFF
	#define OFF 0
#endif

#ifndef EXSS
	#define EXSS(c) {INT __ret ; if(__ret = c) return( __ret ) ; }
#endif
#ifndef BOOLEXSS
	#define BOOLEXSS(c) { if(!(c)) return( false ); }
#endif
#ifndef DELETENULL
	#define DELETENULL(c)	{ if(c) delete c ; c = NULL ;}
#endif
#ifndef PCHAR
	#define PCHAR(c) (char *)((LPCSTR)c)
#endif
typedef double DOUBLE ;


/* --------------------------------------------------------------------------------
 	Application Data Type
   -------------------------------------------------------------------------------- */
#define EASY_AppKind_NULL							0		// Default
#define EASY_AppKind_Bit							1		// Bit Data
#define EASY_AppKind_SignedWord						2		// 16 Bit(Signed) Data
#define EASY_AppKind_UnsignedWord					3		// 16 Bit(Unsigned) Data
#define EASY_AppKind_HexWord						4		// 16 Bit(HEX) Data
#define EASY_AppKind_BCDWord						5		// 16 Bit(BCD) Data
#define EASY_AppKind_SignedDWord					6		// 32 Bit(Signed) Data
#define EASY_AppKind_UnsignedDWord					7		// 32 Bit(Unsigned) Data
#define EASY_AppKind_HexDWord						8		// 32 Bit(HEX) Data
#define EASY_AppKind_BCDDWord						9		// 32 Bit(BCD) Data
#define EASY_AppKind_Float							10		// Float Data
#define EASY_AppKind_Real							11		// Double Data
#define EASY_AppKind_Str							12		// String Data

#define EASY_AppKind_Group							0x8000	// Group
#define EASY_AppKind_SymbolSheet					0x9000	// Symbol sheet
#define EASY_AppKind_BOOL							0x0201	// BOOL Data

/* --------------------------------------------------------------------------------
 	GP BACKUP DATA TYPE
   -------------------------------------------------------------------------------- */
#define EASY_BackupDataType_FILING					1		// Filing Data
#define EASY_BackupDataType_LOG						2		// Logging Data
#define EASY_BackupDataType_TREND					3		// Trend Data
#define EASY_BackupDataType_SAMPLING				4		// Sampling Data
#define EASY_BackupDataType_ALARMHISTRY				6		// Alarm History Data
#define EASY_BackupDataType_ALARMLOG				7		// Alarm Log Data

#define	EASY_BackupDataType_ALARMBLOCK1				5		// Alarm Block 1
#define	EASY_BackupDataType_ALARMBLOCK2				6		// Alarm Block 2 
#define	EASY_BAckupDataType_ALARMBLOCK3				7		// Alarm Block 3
#define	EASY_BackupDataType_ALARMBLOCK4				8		// Alarm Block 4
#define	EASY_BackupDataType_ALARMBLOCK5				9		// Alarm Block 5
#define	EASY_BackupDataType_ALARMBLOCK6				10		// Alarm Block 6
#define	EASY_BackupDataType_ALARMBLOCK7				11		// Alarm Block 7
#define	EASY_BackupDataType_ALARMBLOCK8				12		// Alarm Block 8
#define EASY_BackupDataType_SAMPLING_With_Group		0x8002		// Sampling Data with Group Number

#define EASY_BackupDataType_SaveMode_Rewrite		0		// Rewrite mode
#define EASY_BackupDataType_SaveMode_Append			1		// Append mode




/* --------------------------------------------------------------------------------
 	Pro-Easy system functions
   -------------------------------------------------------------------------------- */
INT WINAPI EasyGetSystemStatus();
BOOL WINAPI EasyLoadErrorMessage(INT iErrorCode,LPSTR osErrorMessage );

INT WINAPI EasyInit();
INT WINAPI EasyTerm();

#define EASY_LogLevel_SysMessage		0x01	// System Movement Message 		
#define EASY_LogLevel_SysError			0x02	// System Error Message
#define EASY_LogLevel_AppError			0x04	// Application Error Message
#define EASY_LogLevel_AppStart			0x08	// Application Start Message
#define EASY_LogLevel_AppEnd			0x10	// Application End Message
#define EASY_LogLevel_AppWarning		0x20	// Application Warning Message
#define EASY_LogLevel_AppMessage1		0x40	// Application Details Message1
#define EASY_LogLevel_AppMessage2		0x80	// Application Details Message2

INT WINAPI EasyOutputLog(BYTE bLevel,LPCSTR sPrompt,LPCSTR sMessage);
INT WINAPI EasyOutputLogClear();


/* --------------------------------------------------------------------------------
 	Single Pro-Server handle functions( handle not use )
   -------------------------------------------------------------------------------- */

	// Write functions
INT WINAPI WriteDeviceBit(LPCSTR sNodeName,LPCSTR sDeviceName,WORD* pwData,WORD wCount);
INT WINAPI WriteDevice16(LPCSTR sNodeName,LPCSTR sDeviceName,WORD* pwData,WORD wCount);
INT WINAPI WriteDevice32(LPCSTR sNodeName,LPCSTR sDeviceName,DWORD* pdwData,WORD wCount);
INT WINAPI WriteDeviceBCD16(LPCSTR sNodeName,LPCSTR sDeviceName,WORD* pwData,WORD wCount);
INT WINAPI WriteDeviceBCD32(LPCSTR sNodeName,LPCSTR sDeviceName,DWORD* pdwData,WORD wCount);
INT WINAPI WriteDeviceFloat(LPCSTR sNodeName,LPCSTR sDeviceName,FLOAT* pflData,WORD wCount);
INT WINAPI WriteDeviceDouble(LPCSTR sNodeName,LPCSTR sDeviceName,DOUBLE* pdbData,WORD wCount);
INT WINAPI WriteDeviceStr(LPCSTR sNodeName,LPCSTR sDeviceName,LPCSTR psData,WORD wCount);
INT WINAPI WriteDevice(LPCSTR sNodeName,LPCSTR sDeviceName,LPVOID pData,WORD wCount,WORD wAppKind);
INT WINAPI WriteDeviceVariant(LPCSTR sNodeName,LPCSTR sDeviceName,LPVARIANT pData,WORD wCount,WORD wAppKind);

	// Direct Write functions
INT WINAPI WriteDeviceBitD(LPCSTR sNodeName,LPCSTR sDeviceName,WORD* pwData,WORD wCount);
INT WINAPI WriteDevice16D(LPCSTR sNodeName,LPCSTR sDeviceName,WORD* pwData,WORD wCount);
INT WINAPI WriteDevice32D(LPCSTR sNodeName,LPCSTR sDeviceName,DWORD* pdwData,WORD wCount);
INT WINAPI WriteDeviceBCD16D(LPCSTR sNodeName,LPCSTR sDeviceName,WORD* pwData,WORD wCount);
INT WINAPI WriteDeviceBCD32D(LPCSTR sNodeName,LPCSTR sDeviceName,DWORD* pdwData,WORD wCount);
INT WINAPI WriteDeviceFloatD(LPCSTR sNodeName,LPCSTR sDeviceName,FLOAT* pflData,WORD wCount);
INT WINAPI WriteDeviceDoubleD(LPCSTR sNodeName,LPCSTR sDeviceName,DOUBLE* pdbData,WORD wCount);
INT WINAPI WriteDeviceStrD(LPCSTR sNodeName,LPCSTR sDeviceName,LPCSTR psData,WORD wCount);
INT WINAPI WriteDeviceD(LPCSTR sNodeName,LPCSTR sDeviceName,LPVOID pData,WORD wCount,WORD wAppKind);
INT WINAPI WriteDeviceVariantD(LPCSTR sNodeName,LPCSTR sDeviceName,LPVARIANT pData,WORD wCount,WORD wAppKind);



	// Cache read functions
INT WINAPI ReadDeviceBit(LPCSTR sNodeName,LPCSTR sDeviceName,WORD* owData,WORD wCount);
INT WINAPI ReadDevice16(LPCSTR sNodeName,LPCSTR sDeviceName,WORD* owData,WORD wCount);
INT WINAPI ReadDevice32(LPCSTR sNodeName,LPCSTR sDeviceName,DWORD* odwData,WORD wCount);
INT WINAPI ReadDeviceBCD16(LPCSTR sNodeName,LPCSTR sDeviceName,WORD* owData,WORD wCount);
INT WINAPI ReadDeviceBCD32(LPCSTR sNodeName,LPCSTR sDeviceName,DWORD* odwData,WORD wCount);
INT WINAPI ReadDeviceFloat(LPCSTR sNodeName,LPCSTR sDeviceName,FLOAT* oflData,WORD wCount);
INT WINAPI ReadDeviceDouble(LPCSTR sNodeName,LPCSTR sDeviceName,DOUBLE* odbData,WORD wCount);
INT WINAPI ReadDeviceStr(LPCSTR sNodeName,LPCSTR sDeviceName,LPSTR psData,WORD wCount);
INT WINAPI ReadDevice(LPCSTR sNodeName,LPCSTR sDeviceName,LPVOID pData,WORD wCount,WORD wAppKind);
INT WINAPI ReadDeviceVariant(LPCSTR sNodeName,LPCSTR sDeviceName,LPVARIANT pData,WORD wCount,WORD wAppKind);

	// Direct read functions
INT WINAPI ReadDeviceBitD(LPCSTR sNodeName,LPCSTR sDeviceName,WORD* owData,WORD wCount);
INT WINAPI ReadDevice16D(LPCSTR sNodeName,LPCSTR sDeviceName,WORD* owData,WORD wCount);
INT WINAPI ReadDevice32D(LPCSTR sNodeName,LPCSTR sDeviceName,DWORD* odwData,WORD wCount);
INT WINAPI ReadDeviceBCD16D(LPCSTR sNodeName,LPCSTR sDeviceName,WORD* owData,WORD wCount);
INT WINAPI ReadDeviceBCD32D(LPCSTR sNodeName,LPCSTR sDeviceName,DWORD* odwData,WORD wCount);
INT WINAPI ReadDeviceFloatD(LPCSTR sNodeName,LPCSTR sDeviceName,FLOAT* oflData,WORD wCount);
INT WINAPI ReadDeviceDoubleD(LPCSTR sNodeName,LPCSTR sDeviceName,DOUBLE* odbData,WORD wCount);
INT WINAPI ReadDeviceStrD(LPCSTR sNodeName,LPCSTR sDeviceName,LPSTR psData,WORD wCount);
INT WINAPI ReadDeviceD(LPCSTR sNodeName,LPCSTR sDeviceName,LPVOID pData,WORD wCount,WORD wAppKind);
INT WINAPI ReadDeviceVariantD(LPCSTR sNodeName,LPCSTR sDeviceName,LPVARIANT pData,WORD wCount,WORD wAppKind);


INT WINAPI EasyBackupDataRead(LPCSTR sSaveFileName,LPCSTR sNodeName,INT iBackupDataType,INT iSaveMode);
INT WINAPI EasyBackupDataReadEx( LPCSTR sSaveFileName, LPCSTR sNodeName, INT iBackupDataType, INT iSaveMode, INT iNumber = 0 , INT iStringTable  = 0x0000 );

INT WINAPI EasyBackupDataWrite(LPCSTR sSourceFileName,LPCSTR sNodeName,INT iBackupDataType);
INT WINAPI EasyLoadNetworkProject(LPCSTR sDBName,DWORD dwSetOrAdd = TRUE);

INT WINAPI EasyGetAppKind(LPCSTR sNodeName,LPCSTR sDeviceName,WORD* owAppKind);
INT WINAPI EasyGetIPAdr(LPCSTR sNodeName,LPSTR osIPAdr,DWORD* odwExPLCType);
INT WINAPI EasyDevAdrToStr(LPSTR osDiStr, LPVOID pSiDev, DWORD dwExPLCType, WORD wAppKind);
INT WINAPI EasyStrToDevAdr(LPCSTR sSiStr, LPVOID oDiDev, DWORD dwExPLCType, WORD wAppKind);
INT WINAPI EasySetWaitType(DWORD dwWaitType);
DWORD WINAPI EasyGetWaitType();

	// Group functions  ( The version of the Pro-Server is effective in more than 1.5 )
INT WINAPI RegistEasyItems(DWORD dwEasyItemCount,LPCSTR* sNodeNames,LPCSTR* sDeviceNames,WORD* pwCount,HANDLE* ohEasyItems);	// It isn't being supported in Pro-Server EX Ver. 1
INT WINAPI DeleteEasyItems(DWORD dwEasyItemCount,HANDLE* phEasyItems);	// It isn't being supported in Pro-Server EX Ver. 1
INT WINAPI ReadEasyItems(DWORD dwEasyItemCount,HANDLE* phEasyItems,DWORD* odwResponses,LPVOID* oReadDatas);	// It isn't being supported in Pro-Server EX Ver. 1
INT WINAPI ReadEasyItemsD(DWORD dwEasyItemCount,HANDLE* phEasyItems,DWORD* odwResponses,LPVOID* oReadDatas);	// It isn't being supported in Pro-Server EX Ver. 1
INT WINAPI WriteEasyItems(DWORD dwEasyItemCount,HANDLE* phEasyItems,DWORD* odwResponses, LPVOID* pWriteDatas);	// It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI GetDeviceSize(HANDLE hEasyItem);	// It isn't being supported in Pro-Server EX Ver. 1






/* --------------------------------------------------------------------------------
 	Mulit Pro-Server handle functions
	------------------------------------------------------------------------------- */

	// Pro-Server handle functions
HANDLE WINAPI CreateProServerHandle();
INT WINAPI DeleteProServerHandle(HANDLE hProServer);


	// Write functions
INT WINAPI WriteDeviceBitM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,WORD* pwData,WORD wCount);
INT WINAPI WriteDevice16M(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,WORD* pwData,WORD wCount);
INT WINAPI WriteDevice32M(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,DWORD* pdwData,WORD wCount);
INT WINAPI WriteDeviceBCD16M(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,WORD* pwData,WORD wCount);
INT WINAPI WriteDeviceBCD32M(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,DWORD* pdwData,WORD wCount);
INT WINAPI WriteDeviceFloatM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,FLOAT* pflData,WORD wCount);
INT WINAPI WriteDeviceDoubleM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,DOUBLE* pdbData,WORD wCount);
INT WINAPI WriteDeviceStrM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,LPCSTR psData,WORD wCount);
INT WINAPI WriteDeviceM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,LPVOID pData,WORD wCount,WORD wAppKind);
INT WINAPI WriteDeviceVariantM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,LPVARIANT pData,WORD wCount,WORD wAppKind);

	// Direct Write functions
INT WINAPI WriteDeviceBitDM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,WORD* pwData,WORD wCount);
INT WINAPI WriteDevice16DM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,WORD* pwData,WORD wCount);
INT WINAPI WriteDevice32DM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,DWORD* pdwData,WORD wCount);
INT WINAPI WriteDeviceBCD16DM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,WORD* pwData,WORD wCount);
INT WINAPI WriteDeviceBCD32DM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,DWORD* pdwData,WORD wCount);
INT WINAPI WriteDeviceFloatDM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,FLOAT* pflData,WORD wCount);
INT WINAPI WriteDeviceDoubleDM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,DOUBLE* pdbData,WORD wCount);
INT WINAPI WriteDeviceStrDM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,LPCSTR psData,WORD wCount);
INT WINAPI WriteDeviceDM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,LPVOID pData,WORD wCount,WORD wAppKind);
INT WINAPI WriteDeviceVariantDM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,LPVARIANT pData,WORD wCount,WORD wAppKind);


	// Cache read functions
INT WINAPI ReadDeviceBitM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,WORD* owData,WORD wCount);
INT WINAPI ReadDevice16M(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,WORD* owData,WORD wCount);
INT WINAPI ReadDevice32M(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,DWORD* odwData,WORD wCount);
INT WINAPI ReadDeviceBCD16M(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,WORD* owData,WORD wCount);
INT WINAPI ReadDeviceBCD32M(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,DWORD* odwData,WORD wCount);
INT WINAPI ReadDeviceFloatM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,FLOAT* oflData,WORD wCount);
INT WINAPI ReadDeviceDoubleM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,DOUBLE* odbData,WORD wCount);
INT WINAPI ReadDeviceStrM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,LPSTR psData,WORD wCount);
INT WINAPI ReadDeviceM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,LPVOID pData,WORD wCount,WORD wAppKind);
INT WINAPI ReadDeviceVariantM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,LPVARIANT pData,WORD wCount,WORD wAppKind);

	// Direct read functions
INT WINAPI ReadDeviceBitDM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,WORD* owData,WORD wCount);
INT WINAPI ReadDevice16DM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,WORD* owData,WORD wCount);
INT WINAPI ReadDevice32DM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,DWORD* odwData,WORD wCount);
INT WINAPI ReadDeviceBCD16DM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,WORD* owData,WORD wCount);
INT WINAPI ReadDeviceBCD32DM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,DWORD* odwData,WORD wCount);
INT WINAPI ReadDeviceFloatDM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,FLOAT* oflData,WORD wCount);
INT WINAPI ReadDeviceDoubleDM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,DOUBLE* odbData,WORD wCount);
INT WINAPI ReadDeviceStrDM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,LPSTR psData,WORD wCount);
INT WINAPI ReadDeviceDM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,LPVOID pData,WORD wCount,WORD wAppKind);
INT WINAPI ReadDeviceVariantDM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,LPVARIANT pData,WORD wCount,WORD wAppKind);

INT WINAPI EasyBackupDataReadM(HANDLE hProServer,LPCSTR sSaveFileName,LPCSTR sNodeName,INT iBackupDataType,INT iSaveMode);
INT WINAPI EasyBackupDataReadExM(HANDLE hProServer, LPCSTR sSaveFileName, LPCSTR sNodeName, INT iBackupDataType, INT iSaveMode, INT iNumber = 0 , INT iStringTable  = 0x0000 );

INT WINAPI EasyBackupDataWriteM(HANDLE hProServer,LPCSTR sSourceFileName,LPCSTR sNodeName,INT iBackupDataType);
INT WINAPI EasyLoadNetworkProjectM(HANDLE hProServer,LPCSTR sDBName,DWORD dwSetOrAdd = TRUE);

INT WINAPI EasyGetAppKindM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sDeviceName,WORD* owAppKind);
INT WINAPI EasyGetIPAdrM(HANDLE hProServer,LPCSTR sNodeName,LPSTR osIPAdr,DWORD* odwExPLCType);
INT WINAPI EasySetWaitTypeM(HANDLE hProServer,DWORD dwWaitType);
DWORD WINAPI EasyGetWaitTypeM(HANDLE hProServer);


	// Group functions  ( The version of the Pro-Server is effective in more than 1.5 )
INT WINAPI RegistEasyItemsM(HANDLE hProServer,DWORD dwEasyItemCount,LPCSTR* sNodeNames,LPCSTR* sDeviceNames,WORD* pwCount,HANDLE* ohEasyItems);		// It isn't being supported in Pro-Server EX Ver. 1
INT WINAPI DeleteEasyItemsM(HANDLE hProServer,DWORD dwEasyItemCount,HANDLE* phEasyItems); 	// It isn't being supported in Pro-Server EX Ver. 1
INT WINAPI ReadEasyItemsM(HANDLE hProServer,DWORD dwEasyItemCount,HANDLE* phEasyItems,DWORD* odwResponses,LPVOID* oReadDatas); 	// It isn't being supported in Pro-Server EX Ver. 1
INT WINAPI ReadEasyItemsDM(HANDLE hProServer,DWORD dwEasyItemCount,HANDLE* phEasyItems,DWORD* odwResponses,LPVOID* oReadDatas); 	// It isn't being supported in Pro-Server EX Ver. 1
INT WINAPI WriteEasyItemsM(HANDLE hProServer,DWORD dwEasyItemCount,HANDLE* phEasyItems,DWORD* odwResponses, LPVOID* pWriteDatas);	// It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI GetDeviceSizeM(HANDLE hProServer,HANDLE hEasyItem);	// It isn't being supported in Pro-Server EX Ver. 1

/* --------------------------------------------------------------------------------
	VB <-> VC Convert functions
 	------------------------------------------------------------------------------- */
INT WINAPI VariantToTWay(short wAppKind,LPVOID oData,short wDataCount,LPVARIANT pvt);
INT WINAPI TWayToVariant(short wAppKind,LPVOID pData,short wDataCount,LPVARIANT ovt);
HANDLE WINAPI ToCSVStart();
INT WINAPI ShortToCSV(HANDLE hCsv,short stData);
INT WINAPI LongToCSV(HANDLE hCsv,long lData);
INT WINAPI DoubleToCSV(HANDLE hCsv,double dbData);
INT WINAPI StrToCSV(HANDLE hCsv,BSTR bstrData);
INT WINAPI ToCSVEnd(HANDLE hCsv,BSTR* pbstrData);
HANDLE WINAPI CSVToStart(LPCSTR sData);
INT WINAPI CSVToShort(HANDLE* phCsv,short* ostData);
INT WINAPI CSVToLong(HANDLE* phCsv,long* olData);
INT WINAPI CSVToDouble(HANDLE* phCsv,double* odbData);
INT WINAPI CSVToStr(HANDLE* phCsv,BSTR* obstrData);
INT WINAPI CSVToEnd(HANDLE hCsv);
LPCSTR WINAPI GetCSVWord(LPCSTR sSi,LPSTR osDi);
void WINAPI SetCSVWord(LPCSTR sSi,LPSTR osDi);
INT WINAPI IsCSVEnd(HANDLE* phCsv);

INT WINAPI ChgSymbolToDevName(LPCSTR sNodeName,LPCSTR sSymbolName,LPVOID oData,WORD wOffset,WORD wAppKind);

/* --------------------------------------------------------------------------------
	Add function for Pro-Server Version 4.0
 	------------------------------------------------------------------------------- */
INT WINAPI GetNodeProperty(LPCSTR sNodeName,DWORD dwTimeLimit,LPSTR osGPType,LPSTR osSystemVersion,LPSTR osComVersion,LPSTR osECOMVersion) ;
INT WINAPI GetNodePropertyM(HANDLE hProServer,LPCSTR sNodeName,DWORD dwTimeLimit,LPSTR osGPType,LPSTR osSystemVersion,LPSTR osComVersion,LPSTR osECOMVersion) ;
INT WINAPI EasyIsCFCard(LPCSTR sNodeName) ;
INT WINAPI EasyIsCFCardM(HANDLE hProServer,LPCSTR sNodeName) ;

// Data Base & Time Bar API's
// call back event code from Time Bar
#define PDB_CODE_START_POLLING_DB			0x00000001
#define PDB_CODE_STOP_POLLING_DB			0x00000002
#define PDB_CODE_SLIDER_MOVE				0x00000010
#define PDB_CODE_START_TIMEBAR_PLAY			0x00000020
#define PDB_CODE_STOP_TIMEBAR_PLAY			0x00000040
#define PDB_CODE_CHANGED_LINK_COUNT			0x00000080
#define PDB_CODE_OPEN_DB					0x00000100
#define PDB_CODE_CLOSE_DB					0x00000200
#define PDB_CODE_CHANGE_DB					0x00000400
#define PDB_CODE_CHANGE_DB_ERROR			0x00000800
#define PDB_CODE_CHECK_EXISTENCE			0x00001000
#define PDB_CODE_SAMPLING_TIME_OVER_RUN		0x00002000
#define PDB_CODE_START_SAMPLING				0x00004000
#define PDB_CODE_TEST_POLLING				0x00010000
#define PDB_CODE_ONE_TIME_POLLING			0x00020000
#define PDB_CODE_GET_ONE_RECORD				0x00040000
#define PDB_CODE_TIMEBAR_NOW_MODE			0x00080000
#define PDB_CODE_REBUILT_DB_FILE			0x00100000

// dialog style of Time Bar
#define EASY_DS_POPUP						0x00000000
#define EASY_DS_CHILD						0x00000001
#define EASY_DS_SHOW_DB_BUTTON				0x00000000
#define EASY_DS_HIDE_DB_BUTTON				0x00000002
#define EASY_DS_SHOW_DIALOG					0x00000000
#define EASY_DS_HIDE_DIALOG					0x00000004

#define PDB_PollingStatus_Stop				0
#define PDB_PollingStatus_Wait				1
#define PDB_PollingStatus_NowSampling		2
#define PDB_PollingStatus_Closed			3
#define PDB_PollingStatus_Cancel			4

// Time Bar Status
#define	EASY_TB_STATUS_NOW					0	// real time 
#define	EASY_TB_STATUS_PAST					1	// past time mode
#define	EASY_TB_STATUS_INDEX				2	// past index mode
#define	EASY_TB_STATUS_LAST_READ			3	// last read 

// Time Basr Write Mode
#define	EASY_TB_WRITE_SKIP					0	// Writing is always finished OK ( default)
#define	EASY_TB_WRITE_ERROR					1	// Writing is always finished ERROR ( ERROR code = 9419 )
#define	EASY_TB_WRITE_DATA_BASE				2	// Data Base Update
#define EASY_TB_WRITE_GP					3	// Writing GP on PLC

typedef LPVOID HEASYTIME;

DWORD WINAPI EasyCreateTimeBar(HEASYTIME* ohTimeBar, DWORD* odwErrorCode, LPCSTR sDataBaseFileName, HWND hParentWnd, DWORD dwDlgStyle,DWORD dwWM_USER = 0); // It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasyShowTimeBar(HEASYTIME hTimeBar, DWORD dwCmdShow); // It isn't being supported in Pro-Server EX Ver. 1
HWND  WINAPI EasyGetTimeBarWindowHandle(HEASYTIME hTimeBar); // It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasyLinkTimeBar(HEASYTIME hTimeBar);// It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasyLinkTimeBarM(HANDLE hProServer, HEASYTIME hTimeBar); // It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasyUnlinkTimeBar(HEASYTIME hTimeBar); // It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasyUnlinkTimeBarM(HANDLE hProServer, HEASYTIME hTimeBar); // It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasyDestroyTimeBar(HEASYTIME hTimeBar); // It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasyGetTimeBarRange(HEASYTIME hTimeBar, DWORD* odwStartTime, DWORD* odwEndTime, DWORD* odwLeftTime, DWORD* odwRightTime);// It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasyGetTimeBarRangeVariant(HEASYTIME hTimeBar, LPVARIANT ovStartTime, LPVARIANT ovEndTime, LPVARIANT ovLeftTime, LPVARIANT ovRightTime); // It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasyBackwardConfirmation(HEASYTIME hTimeBar, DWORD dwAutoModeFlag, DWORD dwTime); // It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasyLockTimeBar(HEASYTIME hTimeBar); // It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasyUnlockTimeBar(HEASYTIME hTimeBar); // It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasyDispDataBaseStatusDialog(); // It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasyChangeTimeBarDataBase(HEASYTIME hTimeBar, LPCSTR sDataBaseFileName); // It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasyTimeBarTestPolling(HEASYTIME hTimeBar); // It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasyTimeBarOneTimePolling(HEASYTIME hTimeBar); // It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasyTimeBarPollingStart(HEASYTIME hTimeBar);// It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasyTimeBarPollingStop(HEASYTIME hTimeBar);// It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasyGetTimeBarPollingStatus(HEASYTIME hTimeBar, DWORD* odwDBStatus);// It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasyGetDatabaseName(HEASYTIME hTimeBar, LPSTR oDatabaseName);// It isn't being supported in Pro-Server EX Ver. 1

DWORD WINAPI EasySetTimeBarPositionNow(HEASYTIME hTimeBar);// It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasySetTimeBarPositionTime(HEASYTIME hTimeBar,DWORD dwPosTime);// It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasySetTimeBarPositionTimeVariant(HEASYTIME hTimeBar,VARIANT vPosTime);// It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasySetTimeBarPositionIndex(HEASYTIME hTimeBar,DWORD dwFileNo,DWORD dwIndex);// It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasySetTimeBarPositionLastRead(HEASYTIME hTimeBar);// It isn't being supported in Pro-Server EX Ver. 1

DWORD WINAPI EasyGetTimeBarPositionStatus(HEASYTIME hTimeBar, DWORD* odwStatus);// It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasyGetTimeBarPositionTime(HEASYTIME hTimeBar,DWORD* odwPosTime);// It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasyGetTimeBarPositionTimeVariant(HEASYTIME hTimeBar,LPVARIANT ovPosTime);// It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasyGetTimeBarPositionIndex(HEASYTIME hTimeBar,DWORD* odwFileNo,DWORD* odwIndex);// It isn't being supported in Pro-Server EX Ver. 1

DWORD WINAPI EasyGetTimeBarMaxFileNo(HEASYTIME hTimeBar, DWORD* odwMaxFileNo);// It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasyGetTimeBarMaxIndex(HEASYTIME hTimeBar, DWORD dwFileNo,DWORD* odwIndex);// It isn't being supported in Pro-Server EX Ver. 1

DWORD WINAPI EasySetTimeBarWriteMode(DWORD dwWriteMode);// It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasySetTimeBarWriteModeM(HANDLE hProServer, DWORD dwWriteMode);// It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasyGetTimeBarWriteMode(DWORD* odwWriteMode);// It isn't being supported in Pro-Server EX Ver. 1
DWORD WINAPI EasyGetTimeBarWriteModeM(HANDLE hProServer, DWORD* odwWriteMode);// It isn't being supported in Pro-Server EX Ver. 1

// CSV file transfer API's
struct stEasyDirInfo {
	BYTE bFileName[8+1];		// FileName
	BYTE bExt[3+1];				// Extension
	BYTE bDummy[3];				// Dummy
	DWORD dwFileSize;			// FileSize
	BYTE bFileTimeStamp[8+1];	// TimeStamp
	BYTE bDummy2[3];			// Dummy2
} ;


INT WINAPI EasyGetListInCard(LPCSTR sNodeName, LPCSTR sDirectory, INT* oiCount, LPCSTR sSaveFileName);
INT WINAPI EasyFileReadCard(LPCSTR sNodeName, LPCSTR pReadFileType, WORD wReadFileNo, LPCSTR sWriteFileName, DWORD* odwFileSize);
INT WINAPI EasyFileWriteCard(LPCSTR sNodeName, LPCSTR pReadFileName, LPCSTR sWriteFileType, WORD wWriteFileNo);
INT WINAPI EasyGetCfFreeSpace(LPCSTR sNodeName, INT* oiUnallocated);

DWORD WINAPI EasyGetGPTime(LPCSTR sNodeName, DWORD* odwTime);
DWORD WINAPI EasyGetGPTimeVariant(LPCSTR sNodeName, LPVARIANT ovTime);
DWORD WINAPI EasyGetGPTimeString(LPCSTR sNodeName, LPCSTR sFormat, LPSTR osTime);
DWORD WINAPI EasyGetGPTimeStringVariant(LPCSTR sNodeName, LPCSTR sFormat, LPVARIANT ovTime);


/* --------------------------------------------------------------------------------
	Add function for Pro-Server Version 4.5
 ------------------------------------------------------------------------------- */
INT WINAPI EasyFileDeleteCard(LPCSTR sNodeName, LPCSTR pDeleteFileType, WORD wDeleteFileNo) ;
INT WINAPI EasyGetListInCfCard(LPCSTR sNodeName, LPCSTR sDirectory, INT* oiCount, LPCSTR sSaveFileName) ;
INT WINAPI EasyFileDeleteInCfCard(LPCSTR sNodeName, LPCSTR sFolderName, LPCSTR sFileName) ;
INT WINAPI EasyFileReadInCfCard(LPCSTR sNodeName, LPCSTR sFolderName, LPCSTR sFileName, LPCSTR pWriteFileName, DWORD* odwFileSize) ;
INT WINAPI EasyFileWriteInCfCard(LPCSTR sNodeName, LPCSTR pReadFileName, LPCSTR sFolderName, LPCSTR sFileName) ;
INT WINAPI EasyFileRenameInCfCard(LPCSTR sNodeName, LPCSTR sFolderName, LPCSTR sFileName, LPCSTR sFileRename) ;




/* --------------------------------------------------------------------------------
	Add function for Pro-Server EX Version 1.0
 ------------------------------------------------------------------------------- */
// Pro-Server Control's API
INT WINAPI EasyTermServer();
INT WINAPI EasyNotifyFromServerEnd(HWND hReceivedWnd,UINT uMessage,WPARAM WParam = 0 , LPARAM LParam = 0 );
INT WINAPI EasyNotifyFromServerEndM(HANDLE hProServer,HWND hReceivedWnd,UINT uMessage,WPARAM WParam = 0 , LPARAM LParam = 0 );

//	API that an error message is acquired from the error code and that it is expanded
BOOL WINAPI EasyLoadErrorMessageEx(INT iErrorCode,LPSTR osErrorMessage );
BOOL WINAPI EasyLoadErrorMessageExM(HANDLE hProServer,INT iErrorCode,LPSTR osErrorMessage );
BOOL WINAPI EasyLoadErrorMessageW(INT iErrorCode,LPWSTR owsErrorMessage );
BOOL WINAPI EasyLoadErrorMessageExW(INT iErrorCode,LPWSTR owsErrorMessage );
BOOL WINAPI EasyLoadErrorMessageExWM(HANDLE hProServer,INT iErrorCode,LPWSTR owsErrorMessage );


//  Queuing Access Control's API
INT WINAPI BeginQueuingRead();
INT WINAPI BeginQueuingWrite();
INT WINAPI ExecuteQueuingAccess();
INT WINAPI CancelQueuingAccess();
INT	WINAPI IsQueuingAccessSucceeded(INT iIndex);


INT WINAPI BeginQueuingReadM(HANDLE hProServer);
INT WINAPI BeginQueuingWriteM(HANDLE hProServer);
INT WINAPI ExecuteQueuingAccessM(HANDLE hProServer);
INT WINAPI CancelQueuingAccessM(HANDLE hProServer);
INT	WINAPI IsQueuingAccessSucceededM(HANDLE hProServer,INT iIndex);


// Cache Control's API
INT WINAPI PS_CreateCache(LPCSTR sCacheName, DWORD dwPollingTime);
INT WINAPI PS_EntryCacheRecord(LPCSTR sCacheName, LPCSTR sNodeName, LPCSTR sDevice, WORD wAppKind, WORD wCount);
INT WINAPI PS_StartCache(LPCSTR sCacheName);
INT WINAPI PS_StopCache(LPCSTR sCacheName);
INT WINAPI PS_DestroyCache(LPCSTR sCacheName);
INT WINAPI PS_SetNotifyFromCache(LPCSTR sCacheName, HWND hWnd, UINT message, WPARAM WParam, LPARAM LParam, HANDLE* ohCacheNotifyID);
INT WINAPI PS_AcceptNextNotifyFromCache(HANDLE hCacheNotifyID);
INT WINAPI PS_KillNotifyFromCache(HANDLE hCacheNotifyID);
INT WINAPI PS_GetUpdateCounter(LPCSTR sCacheName, DWORD* odwCount);
INT WINAPI PS_GetCacheStatus(LPCSTR sCacheName);

INT WINAPI PS_CreateCacheM(HANDLE hProServer, LPCSTR sCacheName, DWORD dwPollingTime);
INT WINAPI PS_EntryCacheRecordM(HANDLE hProServer, LPCSTR sCacheName, LPCSTR sNodeName, LPCSTR sDevice, WORD wAppKind, WORD wCount);
INT WINAPI PS_StartCacheM(HANDLE hProServer, LPCSTR sCacheName);
INT WINAPI PS_StopCacheM(HANDLE hProServer, LPCSTR sCacheName);
INT WINAPI PS_DestroyCacheM(HANDLE hProServer, LPCSTR sCacheName);
INT WINAPI PS_SetNotifyFromCacheM(HANDLE hProServer, LPCSTR sCacheName, HWND hWnd, UINT message, WPARAM WParam, LPARAM LParam, HANDLE* ohCacheNotifyID);
INT WINAPI PS_AcceptNextNotifyFromCacheM(HANDLE hProServer, HANDLE hCacheNotifyID);
INT WINAPI PS_KillNotifyFromCacheM(HANDLE hProServer, HANDLE hCacheNotifyID);
INT WINAPI PS_GetUpdateCounterM(HANDLE hProServer, LPCSTR sCacheName, DWORD* odwCount);
INT WINAPI PS_GetCacheStatusM(HANDLE hProServer, LPCSTR sCacheName);


// Symbol Information's API
struct SymbolInformation
{
	WORD	m_wAppKind ;			/* Application data type (1 to 12, 0x8000 ) */
	WORD	m_wDataCount ;			/* Count of data */
	DWORD	m_dwSizeOf ;			/* The byte size of the buffer which is necessary to access it */
	char    m_sSymbolName[64+1] ;	/* Symbol name */
	char	m_bDummy1[3] ;			/* Dummy[0],Dummy[1] reserved, Dummy[2] extend infomation */
	char	m_sDeviceAddress[256+1] ;/* Device address */
	char	m_bDummy2[3] ;
};


INT WINAPI SizeOfSymbol(LPCSTR sNodeName,LPCSTR sSymbolName,INT* oiByteSize);
INT WINAPI GetCountOfSymbolMember(LPCSTR sNodeName,LPCSTR sSymbolName,INT* oiCountOfMember);
INT WINAPI GetSymbolInformation(LPCSTR sNodeName,LPCSTR sSymbolName,INT iMaxCountOfSymbolMember,LPSTR osSymbolSheetName,SymbolInformation* oSymbolInformation,INT* oiGotCountOfSymbolMember);

// Group Access API
INT WINAPI ReadSymbol(LPCSTR sNodeName,LPCSTR sSymbolName,LPVOID oReadBufferData);
INT WINAPI ReadSymbolD(LPCSTR sNodeName,LPCSTR sSymbolName,LPVOID oReadBufferData);
INT WINAPI ReadSymbolVariant(LPCSTR sNodeName,LPCSTR sSymbolName,LPVARIANT pData);
INT WINAPI ReadSymbolVariantD(LPCSTR sNodeName,LPCSTR sSymbolName,LPVARIANT pData);


INT WINAPI ReadSymbolM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sSymbolName,LPVOID oReadBufferData);
INT WINAPI ReadSymbolDM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sSymbolName,LPVOID oReadBufferData);
INT WINAPI ReadSymbolVariantM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sSymbolName,LPVARIANT pData);
INT WINAPI ReadSymbolVariantDM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sSymbolName,LPVARIANT pData);

INT WINAPI WriteSymbol(LPCSTR sNodeName,LPCSTR sSymbolName,LPVOID pWriteBufferData);
INT WINAPI WriteSymbolD(LPCSTR sNodeName,LPCSTR sSymbolName,LPVOID pWriteBufferData);
INT WINAPI WriteSymbolVariant(LPCSTR sNodeName,LPCSTR sSymbolName,LPVARIANT pData);
INT WINAPI WriteSymbolVariantD(LPCSTR sNodeName,LPCSTR sSymbolName,LPVARIANT pData);

INT WINAPI WriteSymbolM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sSymbolName,LPVOID pWriteBufferData);
INT WINAPI WriteSymbolDM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sSymbolName,LPVOID pWriteBufferData);
INT WINAPI WriteSymbolVariantM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sSymbolName,LPVARIANT pData);
INT WINAPI WriteSymbolVariantDM(HANDLE hProServer,LPCSTR sNodeName,LPCSTR sSymbolName,LPVARIANT pData);

//  CF-CARD access control API
INT WINAPI EasyFileSetPassiveMode(INT iPassive) ;

#endif // PROEASY_H
