; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!
;
;  [Code] section by Martin Scharpf, 2005
;  Copyright (C) 2002-2005 Ultr@VNC Team Members. All Rights Reserved.
;
;  This program is free software; you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation; either version 2 of the License, or
;  (at your option) any later version.
;
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
;
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
;  USA.
;
;  If the source code for the program is not available from the place from
;  which you received this file, check
;  http://ultravnc.sourceforge.net/


[Setup]
AppName=UltraVNC
AppVersion=1.1.0.2
AppVerName=UltraVNC v1.0.2
AppPublisher=UltraVNC
AppPublisherURL=http://ultravnc.sourceforge.net/
AppSupportURL=http://forum.ultravnc.net/
AppUpdatesURL=http://ultravnc.sourceforge.net/
DefaultDirName={pf}\UltraVNC
DefaultGroupName=UltraVNC
LicenseFile=src\Licence.txt

WindowVisible=false
DisableStartupPrompt=true
ChangesAssociations=true
MinVersion=4.0.950,4.0.1381
AppCopyright=UltraVNC Team
PrivilegesRequired=poweruser
;UninstallRestartComputer=true
DirExistsWarning=no
OutputBaseFilename=UltraVNC-1.0-Setup
BackColorDirection=lefttoright
ShowLanguageDialog=yes
LanguageDetectionMethod=uilanguage
OutputDir=.
SolidCompression=true
AppID={{A8AD990E-355A-4413-8647-A9B168978423}
DisableDirPage=false
AllowUNCPath=false
Compression=zip/9
InfoAfterFile=src\Whatsnew.txt
InfoBeforeFile=src\Readme.txt

; uncomment the following line if you want your installation to run on NT 3.51 too.
; MinVersion=4,3.51
;WizardImageStretch=no

SetupIconFile=UltraVNC.ico
WizardImageFile=UltraVNC-splash.bmp
WizardSmallImageFile=UltraVNC-logo.bmp

[Languages]
Name: en; MessagesFile: compiler:Default.isl
Name: de; MessagesFile: compiler:Languages\german.isl
Name: fr; MessagesFile: compiler:Languages\french.isl

[Types]
Name: full; Description: {cm:FullInstall}
Name: serv; Description: {cm:ServerOnly}
Name: view; Description: {cm:ViewerOnly}
Name: custom; Description: {cm:CustomInstall}; Flags: iscustom

[Components]
Name: server; Description: UltraVNC Server; Types: full serv; Flags: disablenouninstallwarning
Name: server/driver; Description: UltraVNC Mirror Driver; Types: full serv; Flags: disablenouninstallwarning; MinVersion: 0,5.0.2195
Name: viewer; Description: UltraVNC Viewer; Types: full view; Flags: disablenouninstallwarning
Name: dsm; Description: DSM Encryption Plugin; Types: full view serv; Flags: disablenouninstallwarning
Name: repeater; Description: UltraVNC Repeater; Types: full; Flags: disablenouninstallwarning


[Tasks]
Name: installservice; Description: {cm:InstallService,UltraVNC Server}; GroupDescription: {cm:ServerConfig}; Components: server; MinVersion: 0,1; Check: isTaskChecked('installservice')
Name: installservice; Description: {cm:InstallService,UltraVNC Server}; GroupDescription: {cm:ServerConfig}; Components: server; MinVersion: 0,1; Flags: unchecked; Check: not(isTaskChecked('installservice'))
Name: startservice; Description: {cm:StartService,UltraVNC}; GroupDescription: {cm:ServerConfig}; Components: server; MinVersion: 0,1; Check: isTaskChecked('startservice')
Name: startservice; Description: {cm:StartService,UltraVNC}; GroupDescription: {cm:ServerConfig}; Components: server; MinVersion: 0,1; Flags: unchecked; Check: not(isTaskChecked('startservice'))
Name: acl; Description: {cm:ConfigMslogon2}; GroupDescription: {cm:ServerConfig}; Components: server; MinVersion: 0,1; Check: isTaskChecked('acl')
Name: acl; Description: {cm:ConfigMslogon2}; GroupDescription: {cm:ServerConfig}; Components: server; Flags: unchecked; MinVersion: 0,1; Check: not(isTaskChecked('acl'))
Name: properties; Description: {cm:ConfigAdminProps}; GroupDescription: {cm:ServerConfig}; Components: server; Check: isTaskChecked('properties')
Name: properties; Description: {cm:ConfigAdminProps}; GroupDescription: {cm:ServerConfig}; Components: server; Flags: unchecked; Check: not(isTaskChecked('properties'))
Name: cleanreg; Description: {cm:CleanRegKeys}; GroupDescription: {cm:ServerConfig}; Components: server; Check: isTaskChecked('properties')
Name: cleanreg; Description: {cm:CleanRegKeys}; GroupDescription: {cm:ServerConfig}; Components: server; Flags: unchecked; Check: not(isTaskChecked('properties'))
Name: desktopicon; Description: {cm:CreateDesktopIcons,UltraVNC}; GroupDescription: {cm:AddConfig}; Components: viewer server repeater; Check: isTaskChecked('desktopicon')
Name: desktopicon; Description: {cm:CreateDesktopIcons,UltraVNC}; GroupDescription: {cm:AddConfig}; Components: viewer server repeater; Flags: unchecked; Check: not(isTaskChecked('desktopicon'))
Name: associate; Description: {cm:AssocFileExtension,UltraVNC Viewer,.vnc}; GroupDescription: {cm:AddConfig}; Components: viewer; Check: isTaskChecked('associate')
Name: associate; Description: {cm:AssocFileExtension,UltraVNC Viewer,.vnc}; GroupDescription: {cm:AddConfig}; Components: viewer; Flags: unchecked; Check: not(isTaskChecked('associate'))

[Files]
; component independent files
Source: src\Licence.txt; DestDir: {app}
Source: src\Whatsnew.txt; DestDir: {app}
Source: src\Readme.txt; DestDir: {app}
Source: doc\*; DestDir: {app}\doc; Flags: recursesubdirs createallsubdirs

; server files
; winvnc.exe needs to be first here because it triggers stopping WinVNC service/app.
Source: src\winvnc.exe; DestDir: {app}; Components: server; BeforeInstall: StopVNC; Flags: restartreplace
Source: src\natconnect_server.exe; DestDir: {app}; Components: server;
Source: src\vnchooks.dll; DestDir: {app}; Components: server; Flags: restartreplace
Source: src\VNCHooks_Settings.reg; DestDir: {app}; Components: server; Flags: 
Source: src\vncddihk.dll; DestDir: {app}; Components: server; MinVersion: 4.0.1111,0; Flags: restartreplace
Source: src\16bithlp.exe; DestDir: {app}; MinVersion: 4.0.1111,0; Components: server; Flags: restartreplace
Source: src\winvnc1p.exe; DestDir: {app}; Components: server; Flags: restartreplace
Source: src\logmessages.dll; DestDir: {app}; Components: server; Flags: restartreplace
Source: src\UnZip32.dll; DestDir: {app}; Components: viewer server; Flags: restartreplace
Source: src\Zip32.dll; DestDir: {app}; Components: viewer server; Flags: restartreplace

; mslogon I files
Source: src\logging.dll; DestDir: {app}; Components: server; Flags: restartreplace
Source: src\authadmin.dll; DestDir: {app}; Components: server; Flags: restartreplace
Source: src\workgrpdomnt4.dll; DestDir: {app}; Components: server; Flags: restartreplace
Source: src\ldapauth.dll; DestDir: {app}; Components: server; MinVersion: 0,5.0; Flags: restartreplace
Source: src\ldapauthnt4.dll; DestDir: {app}; Components: server; MinVersion: 0,4.0; OnlyBelowVersion: 0,5.0; Flags: restartreplace
Source: src\ldapauth9x.dll; DestDir: {app}; Components: server; MinVersion: 4.0,0; Flags: restartreplace
; mslogon II files
Source: src\authSSP.dll; DestDir: {app}; Components: server; MinVersion: 0,1; Flags: restartreplace
Source: src\MSLogonACL.exe; DestDir: {app}; Components: server; MinVersion: 0,1; Flags: restartreplace
; marscha: Added acl.txt with Administrators full access.
Source: src\acl.txt; DestDir: {tmp}; Components: server; Flags: deleteafterinstall; MinVersion: 0,1; Tasks: acl
; marscha: Added props.reg with no keys.
Source: src\props.reg; DestDir: {tmp}; Components: server; Flags: deleteafterinstall; Tasks: properties

; driver files are part of the server component
Source: src\driver\*; DestDir: {app}\driver\; Components: server/driver; MinVersion: 0,5.0

; viewer files
Source: src\vncviewer.exe; DestDir: {app}; Components: viewer
Source: src\natconnect_viewer.exe; DestDir: {app}; Components: viewer
Source: src\translations\french.dll; DestDir: {app}\translation; Components: viewer
Source: src\translations\german.dll; DestDir: {app}\translation; Components: viewer
Source: src\translations\readme.txt; DestDir: {app}\translation; Components: viewer
Source: src\tabbed_vncviewer.exe; DestDir: {app}; Components: viewer
Source: src\tabbed_translations\french.dll; DestDir: {app}\tabbed_translations; Components: viewer
Source: src\tabbed_translations\german.dll; DestDir: {app}\tabbed_translations; Components: viewer
Source: src\tabbed_translations\readme.txt; DestDir: {app}\tabbed_translations; Components: viewer

Source: src\translations\french.dll; DestDir: {app}; Languages: fr; Components: viewer; DestName: vnclang.dll
Source: src\translations\german.dll; DestDir: {app}; Languages: de; Components: viewer; DestName: vnclang.dll
Source: src\tabbed_translations\french.dll; DestDir: {app}; Languages: fr; Components: viewer; DestName: vnclang_t.dll
Source: src\tabbed_translations\german.dll; DestDir: {app}; Languages: de; Components: viewer; DestName: vnclang_t.dll


; DSM Encryption plugin files
Source: src\plugin\*; DestDir: {app}\plugin\; Components: dsm
;Source: src\plugin\msrc4plugin.dsm; DestDir: {app}\; Components: dsm;

; repeater files
Source: src\repeater\repeater.exe; DestDir: {app}; Flags: ignoreversion; Components: Repeater
;custom icons
Source: src\icons\Connected 1.ico; DestDir: {app}\icons\; Components: server
Source: src\icons\Connected 2.ico; DestDir: {app}\icons\; Components: server
Source: src\icons\Connected 3.ico; DestDir: {app}\icons\; Components: server
Source: src\icons\Connected 4.ico; DestDir: {app}\icons\; Components: server
Source: src\icons\Connected 5.ico; DestDir: {app}\icons\; Components: server
Source: src\icons\Connected 6.ico; DestDir: {app}\icons\; Components: server
Source: src\icons\Readme.txt; DestDir: {app}\icons\; Components: server
Source: src\icons\Standby 1.ico; DestDir: {app}\icons\; Components: server
Source: src\icons\Standby 2.ico; DestDir: {app}\icons\; Components: server
Source: src\icons\Standby 3.ico; DestDir: {app}\icons\; Components: server
Source: src\icons\Standby 4.ico; DestDir: {app}\icons\; Components: server
Source: src\icons\Standby 5.ico; DestDir: {app}\icons\; Components: server
Source: src\icons\Standby 6.ico; DestDir: {app}\icons\; Components: server
Source: src\icons\Standby 7.ico; DestDir: {app}\icons\; Components: server

[Icons]
Name: {userdesktop}\UltraVNC Server; Filename: {app}\winvnc.exe; Components: server; IconIndex: 0; Tasks: desktopicon
Name: {userdesktop}\UltraVNC Server Nat connect; Filename: {app}\natconnect_server.exe; Components: server; IconIndex: 0; Tasks: desktopicon
Name: {userdesktop}\UltraVNC Viewer; Filename: {app}\vncviewer.exe; IconIndex: 0; Components: viewer; Tasks: desktopicon
Name: {userdesktop}\UltraVNC Viewer Nat connect; Filename: {app}\natconnect_viewer.exe; IconIndex: 0; Components: viewer; Tasks: desktopicon
Name: {userdesktop}\UltraVNC Viewer(tab); Filename: {app}\tabbed_vncviewer.exe; IconIndex: 0; Components: viewer; Tasks: desktopicon

Name: {group}\UltraVNC Viewer; FileName: {app}\vncviewer.exe; WorkingDir: {app}; IconIndex: 0; Components: viewer
Name: {group}\UltraVNC Viewer Nat connect; FileName: {app}\natconnect_viewer.exe; WorkingDir: {app}; IconIndex: 0; Components: viewer
Name: {group}\UltraVNC Viewer(tab); FileName: {app}\tabbed_vncviewer.exe; WorkingDir: {app}; IconIndex: 0; Components: viewer
Name: {group}\UltraVNC Server; FileName: {app}\WinVNC.exe; WorkingDir: {app}; Components: server; IconIndex: 0
Name: {group}\UltraVNC Server Nat connect; FileName: {app}\natconnect_server.exe; WorkingDir: {app}; Components: server; IconIndex: 0

Name: {group}\UltraVNC Viewer\Run UltraVNC Viewer (Listen Mode); FileName: {app}\vncviewer.exe; Parameters: -listen; WorkingDir: {app}; IconIndex: 0; Components: viewer
Name: {group}\UltraVNC Viewer\Show UltraVNC Viewer Help; FileName: {app}\vncviewer.exe; Parameters: -help; WorkingDir: {app}; IconIndex: 0; Components: viewer

Name: {group}\UltraVNC Server\Install WinVNC Service; FileName: {app}\WinVNC.exe; Parameters: -install; WorkingDir: {app}; Components: server
Name: {group}\UltraVNC Server\Install WinVNC Service silent; FileName: {app}\WinVNC.exe; Parameters: -sinstall; WorkingDir: {app}; Components: server
Name: {group}\UltraVNC Server\Remove WinVNC Service; FileName: {app}\WinVNC.exe; Parameters: -remove; WorkingDir: {app}; Components: server
Name: {group}\UltraVNC Server\Reinstall WinVNC Service (Silent); FileName: {app}\WinVNC.exe; Parameters: -reinstall; WorkingDir: {app}; Components: server
Name: {group}\UltraVNC Server\Run Service Helper; FileName: {app}\WinVNC.exe; Parameters: -servicehelper; WorkingDir: {app}; Components: server
Name: {group}\UltraVNC Server\Show WinVNC Server Help; FileName: {app}\WinVNC.exe; Parameters: -help; WorkingDir: {app}; Components: server
Name: {group}\UltraVNC Server\Show Default Settings; FileName: {app}\WinVNC.exe; Parameters: -defaultsettings; WorkingDir: {app}; Components: server
Name: {group}\UltraVNC Server\Show User Settings; FileName: {app}\WinVNC.exe; Parameters: -settings; WorkingDir: {app}; Components: server
Name: {group}\UltraVNC Server\Show About Box; FileName: {app}\WinVNC.exe; Parameters: -about; WorkingDir: {app}; Components: server
Name: {group}\UltraVNC Server\Install Default Registry Settings; FileName: {app}\VNCHooks_Settings.reg; WorkingDir: {app}; Components: server

Name: {group}\Doc\Documentation; FileName: {app}\doc\index.html; WorkingDir: {app}
Name: {group}\Doc\Readme; FileName: {app}\Readme.txt; WorkingDir: {app}
Name: {group}\Doc\Whatsnew; FileName: {app}\Whatsnew.txt; WorkingDir: {app}
Name: {group}\Doc\Licence; FileName: {app}\Licence.txt; WorkingDir: {app}

Name: {group}\UltraVNC Repeater\Run; FileName: {app}\repeater.exe; WorkingDir: {app}; Components: Repeater
Name: {group}\UltraVNC Repeater\Install Repeater Service; FileName: {app}\repeater.exe; Parameters: -install; WorkingDir: {app}; Components: Repeater
Name: {group}\UltraVNC Repeater\Remove Repeater Service; FileName: {app}\repeater.exe; Parameters: -uninstall; WorkingDir: {app}; Components: Repeater

Name: {group}\UltraVNC Driver\Install Driver; FileName: {app}\driver\setupdrv.exe; Parameters: install; WorkingDir: {app}\driver; Components: server; MinVersion: 0,5.0
Name: {group}\UltraVNC Driver\Remove Driver; FileName: {app}\driver\setupdrv.exe; Parameters: uninstall; WorkingDir: {app}\driver; Components: server; MinVersion: 0,5.0

[Registry]
Root: HKCR; Subkey: .vnc; ValueType: string; ValueName: ; ValueData: VncViewer.Config; Flags: uninsdeletevalue; Tasks: associate
Root: HKCR; Subkey: VncViewer.Config; ValueType: string; ValueName: ; ValueData: VNCviewer Config File; Flags: uninsdeletekey; Tasks: associate
Root: HKCR; Subkey: VncViewer.Config\DefaultIcon; ValueType: string; ValueName: ; ValueData: {app}\vncviewer.exe,0; Tasks: associate
Root: HKCR; Subkey: VncViewer.Config\shell\open\command; ValueType: string; ValueName: ; ValueData: """{app}\vncviewer.exe"" -config ""%1"""; Tasks: associate
; marscha: Added cleaning of old VNC reg keys
Root: HKLM; Subkey: Software\ORL; Flags: deletekey; Tasks: cleanreg
Root: HKLM; Subkey: Software\UltraVNC; Flags: deletekey; Tasks: cleanreg
Root: HKCU; Subkey: Software\ORL; Flags: deletekey; Tasks: cleanreg
Root: HKU; Subkey: .Default\Software\ORL; Flags: deletekey; Tasks: cleanreg
; marscha: Added reg keys for MS-Logon II activation
Root: HKLM; Subkey: Software\ORL; Flags: uninsdeletekeyifempty; Tasks: acl
Root: HKLM; Subkey: Software\ORL\WinVNC3; Flags: uninsdeletekeyifempty; Tasks: acl
Root: HKLM; Subkey: Software\ORL\WinVNC3; Flags: uninsdeletekeyifempty; ValueType: dword; ValueName: MSLogonRequired; ValueData: 1; Tasks: acl
Root: HKLM; Subkey: Software\ORL\WinVNC3; Flags: uninsdeletekeyifempty; ValueType: dword; ValueName: NewMSLogon; ValueData: 1; Tasks: acl
; making driver activate from non admin user (application)
Root: HKLM; Subkey: SYSTEM\CurrentControlSet\Hardware Profiles\Current\System\CurrentControlSet\Services\vncdrv\DEVICE0; Permissions: authusers-full; ValueType: dword; ValueName: Attach.ToDesktop; ValueData: 0; Flags: uninsdeletekey; Components: server


[Run]
Filename: regedit.exe; WorkingDir: {src}; Parameters: "/s ""{code:PropertiesFile}"""; Flags: runhidden; Components: server; Tasks: acl; StatusMsg: {cm:Adding,Admin Properties}
Filename: {app}\MSLogonACL.exe; WorkingDir: {src}; Parameters: "/i /o ""{code:AclFile}"""; Flags: runhidden; Components: server; Tasks: acl; StatusMsg: {cm:Adding,MS-Logon ACL}

Filename: {app}\driver\setupdrv.exe; Parameters: installs; Flags: runhidden; Components: server/driver; StatusMsg: {cm:Installing, UltraVNC Mirror Driver}; BeforeInstall: StopVNC; MinVersion: 0,5.0.2195
Filename: {app}\WinVNC.exe; Parameters: -reinstall; Flags: runhidden; Components: server; Tasks: installservice; StatusMsg: {cm:Registering, UltraVNC}
Filename: net; Parameters: start WinVNC; Flags: runhidden; Components: server; Tasks: startservice; StatusMsg: {cm:Starting,UltraVNC}
Filename: {app}\WinVNC.exe; Parameters: -servicehelper; Flags: runhidden; Components: server; Tasks: startservice; StatusMsg: {cm:Starting,UltraVNC}

[UninstallRun]
Filename: net; Parameters: stop WinVNC; Flags: runhidden; RunOnceId: StopVncService; Components: server; Tasks: startservice; StatusMsg: {cm:Stopping, UltraVNC}
Filename: {app}\WinVNC.exe; Parameters: -remove; Flags: runhidden; RunOnceId: RemoveVncService; Components: server; Tasks: installservice; StatusMsg: {cm:Removing,UltraVNC}
Filename: {app}\driver\setupdrv.exe; Parameters: uninstalls; Flags: runhidden; RunOnceId: UninstallDriver; Components: server/driver; StatusMsg: {cm:Uninstalling, UltraVNC Mirror Driver}; MinVersion: 0,5.0.2195

[Dirs]
Name: {app}\icons

[CustomMessages]
en.CreateDesktopIcons=Create %1 &desktop icons
de.CreateDesktopIcons=%1 &Desktop-Symbole anlegen
fr.CreateDesktopIcons=Crer les icnes d'%1 sur le &bureau

en.CleanRegKeys=Clean old VNC registry keys
de.CleanRegKeys=Alten VNC Registrierungsschlssel lschen
fr.CleanRegKeys=Suppression des anciennes cls de VNC de la base de registre

en.ConfigAdminProps=Configure Admin Properties
de.ConfigAdminProps=Admin Properties konfigurieren
fr.ConfigAdminProps=Configuration des proprits de l'admin

en.ConfigMslogon2=Configure &MS-Logon II
de.ConfigMslogon2=&MS-Logon II konfigurieren
fr.ConfigMslogon2=Configuration de &MS-Logon II

en.StartService=&Start or restart %1 service
de.StartService=%1 Dienst (erneut) &starten
fr.StartService=&Dmarrer ou redmarrer %1 le service

en.InstallService=&Register %1 as a system service
de.InstallService=%1 als System-Dienst &registrieren
fr.InstallService=&Installation et enregistrement d'%1 comme service systme

en.Adding=Adding %1...
de.Adding=%1 hinzufgen...
fr.Adding=Ajouter %1...

en.Registering=Registering %1 service...
de.Registering=%1 Dienst registrieren...
fr.Registering=Enregistrement service %1...

en.Starting=Starting %1 service...
de.Starting=%1 Dienst starten...
fr.Starting=Dmarrage du service %1...

en.Stopping=Stopping %1 service...
de.Stopping=%1 Dienst stoppen...
fr.Stopping=Arrt du service %1...

en.Removing=Removing %1 service...
de.Removing=%1 Dienst entfernen...
fr.Removing=Suppression du service %1...

en.Installing=Installing %1...
de.Installing=%1 installieren...
fr.Installing=Installer %1...

en.Uninstalling=Uninstalling %1...
de.Uninstalling=%1 deinstallieren...
fr.Uninstalling=Dsinstaller %1...

en.ServerConfig=Server configuration:
de.ServerConfig=Server Konfiguration:
fr.ServerConfig=Configuration serveur:

en.AddConfig=Additional configuration:
de.AddConfig=Zustzliche Konfiguration:
fr.AddConfig=Configuration complmentaire:

en.AclCaption=Select ACL File for MS-Logon II
de.AclCaption=ACL Datei fr MS-Logon II whlen
fr.AclCaption=Slectionner le fichier ACL pour MS-Logon II

en.AclSubCaption=Where is the file with MS-Logon ACL located?
de.AclSubCaption=Wo befindet sich die MS-Logon ACL Datei?
fr.AclSubCaption=O se trouve le fichier contenant les donnes MS-Logon ACL?

en.AclDescription=Setup will use the following file to configure MS-Logon ACL.
de.AclDescription=Setup wird die folgende Datei zur MS-Logon ACL Konfiguration nutzen.
fr.AclDescription=L'installation va utiliser le fichier suivant pour configurer MS-Logon ACL.

en.PropsCaption=Select Admin Properties for UltraVNC configuration
de.PropsCaption=Admin Properties Konfiguration fr UltraVNC whlen
fr.PropsCaption=Slectionner Proprit Admin pour la configuration de UltraVNC

en.PropsSubCaption=Where is the file with registry settings located?
de.PropsSubCaption=Wo befindet sich die Datei mit den Registrierungs-Eintrgen?
fr.PropsSubCaption=O se trouve le fichier contenant les paramtres de la base de registre?

en.PropsDescription=Setup will use the following file to configure Admin Properties.
de.PropsDescription=Setup wird die folgende Datei zur Admin Properties Konfiguration nutzen.
fr.PropsDescription=L'installation va utiliser le fichier suivant pour configurer les proprit Admin

en.SelectFileBrowseLabel=To continue, click Next. If you would like to select a different file, click Browse.
de.SelectFileBrowseLabel=Klicken Sie auf "Weiter", um fortzufahren. Klicken Sie auf "Durchsuchen", falls Sie eine andere Datei auswhlen mchten.
fr.SelectFileBrowseLabel=Pour continuer, appuyez sur Suivant. Si vous souhaitez choisir un fichier diffrent, appuyez sur Parcourir.

en.AllFiles=All files
de.AllFiles=Alle Dateien
fr.AllFiles=Touts les fichiers

en.RegistryFiles=Registry files
de.RegistryFiles=Registrierungs-Dateien
fr.RegistryFiles=Fichiers de la base de registre

en.FullInstall=Full installation
de.FullInstall=Vollstndige Installation
fr.FullInstall=Installation complte

en.CustomInstall=Custom installation
de.CustomInstall=Benutzerdefinierte Installation
fr.CustomInstall=Installation personnalise

en.ServerOnly=Server Only
de.ServerOnly=Nur Server
fr.ServerOnly=Seulement serveur

en.ViewerOnly=Viewer Only
de.ViewerOnly=Nur Viewer
fr.ViewerOnly=Seulement visionner

[Code]
var
  AclFilePage: TInputFileWizardPage;
  PropsFilePage: TInputFileWizardPage;
  AclFileName: String;
  PropsFileName: String;
  FinishedInstall: Boolean;
  SelectedTasks: String;

function InitializeSetup(): Boolean;
var
  InfFile: String;
begin
  InfFile := ExpandFileName(ExpandConstant('{param:loadinf|''}'));
  Log('InitializeSetup: InfFile is ' + InfFile);
  if FileExists(InfFile) then
  begin
    AclFileName   := GetIniString('Setup', 'AclFile', '', InfFile);
    PropsFileName := GetIniString('Setup', 'PropertiesFile', '', InfFile);
    SelectedTasks := Lowercase(GetIniString('Setup', 'Tasks', '?', InfFile));
  end;
  Result := True;
end;

procedure DeinitializeSetup();
var
  InfFile: String;
begin
  if FinishedInstall then
  begin
    //InfFile := ExpandFileName(ExpandConstant('{src}') + '/' + ExpandConstant('{param:saveinf|''}'));
    InfFile := ExpandFileName(ExpandConstant('{param:saveinf|''}'));
    Log('DeinitializeSetup: InfFile is ' + InfFile);
      SetIniString('Setup', 'Tasks', WizardSelectedTasks(False), InfFile);
      if isTaskSelected('acl') then
        SetIniString('Setup', 'AclFile', ExtractRelativePath(ExpandConstant('{src}'), AclFileName), InfFile);
      if isTaskSelected('properties') then
        SetIniString('Setup', 'PropertiesFile', ExtractRelativePath(ExpandConstant('{src}'), PropsFileName), InfFile);
  end;
end;

procedure CurStepChanged(CurStep: TSetupStep);
begin
  if CurStep = ssPostInstall then
    FinishedInstall := True;
end;

procedure InitializeWizard;
var
  InfFile: String;
begin
  InfFile := ExpandFileName(ExpandConstant('{param:loadinf|''}'));
  Log('InitializeWizard: InfFile is ' + InfFile);
  // Create the pages
  AclFilePage := CreateInputFilePage(wpSelectTasks,
    ExpandConstant('{cm:AclCaption}'),
    ExpandConstant('{cm:AclSubCaption}'),
    ExpandConstant('{cm:AclDescription}'));

  AclFilePage.Add(ExpandConstant('{cm:SelectFileBrowseLabel}'), // caption
    ExpandConstant('{cm:AllFiles}') + '|*.*',       // filter
    '.txt');                                        // default extension

  PropsFilePage := CreateInputFilePage(AclFilePage.ID,
    ExpandConstant('{cm:PropsCaption}'),
    ExpandConstant('{cm:PropsSubCaption}'),
    ExpandConstant('{cm:PropsDescription}'));

  PropsFilePage.Add(ExpandConstant('{cm:SelectFileBrowseLabel}'), // caption
    ExpandConstant('{cm:RegistryFiles}') + '|*.reg|'
    + ExpandConstant('{cm:AllFiles}') + '|*.*',                  // filter
    '*.reg');                                              // default extension

  if (FileExists(InfFile) and IniKeyExists('Setup', 'AclFile', InfFile)) then
    AclFilePage.Values[0] := ExpandFileName(GetIniString('Setup', 'AclFile', '', InfFile))
  else
  begin
    AclFilePage.Values[0] := GetPreviousData('AclFileName', ExpandConstant('{tmp}\acl.txt'));
    AclFileName := AclFilePage.Values[0];
  end;
  if FileExists(InfFile) and IniKeyExists('Setup', 'PropertiesFile', InfFile) then
    PropsFilePage.Values[0] := ExpandFileName(GetIniString('Setup', 'PropertiesFile', '', InfFile))
  else
  begin
    PropsFilePage.Values[0] := GetPreviousData('PropsFileName', ExpandConstant('{tmp}\props.reg'));
    PropsFileName := PropsFilePage.Values[0];
  end;
end;

procedure RegisterPreviousData(PreviousDataKey: Integer);
begin
  // Store the settings so we can restore them next time
  SetPreviousData(PreviousDataKey, 'AclFileName', AclFilePage.Values[0]);
  SetPreviousData(PreviousDataKey, 'PropsFileName', PropsFilePage.Values[0]);
end;

function ShouldSkipPage(PageID: Integer): Boolean;
begin
  // Skip pages that shouldn't be shown
  Result := False;
  case PageID of
    AclFilePage.ID:
      if not(isTaskSelected('acl')) then Result := True
    PropsFilePage.ID:
      if not(isTaskSelected('properties')) then Result := True
  end;
end;

function NextButtonClick(CurPageID: Integer): Boolean;
begin
  case CurPageID of
    // Validate certain pages before allowing the user to proceed
    PropsFilePage.ID:
      if AclFilePage.Values[0] = '' then
        AclFilePage.Values[0] := ExpandConstant('{tmp}\acl.txt');

    wpReady:
      if PropsFilePage.Values[0] = '' then
        PropsFilePage.Values[0] := ExpandConstant('{tmp}\props.reg');
  end;
  Result := True;
end;

function AclFile(Param: String): String;
begin
  if FileExists(AclFilePage.Values[0]) then
    Result := AclFilePage.Values[0]
  else
    Result := ExpandConstant('{tmp}\acl.txt');
end;

function PropertiesFile(Param: String): String;
begin
  if FileExists(PropsFilePage.Values[0]) then
    Result := PropsFilePage.Values[0]
  else
    Result := ExpandConstant('{tmp}\props.reg');
end;

procedure StopVNC();
var
  Errorlevel: Integer;
begin
  if UsingWinNT() = True then
    begin
    Exec('net.exe', 'stop winvnc', '', SW_HIDE, ewWaitUntilTerminated, Errorlevel);
    if Errorlevel = 0 then
    begin
      Log('StopVNC: Stopping of WinVNC service succeeded.');
    end
    else begin
      if Errorlevel = 1 then
      begin
        Log('StopVNC: Stopping of WinVNC service failed. Errorlevel = 1.');
      end;
      Log('StopVNC: Stopping of WinVNC service failed. Errorlevel >= 1.');
    end;
  end;
  ExtractTemporaryFile('winvnc.exe');
  if Exec(ExpandConstant('{tmp}\winvnc.exe'), '-kill', '', SW_HIDE, ewWaitUntilTerminated, Errorlevel) then
  begin
    Log('StopVNC: Stopping of WinVNC application succeeded.');
  end
  else begin
    Log('StopVNC: Stopping of WinVNC application failed.');
  end;
end;

function IsTaskChecked(Taskname: String): Boolean;
begin
  Log('SelectedTasks='+SelectedTasks);
  if CompareStr(SelectedTasks, '?') <> 0 then
    Result := (Pos(Taskname, SelectedTasks) > 0)
  else
  begin
    // default if not set through inf file
    Result := false;
    case Taskname of
    'desktopicon':
      Result := true;
    'associate':
      Result := true;
  end;
  end;
end;
