Attribute VB_Name = "WinGPAPI"
Option Explicit

' ------------------------------------------------------------------------
'
'    WinGPAPI.bas -- WinGP API Declarations for Visual Basic
'
'              Copyright (C) 2006 Digital Electronics Corporation
'
'
' ------------------------------------------------------------------------
'
'       ProEasy.DLL
'
'       Version     1.0         Complying with Pro-Server Version 1.0
'
'       Version     1.1             Complying with the multi Pro-Server handle
'                               (The version of the Pro-Server is effective in more than 1.0)
'
'       Version     1.5         Complying with Group Item & cache/direct read
'                               (The version of the Pro-Server is effective in more than 1.5)
'
'       Version     2.0         SRAM backup data write
'                               It is changed from the node name to IP address.
'                               (The version of the Pro-Server is effective in more than 2.0)
'
'       Version     3.0         Gp_Web Version 1.0
'
'       Version     3.1         Direct Wirte(no read after write mode)
'                               (The version of the Pro-Server is effective in more than 3.1)
'
'       Version     4.0         Network project access API
'                               (The version of the Pro-Server is effective in more than 4.0)
'
'       Version     4.1         Data Base and Time Bar API and CSV file transfer API
'                               (The version of the Pro-Server is effective in more than 4.1)
'
'       Version     4.5         CSV file transfer API
'                               (The version of the Pro-Server is effective in more than 4.5)
'
'       Version     5.0         Pro-Server Ex
'                               (The version of the Pro-Server EX is effective in more than 1.0)
'
'       Version     5.1         WinGP was supported.
' ------------------------------------------------------------------------


' ------------------------------------------------------------------------
'       Application Data Type
' ------------------------------------------------------------------------
Public Const EASY_AppKind_NULL = 0
Public Const EASY_AppKind_Bit = 1
Public Const EASY_AppKind_SignedWord = 2
Public Const EASY_AppKind_UnsignedWord = 3
Public Const EASY_AppKind_HexWord = 4
Public Const EASY_AppKind_BCDWord = 5
Public Const EASY_AppKind_SignedDWord = 6
Public Const EASY_AppKind_UnsignedDWord = 7
Public Const EASY_AppKind_HexDWord = 8
Public Const EASY_AppKind_BCDDWord = 9
Public Const EASY_AppKind_Float = 10
Public Const EASY_AppKind_Real = 11
Public Const EASY_AppKind_Str = 12

Public Const EASY_AppKind_Group = &H8000
Public Const EASY_AppKind_SymbolSheet = &H9000

Public Const EASY_AppKind_BOOL = &H201

' ------------------------------------------------------------------------
'        GP BACKUP DATA TYPE
' ------------------------------------------------------------------------
Public Const EASY_BackupDataType_FILING = 1
Public Const EASY_BackupDataType_LOG = 2
Public Const EASY_BackupDataType_TREND = 3
Public Const EASY_BackupDataType_SAMPLING = 4
Public Const EASY_BackupDataType_ALARMHISTRY = 6
Public Const EASY_BackupDataType_ALARMLOG = 7

Public Const EASY_BackupDataType_ALARMBLOCK1 = 5
Public Const EASY_BackupDataType_ALARMBLOCK2 = 6
Public Const EASY_BackupDataType_ALARMBLOCK3 = 7
Public Const EASY_BackupDataType_ALARMBLOCK4 = 8
Public Const EASY_BackupDataType_ALARMBLOCK5 = 9
Public Const EASY_BackupDataType_ALARMBLOCK6 = 10
Public Const EASY_BackupDataType_ALARMBLOCK7 = 11
Public Const EASY_BackupDataType_ALARMBLOCK8 = 12

Public Const EASY_BackupDataType_SAMPLING_With_Group = &H8002

Public Const EASY_BackupDataType_SaveMode_Rewrite = 0
Public Const EASY_BackupDataType_SaveMode_Append = 1


' ------------------------------------------------------------------------
'   Pro-Easy system functions
Declare Function EasyInit Lib "ProEasy.DLL" () As Long
Declare Function EasyTerm Lib "ProEasy.DLL" () As Long
Declare Function EasyGetSystemStatus Lib "ProEasy.DLL" () As Long

'  wait setting
Declare Function EasySetWaitType Lib "ProEasy.DLL" (ByVal dwWaitType As Long) As Long
Declare Function EasyGetWaitType Lib "ProEasy.DLL" () As Long


' --------------------------------------------------------------------------------
' API error message function
Declare Function EasyLoadErrorMessage Lib "ProEasy.DLL" (ByVal iErrorCode As Long, ByVal osErrorMessage As String) As Long

' API that an error message is acquired from the error code and that it is expanded
Declare Function EasyLoadErrorMessageEx Lib "ProEasy.DLL" (ByVal iErrorCode As Long, ByVal osErrorMessage As String) As Long


' --------------------------------------------------------------------------------
' Write functions
Declare Function WriteDeviceBit Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sDeviceName As String, ByRef pwData As Integer, ByVal wCount As Integer) As Long
Declare Function WriteDevice16 Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sDeviceName As String, ByRef pwData As Integer, ByVal wCount As Integer) As Long
Declare Function WriteDevice32 Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sDeviceName As String, ByRef pdwData As Long, ByVal wCount As Integer) As Long
Declare Function WriteDeviceBCD16 Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sDeviceName As String, ByRef pwData As Integer, ByVal wCount As Integer) As Long
Declare Function WriteDeviceBCD32 Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sDeviceName As String, ByRef pdwData As Long, ByVal wCount As Integer) As Long
Declare Function WriteDeviceFloat Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sDeviceName As String, ByRef pflData As Single, ByVal wCount As Integer) As Long
Declare Function WriteDeviceDouble Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sDeviceName As String, ByRef pdbData As Double, ByVal wCount As Integer) As Long
Declare Function WriteDeviceStr Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sDeviceName As String, ByVal psData As String, ByVal wCount As Integer) As Long
Declare Function WriteDeviceVariant Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sDeviceName As String, ByRef pvData As Variant, ByVal wCount As Integer, ByVal wAppKind As Integer) As Long


' --------------------------------------------------------------------------------
' Read functions
Declare Function ReadDeviceBit Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sDeviceName As String, ByRef owData As Integer, ByVal wCount As Integer) As Long
Declare Function ReadDevice16 Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sDeviceName As String, ByRef owData As Integer, ByVal wCount As Integer) As Long
Declare Function ReadDevice32 Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sDeviceName As String, ByRef odwData As Long, ByVal wCount As Integer) As Long
Declare Function ReadDeviceBCD16 Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sDeviceName As String, ByRef owData As Integer, ByVal wCount As Integer) As Long
Declare Function ReadDeviceBCD32 Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sDeviceName As String, ByRef odwData As Long, ByVal wCount As Integer) As Long
Declare Function ReadDeviceFloat Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sDeviceName As String, ByRef oflData As Single, ByVal wCount As Integer) As Long
Declare Function ReadDeviceDouble Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sDeviceName As String, ByRef odbData As Double, ByVal wCount As Integer) As Long
Declare Function ReadDeviceStr Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sDeviceName As String, ByVal osData As String, ByVal wCount As Integer) As Long
Declare Function ReadDeviceVariant Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sDeviceName As String, ByRef ovData As Variant, ByVal wCount As Integer, ByVal wAppKind As Integer) As Long


' --------------------------------------------------------------------------------
' Symbol Information 's API
Public Type SymbolInformation
        m_wAppKind  As Integer                  ' Application data type (1 to 12, 0x8000 )
        m_wDataCount  As Integer                ' Count of data
        m_dwSizeOf   As Long                    ' The byte size of the buffer which is necessary to access it
        m_sSymbolName(1 To 65) As Byte          ' Symbol name
        m_bDummy1(1 To 3) As Byte               ' Dummy[0],Dummy[1] reserved, Dummy[2] extend infomation
        m_sDeviceAddress(1 To 257) As Byte      ' Device address
        m_bDummy2(1 To 3) As Byte
End Type

Declare Function SizeOfSymbol Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sSymbolName As String, ByRef oiByteSize As Long) As Long
Declare Function GetCountOfSymbolMember Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sSymbolName As String, ByRef oiCountOfMember As Long) As Long
Declare Function GetSymbolInformation Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sSymbolName As String, ByVal iMaxCountOfSymbolMember As Long, ByVal osSymbolSheetName As String, ByRef oSymbolInformation As SymbolInformation, ByRef oiGotCountOfSymbolMember As Long) As Long

' Group Access API
Declare Function ReadSymbol Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sSymbolName As String, ByRef oReadBufferData As Byte) As Long
Declare Function ReadSymbolVariant Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sSymbolName As String, ByRef pvData As Variant) As Long

Declare Function WriteSymbol Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sSymbolName As String, ByRef pWriteBufferData As Byte) As Long
Declare Function WriteSymbolVariant Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sSymbolName As String, ByRef pvData As Variant) As Long


' --------------------------------------------------------------------------------
' Queuing Access Control's API
Declare Function BeginQueuingRead Lib "ProEasy.DLL" () As Long
Declare Function BeginQueuingWrite Lib "ProEasy.DLL" () As Long
Declare Function ExecuteQueuingAccess Lib "ProEasy.DLL" () As Long
Declare Function CancelQueuingAccess Lib "ProEasy.DLL" () As Long
Declare Function IsQueuingAccessSucceeded Lib "ProEasy.DLL" (ByVal iIndex As Long) As Long


' --------------------------------------------------------------------------------
' SRAM access functions
Declare Function EasyBackupDataRead Lib "ProEasy.DLL" (ByVal sSaveFileName As String, ByVal sNodeName As String, ByVal iBackupDataType As Long, ByVal iSaveMode As Long) As Long
Declare Function EasyBackupDataReadEx Lib "ProEasy.DLL" (ByVal sSaveFileName As String, ByVal sNodeName As String, ByVal iBackupDataType As Long, ByVal iSaveMode As Long, ByVal iNumber As Long, ByVal iStringTable As Long) As Long

Declare Function EasyBackupDataWrite Lib "ProEasy.DLL" (ByVal sSourceFileName As String, ByVal sNodeName As String, ByVal iBackupDataType As Long) As Long


' --------------------------------------------------------------------------------
' CF Card functions

Declare Function EasyIsCFCard Lib "ProEasy.DLL" (ByVal sNodeName As String) As Long


' CSV file transfer API's
Public Type stEasyDirInfo
    bFileName(1 To 9) As Byte       ' FileName
    bExt(1 To 4) As Byte            ' Extension
    bDummy(1 To 3) As Byte          ' Dummy
    dwFileSize As Long              ' FileSize
    bFileTimeStamp(1 To 9) As Byte  ' TimeStamp
    bDummy2(1 To 3)  As Byte        ' Dummy2
End Type

Declare Function EasyGetListInCard Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sDirectory As String, ByRef oiCount As Long, ByVal sSaveFileName As String) As Long
Declare Function EasyFileReadCard Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal pReadFileType As String, ByVal wReadFileNo As Integer, ByVal sWriteFileName As String, ByRef odwFileSize As Long) As Long
Declare Function EasyFileWriteCard Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal pReadFileName As String, ByVal sWriteFileType As String, ByVal wWriteFileNo As Integer) As Long
Declare Function EasyGetCfFreeSpace Lib "ProEasy.DLL" (ByVal sNodeName As String, ByRef oiUnallocated As Long) As Long

Declare Function EasyFileDeleteCard Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal pDeleteFileType As String, ByVal wDeleteFileNo As Integer) As Long
Declare Function EasyGetListInCfCard Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sDirectory As String, ByRef oiCount As Long, ByVal sSaveFileName As String) As Long
Declare Function EasyFileDeleteInCfCard Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sFolderName As String, ByVal sFileName As String) As Long
Declare Function EasyFileReadInCfCard Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sFolderName As String, ByVal sFileName As String, ByVal sWriteFileName As String, ByRef odwFileSize As Long) As Long
Declare Function EasyFileWriteInCfCard Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal pReadFileName As String, ByVal sFolderName As String, ByVal sFileName As String) As Long
Declare Function EasyFileRenameInCfCard Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sFolderName As String, ByVal sFileName As String, ByVal sFileRename As String) As Long


' CF-CARD access control API
Declare Function EasyFileSetPassiveMode Lib "ProEasy.DLL" (ByVal iPassive As Long) As Long

' --------------------------------------------------------------------------------
' node status
Declare Function GetNodeProperty Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal dwTimeLimit As Long, ByVal dwGPType As String, ByVal osSystemVersion As String, ByVal osComVersion As String, ByVal osECOMVersion As String) As Long

' --------------------------------------------------------------------------------
' node time functions
Declare Function EasyGetGPTime Lib "ProEasy.DLL" (ByVal sNodeName As String, ByRef odwTime As Long) As Long
Declare Function EasyGetGPTimeVariant Lib "ProEasy.DLL" (ByVal sNodeName As String, ByRef ovTime As Variant) As Long
Declare Function EasyGetGPTimeString Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sFormat As String, ByVal osTime As String) As Long
Declare Function EasyGetGPTimeStringVariant Lib "ProEasy.DLL" (ByVal sNodeName As String, ByVal sFormat As String, ByRef ovTime As Variant) As Long
