Imports System.Runtime.InteropServices

Module Module1

#Region " Defined Handling API "

    Public Enum API_ERROR          ' Define API error.
        E_ILLEGAL_PARAMETER = -5   ' 
        E_TIMEOUT = -4             ' 
        E_INVALID_COMMAND = -3     ' 
        E_INVALID_PARAMETER = -2   ' 
        E_ERROR_IN_RUNTIME = -1    ' 
        E_SUCCESS = 0              ' 
        E_RUNTIME_NO_ACCEPT = 1    ' 
        E_INVALID_HANDLE = 2       ' 
    End Enum

    Public Enum PROJECTINFO_SIZE    ' Define Size.
        e_FileName = 257            ' Project file name.
        e_Comment = 62              ' Project title.
        e_FastTime = 18             ' Project created date.
        e_LastTiem = 18             ' Project last update.
        e_IDownload = 18            ' Project download date.
        e_HMIEditorVersion = 32     ' HMI editor version.
        e_ControlEditorVersion = 32 ' CONTROL editor version.
        e_MakingPerson = 31         ' Person.
    End Enum

    <DllImport("RtCtrlAPI.dll")> Public Function GetRuntimeHandle(ByVal Port As Int32) As Int32
    End Function

    <DllImport("RtCtrlAPI.dll")> Public Function ReleaseRuntimeHandle(ByVal IPCHandle As Int32) As Boolean
    End Function

    <DllImport("RtCtrlAPI.dll")> Public Function InitRuntimeAPI() As Boolean
    End Function

    <DllImport("RtCtrlAPI.dll")> Public Function CleanupRuntimeAPI() As Boolean
    End Function

    <DllImport("RtCtrlAPI.dll")> Public Function GetRuntimeStartState(ByVal IPCHandle As Int32, ByRef RuntimeCondition As Int32) As Int32
    End Function

    <DllImport("RtCtrlAPI.dll")> Public Function GetDisplayScreenNumber(ByVal IPCHandle As Int32, ByRef DisplayScreenNumber As Int32) As Int32
    End Function

    <DllImport("RtCtrlAPI.dll")> Public Function GetScreenState(ByVal IPCHandle As Int32, ByRef ScreenState As Int32) As Int32
    End Function

    <DllImport("RtCtrlAPI.dll")> Public Function GetLanguage(ByVal IPCHandle As Int32, ByVal LanguageKind As Int32, ByRef LanguageNumber As Int32) As Int32
    End Function

    <DllImport("RtCtrlAPI.dll")> Public Function GetTouchBuzzer(ByVal IPCHandle As Int32, ByRef BuzzerState As Int32) As Int32
    End Function

    <DllImport("RtCtrlAPI.dll")> _
    Public Function GetProjctInformation( _
     ByVal IPCHandle As Int32, _
     <MarshalAs(UnmanagedType.LPWStr)> ByVal ProjectFileName As System.Text.StringBuilder, _
     <MarshalAs(UnmanagedType.LPWStr)> ByVal ProjectComment As System.Text.StringBuilder, _
     <MarshalAs(UnmanagedType.LPWStr)> ByVal ProjectFastTime As System.Text.StringBuilder, _
     <MarshalAs(UnmanagedType.LPWStr)> ByVal ProjectLastTime As System.Text.StringBuilder, _
     <MarshalAs(UnmanagedType.LPWStr)> ByVal ProjectIDownload As System.Text.StringBuilder, _
     <MarshalAs(UnmanagedType.LPWStr)> ByVal HMIEditorVersion As System.Text.StringBuilder, _
     <MarshalAs(UnmanagedType.LPWStr)> ByVal ControlEditorVersion As System.Text.StringBuilder, _
     <MarshalAs(UnmanagedType.LPWStr)> ByVal MakingPerson As System.Text.StringBuilder _
    ) As Int32
    End Function

    <DllImport("RtCtrlAPI.dll")> Public Function GetRuntimeVersion(ByVal IPCHandle As Int32, <MarshalAs(UnmanagedType.LPWStr)> ByVal VersionInfo As System.Text.StringBuilder) As Int32
    End Function

    <DllImport("RtCtrlAPI.dll")> Public Function StopRuntime(ByVal IPCHandle As Int32, ByVal StopMode As Int32) As Int32
    End Function

    <DllImport("RtCtrlAPI.dll")> Public Function SetDisplayScreenNumber(ByVal IPCHandle As Int32, ByVal ScreenNumber As Int32) As Int32
    End Function

    <DllImport("RtCtrlAPI.dll")> Public Function SetScreenState(ByVal IPCHandle As Int32, ByVal ScreenState As Int32, ByVal PosX As Int32, ByVal PosY As Int32, ByVal Width As Int32, ByVal Height As Int32) As Int32
    End Function

    <DllImport("RtCtrlAPI.dll")> Public Function SetLanguage(ByVal IPCHandle As Int32, ByVal LanguageKind As Int32, ByVal LanguageNumber As Int32) As Int32
    End Function

    <DllImport("RtCtrlAPI.dll")> Public Function SetTouchBuzzer(ByVal IPCHandle As Int32, ByVal BuzzerState As Int32) As Int32
    End Function

    <DllImport("RtCtrlAPI.dll")> Public Function GetEnumScreenNumberCount(ByVal IPCHandle As Int32, ByRef ScreenNumberCount As Int32) As Int32
    End Function

    <DllImport("RtCtrlAPI.dll")> Public Function EnumScreenNumber(ByVal IPCHandle As Int32, ByVal ScreenCount As Int32, ByRef ScreenNumbers As Int32) As Int32
    End Function

    <DllImport("RtCtrlAPI.dll")> Public Function GetEnumLanguageCount(ByVal IPCHandle As Int32, ByVal LanguageKind As Int32, ByRef LanguageCount As Int32) As Int32
    End Function

    <DllImport("RtCtrlAPI.dll")> Public Function EnumLanguage(ByVal IPCHandle As Int32, ByVal LanguageKind As Int32, ByVal LanguageCount As Int32, ByRef Languages As Int32) As Int32
    End Function
#End Region

End Module
