//////////////////////////////////////////////////////////////////////////////////////////
///
///	@file	RAS_API_PFXPHMIP6.h
///
///	@brief	This module contains difinition of RAS_API functions.
///
///	@date	Create date			: 2021.01.13.
///	@date	Last modify date	: 2023.02.03.
///
///	@copyright	Copyright (C) 2021 Schneider Electric. All Rights Reserved.
///
///////////////////////////////////////////////////////////////////////////////////////////

#pragma once

#ifdef API_DLL_EXPORTS
#define DLL_API __declspec(dllexport)
#else
#define DLL_API __declspec(dllimport)
#endif

// WDT functions.
DLL_API bool WINAPI RAS_SetWDTCounter(int iValue);
DLL_API bool WINAPI RAS_StopWDTCounter(void);
DLL_API bool WINAPI RAS_GetWDTStatus(int *iState);
DLL_API bool WINAPI RAS_ClrWDTTimeoutStatus(void);
DLL_API bool WINAPI RAS_SetWDTResetMask(int iMask);
DLL_API bool WINAPI RAS_GetWDTResetMask(int* iMask);

// WDT status definitions.
#define WDT_STOP                0
#define WDT_COUNTING            1
#define WDT_TIMEOUT             2

// WDT H/W reset mask definitions.
#define WDT_HWRESET_DISABLE     0
#define WDT_HWRESET_ENABLE      1
