//////////////////////////////////////////////////////////////////////////////////////////
///
///	@file	SysMonApi.h
///
///	@brief	This module contains difinition of SysMonAPI functions.
///
///	@date	Last modify date	: 2020.12.17.
///
///	@copyright	Copyright (C) 2020 Schneider Electric. All Rights Reserved.
///
///////////////////////////////////////////////////////////////////////////////////////////
#pragma once
#include "RAS_Data_Index.h"

#ifdef SYSMONAPI_EXPORTS
#define SYSMON_API	__declspec(dllexport)
#else
#define SYSMON_API	__declspec(dllimport)
#endif

#ifdef  __cplusplus
extern "C" {
#endif

	SYSMON_API	BOOL WINAPI SysMonGetLibVersion(char* pchStr);
	SYSMON_API	BOOL WINAPI SysMonGetCurrentValue(int iSelector, int* piValue);
	SYSMON_API	BOOL WINAPI SysMonGetLogValue(int iSelector, int* piValue, struct tm* pstTime);
	SYSMON_API	BOOL WINAPI SysMonGetWarningFlag(int iSelector, int* piFlag);
	SYSMON_API	BOOL WINAPI	SysMonGetIsWarning(int* piFlag);
	SYSMON_API	BOOL WINAPI	SysMonGetSensorName(int iSelector, PTCHAR ptcStr);

#ifdef  __cplusplus
}
#endif