﻿//////////////////////////////////////////////////////////////////////////////////////////
///
///	@file	DIDO_PFXPHMIP6.h
///
///	@brief	This module contains difinition of DIDO_PFXPHMIP6 functions.
///
///	@date	Last modify date	: 2021.06.02.
///
///	@copyright	Copyright (C) 2021 Schneider Electric. All Rights Reserved.
///
///////////////////////////////////////////////////////////////////////////////////////////
#pragma once

#ifdef DIDO_API_EXPORTS
#define DIDO_API __declspec(dllexport)
#else
#define DIDO_API __declspec(dllimport)
#endif

#define	SERI_ERROR_FAIL_				-1			//!< Error.
#define	SERI_ERROR_OK_					0x0000		//!< No error.
#define	SERI_ERROR_RESPONSE_			0x0001		//!< Response error.
#define	SERI_ERROR_COMM_MASK_			0x0002		//!< Set comm mask error.
#define	SERI_ERROR_COMM_TIMEOUT_		0x0004		//!< Set comm timeout error.
#define	SERI_ERROR_COMM_STATE_			0x0008		//!< Set comm state error.
#define	SERI_ERROR_HANDLE_				0x0010		//!< Handle error.
#define	SERI_ERROR_PARAM_				0x0020		//!< Parameter error.
#define	SERI_ERROR_COMM_NOTREADY_		0x0040		//!< Device not ready error.
#define	DIDO_COUNTER0_					0			//!< Counter 0.
#define	DIDO_COUNTER1_					1			//!< Counter 1.
#define	DIDO_COUNTER_RESET_				0			//!< Reset Counter.
#define	DIDO_COUNTER_START_				1			//!< Start Counter.
#define	DIDO_COUNTER_STOP_				2			//!< Stop Counter.
#define	DIDO_COUNTER_RESTART_			3			//!< Restart Counter.
#define	DIDO_COUNTER_MODE_RISING_		4			//!< Counter mode Rising.
#define	DIDO_COUNTER_MODE_FALLING_		5			//!< Counter mode Falling.
#define	DIDO_COUNTER_MODE_BOTH_			6			//!< Counter mode Both.
#define	DIDO_COUNTER_DEBOUNCE_ENABLE_	7			//!< Counter debounce enable.
#define	DIDO_COUNTER_DEBOUNCE_DISABLE_	8			//!< Counter debounce disable.
#define	DIDO_SLOT1_						1			//!< Option Interface Slot #1.
#define	DIDO_SLOT2_						2			//!< Option Interface Slot #2.

DIDO_API HANDLE	OpenDido(int iSlotNo);
DIDO_API void	CloseDido(HANDLE hHandle);
DIDO_API int	GetFwVersion(HANDLE hHandle, PTCHAR ptcBl, PTCHAR ptcApp);
DIDO_API int	SetDout(HANDLE hHandle, BYTE byData);
DIDO_API int	SetDoutDefault(HANDLE hHandle, BYTE byData);
DIDO_API int	GetDout(HANDLE hHandle, PBYTE pbyData);
DIDO_API int	GetDin(HANDLE hHandle, PWORD pwData);
DIDO_API int	GetCounter(HANDLE hHandle, int iCounterId, PDWORD pdwData);
DIDO_API int	SetCounter(HANDLE hHandle, int iCounterId, int iControl);
