﻿'
' Form1.vb
'
' This module contains an example of how to use DIDO_PFXPHMIP6_32.dll.
'
' Create date		: 2021.06.02.
'
' Copyright (C) 2021 Schneider Electric. All Rights Reserved.
'
'
Imports Microsoft.Win32.SafeHandles

Public Class Form1

#Region "Methods"

    Private didoHandle As SafeFileHandle
    Private dinData As UShort
    Private doutData As Byte

    '
    ' DOUT setting change event handlers.
    '
    Private Sub CheckBox0_CheckedChanged(sender As Object, e As EventArgs) Handles CheckBox0.CheckedChanged
        If CheckBox0.Checked Then
            CheckBox0.ImageIndex = 1
            doutData = doutData Or &H1
        Else
            CheckBox0.ImageIndex = 0
            doutData = doutData And &HFE
        End If
        CheckBox0.Refresh()
        NativeMethods.SetDout(didoHandle, doutData)
    End Sub

    Private Sub CheckBox1_CheckedChanged(sender As Object, e As EventArgs) Handles CheckBox1.CheckedChanged
        If CheckBox1.Checked Then
            CheckBox1.ImageIndex = 1
            doutData = doutData Or &H2
        Else
            CheckBox1.ImageIndex = 0
            doutData = doutData And &HFD
        End If
        CheckBox1.Refresh()
        NativeMethods.SetDout(didoHandle, doutData)
    End Sub

    Private Sub CheckBox2_CheckedChanged(sender As Object, e As EventArgs) Handles CheckBox2.CheckedChanged
        If CheckBox2.Checked Then
            CheckBox2.ImageIndex = 1
            doutData = doutData Or &H4
        Else
            CheckBox2.ImageIndex = 0
            doutData = doutData And &HFB
        End If
        CheckBox2.Refresh()
        NativeMethods.SetDout(didoHandle, doutData)
    End Sub

    Private Sub CheckBox3_CheckedChanged(sender As Object, e As EventArgs) Handles CheckBox3.CheckedChanged
        If CheckBox3.Checked Then
            CheckBox3.ImageIndex = 1
            doutData = doutData Or &H8
        Else
            CheckBox3.ImageIndex = 0
            doutData = doutData And &HF7
        End If
        CheckBox3.Refresh()
        NativeMethods.SetDout(didoHandle, doutData)
    End Sub

    Private Sub CheckBox4_CheckedChanged(sender As Object, e As EventArgs) Handles CheckBox4.CheckedChanged
        If CheckBox4.Checked Then
            CheckBox4.ImageIndex = 1
            doutData = doutData Or &H10
        Else
            CheckBox4.ImageIndex = 0
            doutData = doutData And &HEF
        End If
        CheckBox4.Refresh()
        NativeMethods.SetDout(didoHandle, doutData)
    End Sub

    Private Sub CheckBox5_CheckedChanged(sender As Object, e As EventArgs) Handles CheckBox5.CheckedChanged
        If CheckBox5.Checked Then
            CheckBox5.ImageIndex = 1
            doutData = doutData Or &H20
        Else
            CheckBox5.ImageIndex = 0
            doutData = doutData And &HDF
        End If
        CheckBox5.Refresh()
        NativeMethods.SetDout(didoHandle, doutData)
    End Sub

    Private Sub CheckBox6_CheckedChanged(sender As Object, e As EventArgs) Handles CheckBox6.CheckedChanged
        If CheckBox6.Checked Then
            CheckBox6.ImageIndex = 1
            doutData = doutData Or &H40
        Else
            CheckBox6.ImageIndex = 0
            doutData = doutData And &HBF
        End If
        CheckBox6.Refresh()
        NativeMethods.SetDout(didoHandle, doutData)
    End Sub

    Private Sub CheckBox7_CheckedChanged(sender As Object, e As EventArgs) Handles CheckBox7.CheckedChanged
        If CheckBox7.Checked Then
            CheckBox7.ImageIndex = 1
            doutData = doutData Or &H80
        Else
            CheckBox7.ImageIndex = 0
            doutData = doutData And &H7F
        End If
        CheckBox7.Refresh()
        NativeMethods.SetDout(didoHandle, doutData)
    End Sub

    '
    ' Form close event handler for close the DIDO.
    '
    Private Sub Form1_FormClosed(sender As Object, e As FormClosedEventArgs) Handles MyBase.FormClosed
        If Not didoHandle.IsInvalid Then
            Timer1.Enabled = False
            ' Close DIDO module.
            NativeMethods.CloseDido(didoHandle)
            didoHandle.SetHandleAsInvalid()
        End If
        If Not didoHandle.IsClosed Then
            didoHandle.Close()
        End If
    End Sub

    '
    ' Form load event handler.
    '
    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        ' Open DIDO Slot1.
        didoHandle = NativeMethods.OpenDido(Constants.DidoSlot1)
        ' Open DIDO Slot2.
        'didoHandle = NativeMethods.OpenDido(Constants.DidoSlot2)
        If didoHandle.IsInvalid Then
            MessageBox.Show("Cannot open DIDO")
            Close()
        Else
            'Get the current status of DOUT And DIN.
            NativeMethods.GetDout(didoHandle, doutData)
            UpdateDoutSwitch(doutData)
            NativeMethods.GetDin(didoHandle, dinData)
            UpdateDinLamp(dinData)
            Timer1.Enabled = True
        End If
    End Sub

    '
    ' Timer handler for update DIN status.
    '
    Private Sub Timer1_Tick(sender As Object, e As EventArgs) Handles Timer1.Tick
        NativeMethods.GetDin(didoHandle, dinData)
        UpdateDinLamp(dinData)
    End Sub

    '
    ' Update the status of the DIN lamp.
    '
    Private Sub UpdateDinLamp(dinStatus As UShort)
        For i = 0 To 15
            Dim mask As Integer
            Dim data As Integer
            mask = 1 << i
            data = dinStatus And mask
            Select Case mask
                Case &H1
                    If data <> 0 Then
                        PictureBox0.Image = ImageListLamp.Images(1)
                    Else
                        PictureBox0.Image = ImageListLamp.Images(0)
                    End If
                    PictureBox0.Refresh()
                Case &H2
                    If data <> 0 Then
                        PictureBox1.Image = ImageListLamp.Images(1)
                    Else
                        PictureBox1.Image = ImageListLamp.Images(0)
                    End If
                    PictureBox1.Refresh()
                Case &H4
                    If data <> 0 Then
                        PictureBox2.Image = ImageListLamp.Images(1)
                    Else
                        PictureBox2.Image = ImageListLamp.Images(0)
                    End If
                    PictureBox2.Refresh()
                Case &H8
                    If data <> 0 Then
                        PictureBox3.Image = ImageListLamp.Images(1)
                    Else
                        PictureBox3.Image = ImageListLamp.Images(0)
                    End If
                    PictureBox3.Refresh()
                Case &H10
                    If data <> 0 Then
                        PictureBox4.Image = ImageListLamp.Images(1)
                    Else
                        PictureBox4.Image = ImageListLamp.Images(0)
                    End If
                    PictureBox4.Refresh()
                Case &H20
                    If data <> 0 Then
                        PictureBox5.Image = ImageListLamp.Images(1)
                    Else
                        PictureBox5.Image = ImageListLamp.Images(0)
                    End If
                    PictureBox5.Refresh()
                Case &H40
                    If data <> 0 Then
                        PictureBox6.Image = ImageListLamp.Images(1)
                    Else
                        PictureBox6.Image = ImageListLamp.Images(0)
                    End If
                    PictureBox6.Refresh()
                Case &H80
                    If data <> 0 Then
                        PictureBox7.Image = ImageListLamp.Images(1)
                    Else
                        PictureBox7.Image = ImageListLamp.Images(0)
                    End If
                    PictureBox7.Refresh()
                Case &H100
                    If data <> 0 Then
                        PictureBox8.Image = ImageListLamp.Images(1)
                    Else
                        PictureBox8.Image = ImageListLamp.Images(0)
                    End If
                    PictureBox8.Refresh()
                Case &H200
                    If data <> 0 Then
                        PictureBox9.Image = ImageListLamp.Images(1)
                    Else
                        PictureBox9.Image = ImageListLamp.Images(0)
                    End If
                    PictureBox9.Refresh()
                Case &H400
                    If data <> 0 Then
                        PictureBox10.Image = ImageListLamp.Images(1)
                    Else
                        PictureBox10.Image = ImageListLamp.Images(0)
                    End If
                    PictureBox10.Refresh()
                Case &H800
                    If data <> 0 Then
                        PictureBox11.Image = ImageListLamp.Images(1)
                    Else
                        PictureBox11.Image = ImageListLamp.Images(0)
                    End If
                    PictureBox11.Refresh()
                Case &H1000
                    If data <> 0 Then
                        PictureBox12.Image = ImageListLamp.Images(1)
                    Else
                        PictureBox12.Image = ImageListLamp.Images(0)
                    End If
                    PictureBox12.Refresh()
                Case &H2000
                    If data <> 0 Then
                        PictureBox13.Image = ImageListLamp.Images(1)
                    Else
                        PictureBox13.Image = ImageListLamp.Images(0)
                    End If
                    PictureBox13.Refresh()
                Case &H4000
                    If data <> 0 Then
                        PictureBox14.Image = ImageListLamp.Images(1)
                    Else
                        PictureBox14.Image = ImageListLamp.Images(0)
                    End If
                    PictureBox14.Refresh()
                Case &H8000
                    If data <> 0 Then
                        PictureBox15.Image = ImageListLamp.Images(1)
                    Else
                        PictureBox15.Image = ImageListLamp.Images(0)
                    End If
                    PictureBox15.Refresh()
            End Select
        Next
    End Sub

    '
    ' Update the status of the DOUT switch.
    '
    Private Sub UpdateDoutSwitch(doutStatus As Byte)
        For i = 0 To 7
            Dim mask As Integer
            Dim data As Integer
            mask = 1 << i
            data = doutStatus And mask
            Select Case mask
                Case &H1
                    If data <> 0 Then
                        CheckBox0.ImageIndex = 1
                        CheckBox0.Checked = True
                    Else
                        CheckBox0.ImageIndex = 0
                        CheckBox0.Checked = False
                    End If
                    CheckBox0.Refresh()
                Case &H2
                    If data <> 0 Then
                        CheckBox1.ImageIndex = 1
                        CheckBox1.Checked = True
                    Else
                        CheckBox1.ImageIndex = 0
                        CheckBox1.Checked = False
                    End If
                    CheckBox1.Refresh()
                Case &H4
                    If data <> 0 Then
                        CheckBox2.ImageIndex = 1
                        CheckBox2.Checked = True
                    Else
                        CheckBox2.ImageIndex = 0
                        CheckBox2.Checked = False
                    End If
                    CheckBox2.Refresh()
                Case &H8
                    If data <> 0 Then
                        CheckBox3.ImageIndex = 1
                        CheckBox3.Checked = True
                    Else
                        CheckBox3.ImageIndex = 0
                        CheckBox3.Checked = False
                    End If
                    CheckBox3.Refresh()
                Case &H10
                    If data <> 0 Then
                        CheckBox4.ImageIndex = 1
                        CheckBox4.Checked = True
                    Else
                        CheckBox4.ImageIndex = 0
                        CheckBox4.Checked = False
                    End If
                    CheckBox4.Refresh()
                Case &H20
                    If data <> 0 Then
                        CheckBox5.ImageIndex = 1
                        CheckBox5.Checked = True
                    Else
                        CheckBox5.ImageIndex = 0
                        CheckBox5.Checked = False
                    End If
                    CheckBox5.Refresh()
                Case &H40
                    If data <> 0 Then
                        CheckBox6.ImageIndex = 1
                        CheckBox6.Checked = True
                    Else
                        CheckBox6.ImageIndex = 0
                        CheckBox6.Checked = False
                    End If
                    CheckBox6.Refresh()
                Case &H80
                    If data <> 0 Then
                        CheckBox7.ImageIndex = 1
                        CheckBox7.Checked = True
                    Else
                        CheckBox7.ImageIndex = 0
                        CheckBox7.Checked = False
                    End If
                    CheckBox7.Refresh()
            End Select
        Next
    End Sub

#End Region

End Class