﻿//
// Dido.cs
//
// This module contains difinition of DIDO_PFXPHMIP6_32.dll functions.
//
// Create date		: 2021.06.02.
//
// Copyright (C) 2021 Schneider Electric. All Rights Reserved.
//
//
using Microsoft.Win32.SafeHandles;
using System.Runtime.InteropServices;
using System.Text;

namespace PFXPHMIP6_DIDO_SampleCode_CS
{
    /// <summary>
    /// Constant definitions for DIDO.
    /// </summary>
    internal static class Constants
    {
        #region Fields

        public const int DidoCounter0 = 0;                  //!< Counter 0.
        public const int DidoCounter1 = 1;                  //!< Counter 1.
        public const int DidoCounterDebounceDisable = 8;    //!< Counter debounce disable.
        public const int DidoCounterDebounceEnable = 7;     //!< Counter debounce enable.
        public const int DidoCounterModeBoth = 6;           //!< Counter mode Both.
        public const int DidoCounterModeFalling = 5;        //!< Counter mode Falling.
        public const int DidoCounterModeRising = 4;         //!< Counter mode Rising.
        public const int DidoCounterReset = 0;              //!< Reset Counter.
        public const int DidoCounterRestart = 3;            //!< Restart Counter.
        public const int DidoCounterStart = 1;              //!< Start Counter.
        public const int DidoCounterStop = 2;               //!< Stop Counter.
        public const int DidoSlot1 = 1;                     //!< Option Interface Slot #1.
        public const int DidoSlot2 = 2;                     //!< Option Interface Slot #2.
        public const int SeriErrorCommHandle = 0x0010;      //!< Handle error.
        public const int SeriErrorCommMask = 0x0002;        //!< Set comm mask error.
        public const int SeriErrorCommNotReady = 0x0040;    //!< Device not ready error.
        public const int SeriErrorCommParam = 0x0020;       //!< Parameter error.
        public const int SeriErrorCommState = 0x0008;       //!< Set comm state error.
        public const int SeriErrorCommTimeout = 0x0004;     //!< Set comm timeout error.
        public const int SeriErrorFail = -1;	    	   	//!< Error.
        public const int SeriErrorOk = 0x0000;   	    	//!< No error.
        public const int SeriErrorResponse = 0x0001;        //!< Response error.

        #endregion Fields
    }

    /// <summary>
    /// DIDO API function definition.
    /// </summary>
    internal class NativeMethods
    {
        #region Methods

        [DllImport("DIDO_PFXPHMIP6_32.dll", CallingConvention = CallingConvention.Cdecl, SetLastError = true, CharSet = CharSet.Unicode)]
        internal static extern void CloseDido(SafeFileHandle didoHandle);

        [DllImport("DIDO_PFXPHMIP6_32.dll", CallingConvention = CallingConvention.Cdecl, SetLastError = true, CharSet = CharSet.Unicode)]
        internal static extern int GetCounter(SafeFileHandle didoHandle, int counterId, ref ushort data);

        [DllImport("DIDO_PFXPHMIP6_32.dll", CallingConvention = CallingConvention.Cdecl, SetLastError = true, CharSet = CharSet.Unicode)]
        internal static extern int GetDin(SafeFileHandle didoHandle, ref ushort data);

        [DllImport("DIDO_PFXPHMIP6_32.dll", CallingConvention = CallingConvention.Cdecl, SetLastError = true, CharSet = CharSet.Unicode)]
        internal static extern int GetDout(SafeFileHandle didoHandle, ref byte data);

        [DllImport("DIDO_PFXPHMIP6_32.dll", CallingConvention = CallingConvention.Cdecl, SetLastError = true, CharSet = CharSet.Unicode)]
        internal static extern int GetFwVersion(SafeFileHandle didoHandle, StringBuilder verBl, StringBuilder verApp);

        [DllImport("DIDO_PFXPHMIP6_32.dll", CallingConvention = CallingConvention.Cdecl, SetLastError = true, CharSet = CharSet.Unicode)]
        internal static extern SafeFileHandle OpenDido(int slotNo);

        [DllImport("DIDO_PFXPHMIP6_32.dll", CallingConvention = CallingConvention.Cdecl, SetLastError = true, CharSet = CharSet.Unicode)]
        internal static extern int SetCounter(SafeFileHandle didoHandle, int counterId, int control);

        [DllImport("DIDO_PFXPHMIP6_32.dll", CallingConvention = CallingConvention.Cdecl, SetLastError = true, CharSet = CharSet.Unicode)]
        internal static extern int SetDout(SafeFileHandle didoHandle, byte data);

        [DllImport("DIDO_PFXPHMIP6_32.dll", CallingConvention = CallingConvention.Cdecl, SetLastError = true, CharSet = CharSet.Unicode)]
        internal static extern int SetDoutDefault(SafeFileHandle didoHandle, byte data);

        #endregion Methods
    }
}