﻿'
' Dido.vb
'
' This module contains difinition of DIDO_PFXPHMIP6_32.dll functions.
'
' Create date		: 2021.06.02.
'
' Copyright (C) 2021 Schneider Electric. All Rights Reserved.
'
'
Imports System.Runtime.InteropServices
Imports System.Text
Imports Microsoft.Win32.SafeHandles

Friend Class Constants

#Region "Fields"

    Friend Const DidoCounter0 As Integer = 0                   'Counter 0.
    Friend Const DidoCounter1 As Integer = 1                   'Counter 1.
    Friend Const DidoCounterDebounceDisable As Integer = 8     'Counter debounce disable.
    Friend Const DidoCounterDebounceEnable As Integer = 7      'Counter debounce enable.
    Friend Const DidoCounterModeBoth As Integer = 6            'Counter mode Both.
    Friend Const DidoCounterModeFalling As Integer = 5         'Counter mode Falling.
    Friend Const DidoCounterModeRising As Integer = 4          'Counter mode Rising.
    Friend Const DidoCounterReset As Integer = 0               'Reset Counter.
    Friend Const DidoCounterRestart As Integer = 3             'Restart Counter.
    Friend Const DidoCounterStart As Integer = 1               'Start Counter.
    Friend Const DidoCounterStop As Integer = 2                'Stop Counter.
    Friend Const DidoSlot1 = 1                                 'Option Interface Slot #1.
    Friend Const DidoSlot2 = 2                                 'Option Interface Slot #2.
    Friend Const SeriErrorCommHandle As Integer = &H10         'Handle Error.
    Friend Const SeriErrorCommMask As Integer = &H2            'Set comm mask Error.
    Friend Const SeriErrorCommNotReady As Integer = &H40       'Device Not ready Error.
    Friend Const SeriErrorCommParam As Integer = &H20          'Parameter Error.
    Friend Const SeriErrorCommState As Integer = &H8           'Set comm state Error.
    Friend Const SeriErrorCommTimeout As Integer = &H4         'Set comm timeout Error.
    Friend Const SeriErrorFail As Integer = -1                 'Error.
    Friend Const SeriErrorOk As Integer = &H0                  'No Error.
    Friend Const SeriErrorResponse As Integer = &H1            'Response Error.

#End Region

End Class

Friend Class NativeMethods

#Region "Methods"

    <DllImport("DIDO_PFXPHMIP6_32.dll", SetLastError:=True, CharSet:=CharSet.Unicode, CallingConvention:=CallingConvention.Cdecl)>
    Friend Shared Sub CloseDido(ByVal didoHandle As SafeFileHandle)
    End Sub

    <DllImport("DIDO_PFXPHMIP6_32.dll", SetLastError:=True, CharSet:=CharSet.Unicode, CallingConvention:=CallingConvention.Cdecl)>
    Friend Shared Function GetCounter(ByVal didoHandle As SafeFileHandle, ByVal counterId As Integer, ByRef data As UShort) As Integer
    End Function

    <DllImport("DIDO_PFXPHMIP6_32.dll", SetLastError:=True, CharSet:=CharSet.Unicode, CallingConvention:=CallingConvention.Cdecl)>
    Friend Shared Function GetDin(ByVal didoHandle As SafeFileHandle, ByRef data As UShort) As Integer
    End Function

    <DllImport("DIDO_PFXPHMIP6_32.dll", SetLastError:=True, CharSet:=CharSet.Unicode, CallingConvention:=CallingConvention.Cdecl)>
    Friend Shared Function GetDout(ByVal didoHandle As SafeFileHandle, ByRef data As Byte) As Integer
    End Function

    <DllImport("DIDO_PFXPHMIP6_32.dll", SetLastError:=True, CharSet:=CharSet.Unicode, CallingConvention:=CallingConvention.Cdecl)>
    Friend Shared Function GetFwVersion(ByVal didoHandle As SafeFileHandle, ByVal verBl As StringBuilder, ByVal verApp As StringBuilder) As Integer
    End Function

    <DllImport("DIDO_PFXPHMIP6_32.dll", SetLastError:=True, CharSet:=CharSet.Unicode, CallingConvention:=CallingConvention.Cdecl)>
    Friend Shared Function OpenDido(slotNo As Integer) As SafeFileHandle
    End Function

    <DllImport("DIDO_PFXPHMIP6_32.dll", SetLastError:=True, CharSet:=CharSet.Unicode, CallingConvention:=CallingConvention.Cdecl)>
    Friend Shared Function SetCounter(ByVal didoHandle As SafeFileHandle, ByVal counterId As Integer, ByVal control As Integer) As Integer
    End Function

    <DllImport("DIDO_PFXPHMIP6_32.dll", SetLastError:=True, CharSet:=CharSet.Unicode, CallingConvention:=CallingConvention.Cdecl)>
    Friend Shared Function SetDout(ByVal didoHandle As SafeFileHandle, ByVal data As Byte) As Integer
    End Function

    <DllImport("DIDO_PFXPHMIP6_32.dll", SetLastError:=True, CharSet:=CharSet.Unicode, CallingConvention:=CallingConvention.Cdecl)>
    Friend Shared Function SetDoutDefault(ByVal didoHandle As SafeFileHandle, ByVal data As Byte) As Integer
    End Function

#End Region

End Class