﻿//
// Form1.cs
//
// This module contains an example of how to use DIDO_PFXPHMIP6_32.dll.
//
// Create date		: 2021.06.02.
//
// Copyright (C) 2021 Schneider Electric. All Rights Reserved.
//
//
using Microsoft.Win32.SafeHandles;
using System;
using System.Windows.Forms;

namespace PFXPHMIP6_DIDO_SampleCode_CS
{
    public partial class Form1 : Form
    {
        #region Fields

        private SafeFileHandle didoHandle = null;
        private ushort dinData = 0;
        private byte doutData = 0;

        #endregion Fields

        #region Constructors

        public Form1()
        {
            InitializeComponent();
        }

        #endregion Constructors

        #region Methods

        /// <summary>
        /// DOUT setting change event handlers.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void checkBox0_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox0.Checked)
            {
                checkBox0.ImageIndex = 1;
                doutData |= 0x01;
            }
            else
            {
                checkBox0.ImageIndex = 0;
                doutData &= 0xfe;
            }
            checkBox0.Refresh();
            NativeMethods.SetDout(didoHandle, doutData);
        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox1.Checked)
            {
                checkBox1.ImageIndex = 1;
                doutData |= 0x02;
            }
            else
            {
                checkBox1.ImageIndex = 0;
                doutData &= 0xfd;
            }
            checkBox1.Refresh();
            NativeMethods.SetDout(didoHandle, doutData);
        }

        private void checkBox2_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox2.Checked)
            {
                checkBox2.ImageIndex = 1;
                doutData |= 0x04;
            }
            else
            {
                checkBox2.ImageIndex = 0;
                doutData &= 0xfb;
            }
            checkBox2.Refresh();
            NativeMethods.SetDout(didoHandle, doutData);
        }

        private void checkBox3_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox3.Checked)
            {
                checkBox3.ImageIndex = 1;
                doutData |= 0x08;
            }
            else
            {
                checkBox3.ImageIndex = 0;
                doutData &= 0xf7;
            }
            checkBox3.Refresh();
            NativeMethods.SetDout(didoHandle, doutData);
        }

        private void checkBox4_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox4.Checked)
            {
                checkBox4.ImageIndex = 1;
                doutData |= 0x10;
            }
            else
            {
                checkBox4.ImageIndex = 0;
                doutData &= 0xef;
            }
            checkBox4.Refresh();
            NativeMethods.SetDout(didoHandle, doutData);
        }

        private void checkBox5_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox5.Checked)
            {
                checkBox5.ImageIndex = 1;
                doutData |= 0x20;
            }
            else
            {
                checkBox5.ImageIndex = 0;
                doutData &= 0xdf;
            }
            checkBox5.Refresh();
            NativeMethods.SetDout(didoHandle, doutData);
        }

        private void checkBox6_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox6.Checked)
            {
                checkBox6.ImageIndex = 1;
                doutData |= 0x40;
            }
            else
            {
                checkBox6.ImageIndex = 0;
                doutData &= 0xbf;
            }
            checkBox6.Refresh();
            NativeMethods.SetDout(didoHandle, doutData);
        }

        private void checkBox7_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox7.Checked)
            {
                checkBox7.ImageIndex = 1;
                doutData |= 0x80;
            }
            else
            {
                checkBox7.ImageIndex = 0;
                doutData &= 0x7f;
            }
            checkBox7.Refresh();
            NativeMethods.SetDout(didoHandle, doutData);
        }

        /// <summary>
        /// Form close event handler for close the DIDO.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            if (!didoHandle.IsInvalid)
            {
                timer1.Enabled = false;
                NativeMethods.CloseDido(didoHandle);
                didoHandle.SetHandleAsInvalid();
            }
            if (!didoHandle.IsClosed)
            {
                didoHandle.Close();
            }
        }

        /// <summary>
        /// Form load event handler.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Form1_Load(object sender, EventArgs e)
        {
            // Open DIDO Slot1.
            //didoHandle = NativeMethods.OpenDido(Constants.DidoSlot1);
            // Open DIDO Slot2.
            didoHandle = NativeMethods.OpenDido(Constants.DidoSlot2);
            if (didoHandle.IsInvalid)
            {
                MessageBox.Show("Cannot open DIDO");
                this.Close();
            }
            else
            {
                // Get the current status of DOUT and DIN.
                NativeMethods.GetDout(didoHandle, ref doutData);
                UpdateDoutSwitch(doutData);
                NativeMethods.GetDin(didoHandle, ref dinData);
                UpdateDinLamp(dinData);
                timer1.Enabled = true;
            }
        }

        /// <summary>
        /// Timer handler for update DIN status.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void timer1_Tick(object sender, EventArgs e)
        {
            NativeMethods.GetDin(didoHandle, ref dinData);
            UpdateDinLamp(dinData);
        }

        /// <summary>
        /// Update the status of the DIN lamp.
        /// </summary>
        /// <param name="dinStatus"></param>
        private void UpdateDinLamp(int dinStatus)
        {
            for (var i = 0; i < 16; i++)
            {
                var mask = 1 << i;
                var data = dinStatus & mask;
                switch (mask)
                {
                    case 0x0001:
                        if (data != 0)
                        {
                            pictureBox0.Image = imageListLamp.Images[1];
                        }
                        else
                        {
                            pictureBox0.Image = imageListLamp.Images[0];
                        }
                        pictureBox0.Refresh();
                        break;

                    case 0x0002:
                        if (data != 0)
                        {
                            pictureBox1.Image = imageListLamp.Images[1];
                        }
                        else
                        {
                            pictureBox1.Image = imageListLamp.Images[0];
                        }
                        pictureBox1.Refresh();
                        break;

                    case 0x0004:
                        if (data != 0)
                        {
                            pictureBox2.Image = imageListLamp.Images[1];
                        }
                        else
                        {
                            pictureBox2.Image = imageListLamp.Images[0];
                        }
                        pictureBox2.Refresh();
                        break;

                    case 0x0008:
                        if (data != 0)
                        {
                            pictureBox3.Image = imageListLamp.Images[1];
                        }
                        else
                        {
                            pictureBox3.Image = imageListLamp.Images[0];
                        }
                        pictureBox3.Refresh();
                        break;

                    case 0x0010:
                        if (data != 0)
                        {
                            pictureBox4.Image = imageListLamp.Images[1];
                        }
                        else
                        {
                            pictureBox4.Image = imageListLamp.Images[0];
                        }
                        pictureBox4.Refresh();
                        break;

                    case 0x0020:
                        if (data != 0)
                        {
                            pictureBox5.Image = imageListLamp.Images[1];
                        }
                        else
                        {
                            pictureBox5.Image = imageListLamp.Images[0];
                        }
                        pictureBox5.Refresh();
                        break;

                    case 0x0040:
                        if (data != 0)
                        {
                            pictureBox6.Image = imageListLamp.Images[1];
                        }
                        else
                        {
                            pictureBox6.Image = imageListLamp.Images[0];
                        }
                        pictureBox6.Refresh();
                        break;

                    case 0x0080:
                        if (data != 0)
                        {
                            pictureBox7.Image = imageListLamp.Images[1];
                        }
                        else
                        {
                            pictureBox7.Image = imageListLamp.Images[0];
                        }
                        pictureBox7.Refresh();
                        break;

                    case 0x0100:
                        if (data != 0)
                        {
                            pictureBox8.Image = imageListLamp.Images[1];
                        }
                        else
                        {
                            pictureBox8.Image = imageListLamp.Images[0];
                        }
                        pictureBox8.Refresh();
                        break;

                    case 0x0200:
                        if (data != 0)
                        {
                            pictureBox9.Image = imageListLamp.Images[1];
                        }
                        else
                        {
                            pictureBox9.Image = imageListLamp.Images[0];
                        }
                        pictureBox9.Refresh();
                        break;

                    case 0x0400:
                        if (data != 0)
                        {
                            pictureBox10.Image = imageListLamp.Images[1];
                        }
                        else
                        {
                            pictureBox10.Image = imageListLamp.Images[0];
                        }
                        pictureBox10.Refresh();
                        break;

                    case 0x0800:
                        if (data != 0)
                        {
                            pictureBox11.Image = imageListLamp.Images[1];
                        }
                        else
                        {
                            pictureBox11.Image = imageListLamp.Images[0];
                        }
                        pictureBox11.Refresh();
                        break;

                    case 0x1000:
                        if (data != 0)
                        {
                            pictureBox12.Image = imageListLamp.Images[1];
                        }
                        else
                        {
                            pictureBox12.Image = imageListLamp.Images[0];
                        }
                        pictureBox12.Refresh();
                        break;

                    case 0x2000:
                        if (data != 0)
                        {
                            pictureBox13.Image = imageListLamp.Images[1];
                        }
                        else
                        {
                            pictureBox13.Image = imageListLamp.Images[0];
                        }
                        pictureBox13.Refresh();
                        break;

                    case 0x4000:
                        if (data != 0)
                        {
                            pictureBox14.Image = imageListLamp.Images[1];
                        }
                        else
                        {
                            pictureBox14.Image = imageListLamp.Images[0];
                        }
                        pictureBox14.Refresh();
                        break;

                    case 0x8000:
                        if (data != 0)
                        {
                            pictureBox15.Image = imageListLamp.Images[1];
                        }
                        else
                        {
                            pictureBox15.Image = imageListLamp.Images[0];
                        }
                        pictureBox15.Refresh();
                        break;

                    default:
                        break;
                }
            }
        }

        /// <summary>
        /// Update the status of the DOUT switch.
        /// </summary>
        /// <param name="doutStatus"></param>
        private void UpdateDoutSwitch(int doutStatus)
        {
            for (var i = 0; i < 8; i++)
            {
                var mask = 1 << i;
                var data = doutStatus & mask;
                switch (mask)
                {
                    case 0x01:
                        if (data != 0)
                        {
                            checkBox0.ImageIndex = 1;
                            checkBox0.Checked = true;
                        }
                        else
                        {
                            checkBox0.ImageIndex = 0;
                            checkBox0.Checked = false;
                        }
                        checkBox0.Refresh();
                        break;

                    case 0x02:
                        if (data != 0)
                        {
                            checkBox1.ImageIndex = 1;
                            checkBox1.Checked = true;
                        }
                        else
                        {
                            checkBox1.ImageIndex = 0;
                            checkBox1.Checked = false;
                        }
                        checkBox1.Refresh();
                        break;

                    case 0x04:
                        if (data != 0)
                        {
                            checkBox2.ImageIndex = 1;
                            checkBox2.Checked = true;
                        }
                        else
                        {
                            checkBox2.ImageIndex = 0;
                            checkBox2.Checked = false;
                        }
                        checkBox2.Refresh();
                        break;

                    case 0x08:
                        if (data != 0)
                        {
                            checkBox3.ImageIndex = 1;
                            checkBox3.Checked = true;
                        }
                        else
                        {
                            checkBox3.ImageIndex = 0;
                            checkBox3.Checked = false;
                        }
                        checkBox3.Refresh();
                        break;

                    case 0x10:
                        if (data != 0)
                        {
                            checkBox4.ImageIndex = 1;
                            checkBox4.Checked = true;
                        }
                        else
                        {
                            checkBox4.ImageIndex = 0;
                            checkBox4.Checked = false;
                        }
                        checkBox4.Refresh();
                        break;

                    case 0x20:
                        if (data != 0)
                        {
                            checkBox5.ImageIndex = 1;
                            checkBox5.Checked = true;
                        }
                        else
                        {
                            checkBox5.ImageIndex = 0;
                            checkBox5.Checked = false;
                        }
                        checkBox5.Refresh();
                        break;

                    case 0x40:
                        if (data != 0)
                        {
                            checkBox6.ImageIndex = 1;
                            checkBox6.Checked = true;
                        }
                        else
                        {
                            checkBox6.ImageIndex = 0;
                            checkBox6.Checked = false;
                        }
                        checkBox6.Refresh();
                        break;

                    case 0x80:
                        if (data != 0)
                        {
                            checkBox7.ImageIndex = 1;
                            checkBox7.Checked = true;
                        }
                        else
                        {
                            checkBox7.ImageIndex = 0;
                            checkBox7.Checked = false;
                        }
                        checkBox7.Refresh();
                        break;

                    default:
                        break;
                }
            }
        }

        #endregion Methods
    }
}