/*
********************************************************************************
**    INTEL CONFIDENTIAL                                                      **
**    Copyright Intel Corporation All Rights Reserved                         **
********************************************************************************
**                                                                            **
** The source code contained or described herein and all documents related to **
** the source code ("Material") are owned by Intel Corporation or its         **
** suppliers or licensors. Title to the Material remains with Intel           **
** Corporation or its suppliers and licensors. The Material contains trade    **
** secrets and proprietary and confidential information of Intel or its       **
** suppliers and licensors. The Material is protected by worldwide copyright  **
** and trade secret laws and treaty provisions. No part of the Material may   **
** be used, copied,reproduced, modified, published, uploaded, posted,         **
** transmitted, distributed, or disclosed in any way without Intel's prior    **
** express written permission.                                                **
**                                                                            **
** No license under any patent, copyright, trade secret or other intellectual **
** property right is granted to or conferred upon you by disclosure or        **
** delivery of the Materials, either expressly, by implication, inducement,   **
** estoppel or otherwise. Any license under such intellectual property        **
** rights must be express and approved by Intel in writing.                   **
**                                                                            **
********************************************************************************
*/
#pragma once

/**
* @file OptaneTypes.h
* Contains definition of externally available PinApi structures and enums
*/

#define OPTANE_VOL_NAME_SZ 8

#define OPTANE_SUPPORTED_APPS_DIR L"SupportedApps"
#define OPTANE_SUPPORTED_APPS_DIR_LOCATION L"%CommonProgramFiles%\\Intel\\Intel Optane Memory\\SupportedApps"

typedef enum
{
    ///Operation completed successfully
    OPTANE_SUCCESS,
    ///RST Optane component internal error
    OPTANE_INTERNAL_ERROR,
    ///Path/file name cannot be parsed correctly
    OPTANE_PARSE_ERROR,
    ///Path or file name contains a forbidden character
    OPTANE_WRONG_CHAR,
    ///File not found
    OPTANE_FILE_NOT_FOUND,
    ///Directory not found
    OPTANE_DIRECTORY_NOT_FOUND,
    ///Application not found
    OPTANE_APP_NOT_FOUND,
    ///Access was denied to file/directory/object
    OPTANE_WRONG_ACCESS_RIGHTS,
    ///Large temporary file for ISV application cannot be created
    OPTANE_TMP_FILE_CREATION_ERROR,
    ///File Cache is full of user pinned files
    OPTANE_FILE_CACHE_FULL,
    ///Predefined percentage of the File Cache is full of user pinned files
    OPTANE_FILE_CACHE_ALMOST_FULL,
    ///Not enough space in the File Cache to satisfy pinning request
    OPTANE_NO_SPACE_IN_CACHE,
    ///If the allocated buffer is not large enough to hold the returned data
    OPTANE_MORE_DATA,
    ///Path/file name point outside the fast and the slow drive 
    ///that are forming the Optane logical volume
    OPTANE_WRONG_LOCATION,
    ///Pinning API function was called with wrong parameters
    OPTANE_INVALID_PARAMETER,
    ///Command could not execute as Optane binaries are in a wrong
    ///state (for instance initializing, closing)
    OPTANE_NOT_READY,
    ///Access to a resource is denied
    OPTANE_ACCESS_DENIED,
    ///Request executed properly but not all files were processed succesfully
    OPTANE_INDIVIDUAL_FILE_ERROR,
    ///Incompatible versions of platform pinning API and DLL pinnining API
    OPTANE_INVALID_VERSION,
    ///Not supported architecture or platform
    OPTANE_NOT_SUPPORTED
} OPTANERETCODE;

typedef enum
{
    ///Pinning can be used
    OPTANE_PINNING_INACTIVE,
    ///Pinning cannot be used 
    OPTANE_PINNING_ACTIVE
} OPTANE_PINNING_CAPABILITY;

typedef struct
{
    ///Status of pinning (if it is avaible)
    OPTANE_PINNING_CAPABILITY pinningStatus;
    /// Optane volume name. This parameter has valid value when
    /// Optane pinning state is OPTANE_PINNING_ACTIVE.
    wchar_t optaneVolumeName[OPTANE_VOL_NAME_SZ];
} OPTANE_PINNINGINFO;

typedef struct
{
    /// Will be set to error if file operation failed, otherwise OPTANE_SUCCESS
    OPTANERETCODE fileError;
    /// File path
    const wchar_t* path;
} OPTANE_FILE;

typedef struct
{
    ///Number of files to pin or unpin
    unsigned int size;
    ///List of paths to pin or unpin with per-file errors.
    OPTANE_FILE* data;
} OPTANE_FILELIST;

typedef enum
{
    ///File is pinned. File is in cache or will be migrated into cache
    OPTANE_PINNED,
    /// File is not pinned. Optane algorithms and polices are applied to this file
    OPTANE_NORMAL
} OPTANE_PINNING_STATE;

typedef enum
{
    ///File is located on the slow drive.
    OPTANE_UNCACHED,
    /// Part of the file is located on the fast drive and the
    /// remaining part is on the slow drive.
    OPTANE_PARTIALLY_CACHED,
    ///File is located on the fast drive
    OPTANE_CACHED
} OPTANE_CACHING_STATUS;

typedef struct
{
    /// Operation return code for file pointed by provided path.
    OPTANERETCODE pathError;
    ///Full path to file
    const wchar_t* path;
    ///File caching status
    OPTANE_PINNING_STATE cachingState;
    ///File location status
    OPTANE_CACHING_STATUS locationState;
} OPTANE_FILEPINSTATUS;

typedef struct
{
    /// Number of files/entries provided in listOfFileStatus array
    unsigned int size;
    /// Pointer to array of file pinning status structures
    OPTANE_FILEPINSTATUS* listOfFileStatus;
} OPTANE_FILEPINSTATUSLIST;

typedef struct
{
    /// Size [B] of the file cache (size of the fast drive minus 
    /// block cache size)
    unsigned __int64 fileCacheSize;

    /// Total size [B] of space that is occupied by files in the file
    /// cache (including system files)
    unsigned __int64 usedSpace;

    /// Number of files in the file cache (including partially cached
    /// files)
    unsigned __int64 nrCachedFiles;
    /// Number of all files pinned by the user. 
    unsigned __int64 nrUserPinnedFiles;
    /// Number of files pinned by the user and located in the file cache
    unsigned __int64 nrUserCachedFiles;
    /// Size [B] of files pinned by user and located in the file cache
    unsigned __int64 sizeUserCachedFiles;
    /// Size [B] of files pinned by the user and located on the slow drive
    unsigned __int64 sizeUserUnCachedFiles;
    /// Number of files pinned by ISV Applications and user pinned applications
    unsigned __int64 nrAppPinnedFiles;
    /// Number of files pinned by ISV Applications and user
    /// pinned applications located in the file cache
    unsigned __int64 nrAppCachedFiles;
    /// Size [B] of files pinned by ISV Applications and user
    /// pinned applications located in the file cache
    unsigned __int64 sizeAppCachedFiles;
    /// Size [B] of files pinned by ISV Applications and user 
    /// pinned applications located on the slow drive
    unsigned __int64 sizeAppUnCachedFiles;
    /// Number of files migrated to the file cache as a result of
    /// Optane algorithms and polices
    unsigned __int64 nrAutoCachedFiles;
    /// Size [B] of files migrated to the file cache as a result of
    /// Optane algorithms and polices
    unsigned __int64 sizeAutoCacheFiles;
    /// Size [B] of system files migrated to the file cache
    /// as a result of NGSA algorithms and polices
    unsigned __int64 sizeSystemCacheFiles;
} OPTANE_FILECACHESTATUS;

typedef struct OPTANE_PINNINGAPIVERSION
{
    /// Optane Pinning API version supported by DLL � major number.
    /// No backwards-compatible API changes. Removing obsolete
    /// function or data type for example.
    unsigned long major;
    /// Optane Pinning API version supported by DLL � minor number.
    /// New functionality added in a backward compatible manner. Bug
    /// fixes, adding new function or data type but still supporting
    /// old one.
    unsigned long minor;
    /// Pinning API version supported by platform � major number.
    unsigned long platformMajor;
    /// Pinning API version supported by platform � minor number.
    unsigned long platformMinor;
    /// DLL API is compatible with platform API if 
    /// (major == platformMajor) && (platformMinor > minor)
} OPTANE_PINNINGAPIVERSION;