//////////////////////////////////////////////////////////////////////////////////////////
///
///	@file	RAS_Data_Index.h
///
///	@brief	This module contains difinition of RAS Data Index.
///
///	@date	Last modify date	: 2020.12.17.
///
///	@copyright	Copyright (C) 2020 Schneider Electric. All Rights Reserved.
///
///////////////////////////////////////////////////////////////////////////////////////////
#pragma once

enum RAS_DATA_INDEX
{
	RDI_Lib_Ver,			//!< Lib version.
	RDI_Temp_Mb_Min,		//!< MB minimum temparature log data.
	RDI_Temp_Mb_Current,	//!< MB tempareture.
	RDI_Temp_Mb_Max,		//!< MB maximum temparature log data.
	RDI_Temp_Cpu_Min,		//!< CPU minimum temparature log data.
	RDI_Temp_Cpu_Current,	//!< CPU tempareture.
	RDI_Temp_Cpu_Max,		//!< CPU maximum temparature log data.
	RDI_Temp_Cpu_Dts1,		//!< CPU core 1 DTS.
	RDI_Temp_Cpu_Dts2,		//!< CPU core 2 DTS.
	RDI_Temp_Cpu_Dts3,		//!< CPU core 3 DTS.
	RDI_Temp_Cpu_Dts4,		//!< CPU core 4 DTS.
	RDI_Temp_Cpu_Dts5,		//!< CPU core 5 DTS.
	RDI_Temp_Cpu_Dts6,		//!< CPU core 6 DTS.
	RDI_Temp_Cpu_Dts7,		//!< CPU core 7 DTS.
	RDI_Temp_Cpu_Dts8,		//!< CPU core 8 DTS.
	RDI_Temp_Hdd_Min,		//!< HDD minimum temparature log data.
	RDI_Temp_Hdd_Current,	//!< HDD tempareture.
	RDI_Temp_Hdd_Max,		//!< HDD maximum temparature log data.
	RDI_Volt_5VSTB,			//!< 5VSTB voltage.
	RDI_Volt_5V,			//!< 5V voltage.
	RDI_Volt_12V,			//!< 12V voltage.
	RDI_Volt_33V,			//!< 3.3V voltage.
	RDI_Mcu_Ver,			//!< MCU version number.
	RDI_Mcu_Poh,			//!< MCU power-on hours.
	RDI_Mcu_Mcot,			//!< MCU most continious power-on time.
	RDI_Mcu_Pwon_Count,		//!< MCU power on counts.
	RDI_Wdt_Counter,		//!< WDT counter.
	RDI_Wdt_Status,			//!< WDT status.
	RDI_Wdt_Reset_Mask,		//!< WDT reset mask.
	RDI_Psu_Watt,			//!< PSU watt value.
	RDI_Psu_Current,		//!< PSU current value.
	RDI_Num_data			//!< Number of data
};
