// SPDX-License-Identifier: GPL-2.0 or Linux-OpenIB
/* Copyright (c) 2015 - 2021 Intel Corporation */
#include "osdep.h"
#include "status.h"
#include "hmc.h"
#include "defs.h"
#include "type.h"
#include "protos.h"
#include "vf.h"

/**
 * irdma_manage_vf_pble_bp - manage vf pble
 * @cqp: cqp for cqp' sq wqe
 * @info: pble info
 * @scratch: pointer for completion
 * @post_sq: to post and ring
 */
enum irdma_status_code
irdma_manage_vf_pble_bp(struct irdma_sc_cqp *cqp,
			struct irdma_manage_vf_pble_info *info,
			u64 scratch,
			bool post_sq)
{
	u64 *wqe;
	u64 temp, hdr, pd_pl_pba;

	wqe = irdma_sc_cqp_get_next_send_wqe(cqp, scratch);
	if (!wqe)
		return IRDMA_ERR_RING_FULL;

	temp = LS_64(info->pd_entry_cnt, IRDMA_CQPSQ_MVPBP_PD_ENTRY_CNT) |
	    LS_64(info->first_pd_index, IRDMA_CQPSQ_MVPBP_FIRST_PD_INX) |
	    LS_64(info->sd_index, IRDMA_CQPSQ_MVPBP_SD_INX);
	set_64bit_val(wqe, 16, temp);

	pd_pl_pba = LS_64(info->pd_pl_pba >> 3, IRDMA_CQPSQ_MVPBP_PD_PLPBA);
	set_64bit_val(wqe, 32, pd_pl_pba);

	hdr = LS_64((info->inv_pd_ent ? 1 : 0), IRDMA_CQPSQ_MVPBP_INV_PD_ENT) |
	    LS_64(IRDMA_CQP_OP_MANAGE_VF_PBLE_BP, IRDMA_CQPSQ_OPCODE) |
	    LS_64(cqp->polarity, IRDMA_CQPSQ_WQEVALID);

	dma_wmb();	/* make sure WQE is populated before valid bit is set */
	set_64bit_val(wqe, 24, hdr);

	print_hex_dump_debug("WQE: MANAGE VF_PBLE_BP WQE", DUMP_PREFIX_OFFSET,
			     16, 8, wqe, IRDMA_CQP_WQE_SIZE * 8, false);

	if (post_sq)
		irdma_sc_cqp_post_sq(cqp);
	return 0;
}

