/*******************************************************************************
*
* Copyright (c) 2015-2019 Intel Corporation.  All rights reserved.
*
* This software is available to you under a choice of one of two
* licenses.  You may choose to be licensed under the terms of the GNU
* General Public License (GPL) Version 2, available from the file
* COPYING in the main directory of this source tree, or the
* OpenFabrics.org BSD license below:
*
*   Redistribution and use in source and binary forms, with or
*   without modification, are permitted provided that the following
*   conditions are met:
*
*    - Redistributions of source code must retain the above
*	copyright notice, this list of conditions and the following
*	disclaimer.
*
*    - Redistributions in binary form must reproduce the above
*	copyright notice, this list of conditions and the following
*	disclaimer in the documentation and/or other materials
*	provided with the distribution.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
* BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
* ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*
*******************************************************************************/
/*$FreeBSD$*/

#ifndef _IW_IXL_LINUX_GENALLOC_H_
#define _IW_IXL_LINUX_GENALLOC_H_

#define gen_pool_create(s, n) \
		i40iw_gen_pool_create((s))
#define gen_pool_destroy(p) \
		i40iw_gen_pool_destroy((p))
#define gen_pool_add_virt(p, v, ph, s, n) \
		i40iw_gen_pool_add_virt((p), (v), (ph), (s))
#define gen_pool_alloc(p, s) \
		i40iw_gen_pool_alloc((p), (s))
#define gen_pool_free(p, a, s) \
		i40iw_gen_pool_free((p), (a), (s))
#define gen_pool_virt_to_phys(p, a) \
		i40iw_gen_pool_virt_to_phys((p), (a))

#define I40IW_GEN_POOL_BLK_CNT(size, shift) \
		(((size) + (1 << (shift)) - 1) >> (shift))

struct gen_pool *i40iw_gen_pool_create(int);
void   i40iw_gen_pool_destroy(struct gen_pool *);
int    i40iw_gen_pool_add_virt(struct gen_pool *, unsigned long, phys_addr_t, size_t);
unsigned long i40iw_gen_pool_alloc(struct gen_pool *, size_t);
void   i40iw_gen_pool_free(struct gen_pool *, unsigned long, size_t);
phys_addr_t i40iw_gen_pool_virt_to_phys(struct gen_pool *, unsigned long);

#endif				/* _IW_IXL_LINUX_GENALLOC_H_ */
