/*
**   
INTEL CONFIDENTIAL
Copyright 2005-2014 Intel Corporation All Rights Reserved.

The source code contained or described herein and all documents
related to the source code ("Material") are owned by Intel Corporation
or its suppliers or licensors. Title to the Material remains with
Intel Corporation or its suppliers and licensors. The Material
contains trade secrets and proprietary and confidential information of
Intel or its suppliers and licensors. The Material is protected by
worldwide copyright and trade secret laws and treaty provisions. No
part of the Material may be used, copied, reproduced, modified,
published, uploaded, posted, transmitted, distributed, or disclosed in
any way without Intel's prior express written permission.

No license under any patent, copyright, trade secret or other
intellectual property right is granted to or conferred upon you by
disclosure or delivery of the Materials, either expressly, by
implication, inducement, estoppel or otherwise. Any license under such
intellectual property rights must be express and approved by Intel in
writing.
**
**/
/**                                                                            
********************************************************************************
**
**    @file ver.h
**
**    @brief Contains definitions of the MAJOR, MINOR, & HOTFIX versions used
**           throughout the code.
**
**    @author Christopher Spiegel and John Traver
**
********************************************************************************
*/   

/* Sentry Header
 *****************/
#ifndef _VER_H_
#define _VER_H_

#if CSE_SPS_CONF_ENABLE

/* Include Files
 *****************/
#include "Build.h"
//#include "typedef.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Global Declarations
 **************************/

/* Version and definitions */
// Default is 11.0

//

// 11.0 DEFINITIONS
//
#define CNL_VER_MAJOR          12    /**< Major Version */
#define CNL_VER_MAJOR_STR     "12"   /**< Major Version String */
#define ICL_VER_MAJOR          13    /**< Major Version */
#define ICL_VER_MAJOR_STR     "13"   /**< Major Version String */
#define LKF_VER_MAJOR          6    /**< Major Version */
#define LKF_VER_MAJOR_STR     "6"   /**< Major Version String */

#if defined (CHIPSET_TYPE_ICP)
#define VER_MAJOR         ICL_VER_MAJOR    /**< Major Version */
#define VER_MAJOR_STR     ICL_VER_MAJOR_STR   /**< Major Version String */
#elif defined  (CHIPSET_TYPE_LKF)

#define VER_MAJOR         LKF_VER_MAJOR    /**< Major Version */
#define VER_MAJOR_STR     LKF_VER_MAJOR_STR   /**< Major Version String */
#else

#define VER_MAJOR         CNL_VER_MAJOR    /**< Major Version */
#define VER_MAJOR_STR     CNL_VER_MAJOR_STR   /**< Major Version String */
#endif
#define VER_MINOR          0   /**< Minor Version */
#define VER_MINOR_STR     "0"   /**< Minor Version String*/
#define VER_HOTFIX         0    /**< Default Hotfix Version */
#define VER_HOTFIX_STR    "0"   /**< Default Hotfix Version String */

#define VER_SEPARATOR_STR "."   /**< Separator String used between major, minor, hotfix and build strings */

/* Flags set based on build type */
#if DBG
/** Define "DBG" string that is attached to version string when DBG build */
#define VER_DEBUG_TAG   " (DBG)"
#else
/** Define string that is attached to version string when release build */
#define VER_DEBUG_TAG   
#endif


/** Combined file version information  */
#define VERSION_STR VER_MAJOR_STR VER_SEPARATOR_STR VER_MINOR_STR VER_SEPARATOR_STR VER_HOTFIX_STR VER_SEPARATOR_STR VER_BUILD_STR VER_DEBUG_TAG

/** @brief Defines a generic version structure used in the software build process. This structure will be used to
*   represent versions of ROM, FW and Recovery modules.
*/
typedef struct _VERSION
{
   UINT16      Major;
   UINT16      Minor;
   UINT16      Hotfix;
   UINT16      Build;
}VERSION;

#define VER_PRODUCTVERSION          VER_MAJOR,VER_MINOR,VER_HOTFIX,VER_BUILD
#define VER_PRODUCTVERSION_STR      VERSION_STR


/**  Adding the current year date string for use in updating the year component of the 
***  displayed copyright message.
***  the string needs to be the full 4 char value without spaces or special characters.
***  For example:
***        "2012"
*/
#define CURRENT_YEAR_STRING   "2017"

#ifdef __cplusplus
}
#endif

#endif

#endif // _VER_H_

