/*
********************************************************************************
**    INTEL CONFIDENTIAL                                                      **
**    Copyright Intel Corporation All Rights Reserved                         **
********************************************************************************
**                                                                            **
** The source code contained or described herein and all documents related to **
** the source code ("Material") are owned by Intel Corporation or its         **
** suppliers or licensors. Title to the Material remains with Intel           **
** Corporation or its suppliers and licensors. The Material contains trade    **
** secrets and proprietary and confidential information of Intel or its       **
** suppliers and licensors. The Material is protected by worldwide copyright  **
** and trade secret laws and treaty provisions. No part of the Material may   **
** be used, copied,reproduced, modified, published, uploaded, posted,         **
** transmitted, distributed, or disclosed in any way without Intel's prior    **
** express written permission.                                                **
**                                                                            **
** No license under any patent, copyright, trade secret or other intellectual **
** property right is granted to or conferred upon you by disclosure or        **
** delivery of the Materials, either expressly, by implication, inducement,   **
** estoppel or otherwise. Any license under such intellectual property        **
** rights must be express and approved by Intel in writing.                   **
**                                                                            **
********************************************************************************
*/
#pragma once

/**
* @file Optane.h
* Contains definition of externally available PinApi methods
*/

#define OPTANE_PIN_API_MAJ_VERSION 1
#define OPTANE_PIN_API_MIN_VERSION 2

#include "OptaneTypes.h"

#ifdef OPTANE_API_EXPORTS
#define PIN_API __declspec(dllexport) 
#else
#define PIN_API __declspec(dllimport) 
#endif


#ifdef OPTANE_DFP //Intel internal use
namespace OptaneApiDfp
{
#else
#ifdef __cplusplus
extern "C"
{
#endif
#endif
    /**
    * @brief Method provides the current state of Optane pinning.
    * @param [out] *status:                 Pointer to a Pinning Status information structure.
    * @retval SUCCESS                       When status is returned successfully.
    * @retval INVALID_PARAMETER             When the provided OPTANE_PINNINGINFO *status is a nullptr.
    * @retval OPTANE_INTERNAL_ERROR         When the error is caused by one of the RST Optane component's internal issue.
    */
    PIN_API  OPTANERETCODE OptaneGetPinningStatus(OPTANE_PINNINGINFO * status);
    typedef  OPTANERETCODE(*OptaneGetPinningStatusFunc)(OPTANE_PINNINGINFO * status);
    /**
    * @brief Method serves to soft pin files to the NGSA file cache.
    * @param [in|out] list:                 Structure that contains path or paths to pinned files with error codes.
    * @retval SUCCESS                       When the file was pinned successfully .
    * @retval INVALID_PARAMETER             When the provided pointer to the list of paths is a nullptr.
    * @retval OPTANE_INTERNAL_ERROR         When the error is caused by one of the RST Optane component's internal issue.
    */
    PIN_API  OPTANERETCODE OptanePinFiles(OPTANE_FILELIST list);
    typedef  OPTANERETCODE(*OptanePinFilesFunc)(OPTANE_FILELIST list);
    /**
    * @brief Method serves to unpin files from the NGSA file cache.
    * @param [in|out] list:                 Structure that contains path or paths to pinned files with error codes.
    * @retval SUCCESS                       When the file was unpinned successfully .
    * @retval INVALID_PARAMETER             When the provided pointer to the list of paths is a nullptr.
    * @retval OPTANE_INTERNAL_ERROR         When the error is caused by one of the RST Optane component's internal issue.
    */
    PIN_API  OPTANERETCODE OptaneUnpinFiles(OPTANE_FILELIST list);
    typedef  OPTANERETCODE(*OptaneUnPinFilesFunc)(OPTANE_FILELIST list);
    /**
    * @brief Method gets pin status of a single file or of a list of files.
    * @param [in|out] list:                 Structure that contains path or paths to files with space for pin status of each file.
    * @retval SUCCESS                       When status was returned successfully.
    * @retval INVALID_PARAMETER             When the provided pointer OPTANE_FILEPINSTATUS* listOfFileStatus is a nullptr.
    * @retval OPTANE_INDIVIDUAL_FILE_ERROR  When there are some file errors.
    * @retval OPTANE_INTERNAL_ERROR         When the error is caused by one of the RST Optane components' internal issue.
    */
    PIN_API  OPTANERETCODE OptaneGetPinStatusFiles(OPTANE_FILEPINSTATUSLIST list);
    typedef  OPTANERETCODE(*OptaneGetPinStatusFilesFunc)(OPTANE_FILEPINSTATUSLIST list);
    /**
    * @brief Method forces a migration procedure. It triggers the NGSA migration task.
    * @retval SUCCESS                       When migration trigger request was sent successfully.
    * @retval OPTANE_NOT_READY              When the NGSA service is still busy.
    * @retval OPTANE_INTERNAL_ERROR         When the error is caused by one of the RST Optane component's internal issue.
    */
    PIN_API  OPTANERETCODE OptaneTriggerMigration(void);
    typedef  OPTANERETCODE(*OptaneTriggerMigrationFunc)(void);
    /**
    * @brief Method gets the file cache status.
    * @param [out] *FileCacheStatus:        Pointer to an allocated area for the File Cache Status data.
    * @retval SUCCESS                       When file cache status was returned successfully.
    * @retval INVALID_PARAMETER             When provided OPTANE_FILECACHESTATUS *fileCacheStatus is a nullptr.
    * @retval OPTANE_INTERNAL_ERROR         When the error is caused by one of the RST Optane component's internal issue.
    */
    PIN_API  OPTANERETCODE OptaneGetFileCacheStatus(OPTANE_FILECACHESTATUS *fileCacheStatus);
    typedef  OPTANERETCODE(*OptaneGetFileCacheStatusFunc)(OPTANE_FILECACHESTATUS *fileCacheStatus);

    /**
    * @brief Method returns pinning API version.
    * @param [out] *PinningApiVersion:      Pointer to allocated area for Pinning API version data.
    * @retval SUCCESS                       When pinning api version was returned successfully.
    * @retval INVALID_PARAMETER             When provided OPTANE_PINNINGAPIVERSION *pinningApiVersion is a nullptr.
    */
    PIN_API  OPTANERETCODE OptaneGetPinningApiVersion(OPTANE_PINNINGAPIVERSION *pinningApiVersion);
    typedef  OPTANERETCODE(*OptaneGetPinningApiVersionFunc)(OPTANE_PINNINGAPIVERSION *pinningApiVersion);

#if defined (__cplusplus) || defined (OPTANE_DFP)
}
#endif